/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lib;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.events.ConfigChangedEvent;
import org.eclipse.jgit.events.ConfigChangedListener;
import org.eclipse.jgit.events.ListenerHandle;
import org.eclipse.jgit.events.ListenerList;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.ConfigLine;
import org.eclipse.jgit.lib.ConfigSnapshot;
import org.eclipse.jgit.lib.DefaultTypedConfigGetter;
import org.eclipse.jgit.lib.TypedConfigGetter;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.util.RawParseUtils;

public class Config {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    static final long KiB = 1024L;
    static final long MiB = 0x100000L;
    static final long GiB = 0x40000000L;
    private static final int MAX_DEPTH = 10;
    private static final TypedConfigGetter DEFAULT_GETTER;
    private static TypedConfigGetter typedGetter;
    private final ListenerList listeners = new ListenerList();
    private final AtomicReference<ConfigSnapshot> state;
    private final Config baseConfig;
    static final String MAGIC_EMPTY_VALUE;

    public Config() {
        this(null);
    }

    public Config(Config defaultConfig) {
        this.baseConfig = defaultConfig;
        this.state = new AtomicReference<ConfigSnapshot>(this.newState());
    }

    public static void setTypedConfigGetter(TypedConfigGetter getter) {
        typedGetter = getter == null ? DEFAULT_GETTER : getter;
    }

    static String escapeValue(String x) {
        if (x.isEmpty()) {
            return "";
        }
        boolean needQuote = x.charAt(0) == ' ' || x.charAt(x.length() - 1) == ' ';
        StringBuilder r = new StringBuilder(x.length());
        block9: for (int k = 0; k < x.length(); ++k) {
            char c = x.charAt(k);
            switch (c) {
                case '\u0000': {
                    throw new IllegalArgumentException(JGitText.get().configValueContainsNullByte);
                }
                case '\n': {
                    r.append('\\').append('n');
                    continue block9;
                }
                case '\t': {
                    r.append('\\').append('t');
                    continue block9;
                }
                case '\b': {
                    r.append('\\').append('b');
                    continue block9;
                }
                case '\\': {
                    r.append('\\').append('\\');
                    continue block9;
                }
                case '\"': {
                    r.append('\\').append('\"');
                    continue block9;
                }
                case '#': 
                case ';': {
                    needQuote = true;
                    r.append(c);
                    continue block9;
                }
                default: {
                    r.append(c);
                }
            }
        }
        return needQuote ? '\"' + r.toString() + '\"' : r.toString();
    }

    static String escapeSubsection(String x) {
        if (x.isEmpty()) {
            return "\"\"";
        }
        StringBuilder r = new StringBuilder(x.length() + 2).append('\"');
        block5: for (int k = 0; k < x.length(); ++k) {
            char c = x.charAt(k);
            switch (c) {
                case '\u0000': {
                    throw new IllegalArgumentException(JGitText.get().configSubsectionContainsNullByte);
                }
                case '\n': {
                    throw new IllegalArgumentException(JGitText.get().configSubsectionContainsNewline);
                }
                case '\"': 
                case '\\': {
                    r.append('\\').append(c);
                    continue block5;
                }
                default: {
                    r.append(c);
                }
            }
        }
        return r.append('\"').toString();
    }

    public int getInt(String section, String name2, int defaultValue) {
        return typedGetter.getInt(this, section, null, name2, defaultValue);
    }

    public int getInt(String section, String subsection, String name2, int defaultValue) {
        return typedGetter.getInt(this, section, subsection, name2, defaultValue);
    }

    public long getLong(String section, String name2, long defaultValue) {
        return typedGetter.getLong(this, section, null, name2, defaultValue);
    }

    public long getLong(String section, String subsection, String name2, long defaultValue) {
        return typedGetter.getLong(this, section, subsection, name2, defaultValue);
    }

    public boolean getBoolean(String section, String name2, boolean defaultValue) {
        return typedGetter.getBoolean(this, section, null, name2, defaultValue);
    }

    public boolean getBoolean(String section, String subsection, String name2, boolean defaultValue) {
        return typedGetter.getBoolean(this, section, subsection, name2, defaultValue);
    }

    public <T extends Enum<?>> T getEnum(String section, String subsection, String name2, T defaultValue) {
        Enum[] all = Config.allValuesOf(defaultValue);
        return (T)typedGetter.getEnum(this, all, section, subsection, name2, defaultValue);
    }

    private static <T> T[] allValuesOf(T value) {
        try {
            return (Object[])value.getClass().getMethod("values", new Class[0]).invoke(null, new Object[0]);
        }
        catch (Exception err) {
            String typeName = value.getClass().getName();
            String msg = MessageFormat.format(JGitText.get().enumValuesNotAvailable, typeName);
            throw new IllegalArgumentException(msg, err);
        }
    }

    public <T extends Enum<?>> T getEnum(T[] all, String section, String subsection, String name2, T defaultValue) {
        return (T)typedGetter.getEnum(this, (Enum[])all, section, subsection, name2, defaultValue);
    }

    public String getString(String section, String subsection, String name2) {
        return this.getRawString(section, subsection, name2);
    }

    public String[] getStringList(String section, String subsection, String name2) {
        String[] base = this.baseConfig != null ? this.baseConfig.getStringList(section, subsection, name2) : EMPTY_STRING_ARRAY;
        String[] self = this.getRawStringList(section, subsection, name2);
        if (self == null) {
            return base;
        }
        if (base.length == 0) {
            return self;
        }
        String[] res2 = new String[base.length + self.length];
        int n = base.length;
        System.arraycopy(base, 0, res2, 0, n);
        System.arraycopy(self, 0, res2, n, self.length);
        return res2;
    }

    public long getTimeUnit(String section, String subsection, String name2, long defaultValue, TimeUnit wantUnit) {
        return typedGetter.getTimeUnit(this, section, subsection, name2, defaultValue, wantUnit);
    }

    public List<RefSpec> getRefSpecs(String section, String subsection, String name2) {
        return typedGetter.getRefSpecs(this, section, subsection, name2);
    }

    public Set<String> getSubsections(String section) {
        return this.getState().getSubsections(section);
    }

    public Set<String> getSections() {
        return this.getState().getSections();
    }

    public Set<String> getNames(String section) {
        return this.getNames(section, null);
    }

    public Set<String> getNames(String section, String subsection) {
        return this.getState().getNames(section, subsection);
    }

    public Set<String> getNames(String section, boolean recursive) {
        return this.getState().getNames(section, null, recursive);
    }

    public Set<String> getNames(String section, String subsection, boolean recursive) {
        return this.getState().getNames(section, subsection, recursive);
    }

    public <T> T get(SectionParser<T> parser) {
        ConfigSnapshot myState = this.getState();
        Object obj = myState.cache.get(parser);
        if (obj == null) {
            obj = parser.parse(this);
            myState.cache.put(parser, obj);
        }
        return (T)obj;
    }

    public void uncache(SectionParser<?> parser) {
        this.state.get().cache.remove(parser);
    }

    public ListenerHandle addChangeListener(ConfigChangedListener listener) {
        return this.listeners.addConfigChangedListener(listener);
    }

    protected boolean notifyUponTransientChanges() {
        return true;
    }

    protected void fireConfigChangedEvent() {
        this.listeners.dispatch(new ConfigChangedEvent());
    }

    String getRawString(String section, String subsection, String name2) {
        String[] lst = this.getRawStringList(section, subsection, name2);
        if (lst != null) {
            return lst[lst.length - 1];
        }
        if (this.baseConfig != null) {
            return this.baseConfig.getRawString(section, subsection, name2);
        }
        return null;
    }

    private String[] getRawStringList(String section, String subsection, String name2) {
        return this.state.get().get(section, subsection, name2);
    }

    private ConfigSnapshot getState() {
        ConfigSnapshot base;
        ConfigSnapshot upd;
        ConfigSnapshot cur;
        do {
            cur = this.state.get();
            base = this.getBaseState();
            if (cur.baseState != base) continue;
            return cur;
        } while (!this.state.compareAndSet(cur, upd = new ConfigSnapshot(cur.entryList, base)));
        return upd;
    }

    private ConfigSnapshot getBaseState() {
        return this.baseConfig != null ? this.baseConfig.getState() : null;
    }

    public void setInt(String section, String subsection, String name2, int value) {
        this.setLong(section, subsection, name2, value);
    }

    public void setLong(String section, String subsection, String name2, long value) {
        String s = value >= 0x40000000L && value % 0x40000000L == 0L ? String.valueOf(value / 0x40000000L) + "g" : (value >= 0x100000L && value % 0x100000L == 0L ? String.valueOf(value / 0x100000L) + "m" : (value >= 1024L && value % 1024L == 0L ? String.valueOf(value / 1024L) + "k" : String.valueOf(value)));
        this.setString(section, subsection, name2, s);
    }

    public void setBoolean(String section, String subsection, String name2, boolean value) {
        this.setString(section, subsection, name2, value ? "true" : "false");
    }

    public <T extends Enum<?>> void setEnum(String section, String subsection, String name2, T value) {
        String n = value instanceof ConfigEnum ? ((ConfigEnum)((Object)value)).toConfigValue() : value.name().toLowerCase(Locale.ROOT).replace('_', ' ');
        this.setString(section, subsection, name2, n);
    }

    public void setString(String section, String subsection, String name2, String value) {
        this.setStringList(section, subsection, name2, Collections.singletonList(value));
    }

    public void unset(String section, String subsection, String name2) {
        this.setStringList(section, subsection, name2, Collections.emptyList());
    }

    public void unsetSection(String section, String subsection) {
        ConfigSnapshot res2;
        ConfigSnapshot src;
        while (!this.state.compareAndSet(src = this.state.get(), res2 = this.unsetSection(src, section, subsection))) {
        }
    }

    private ConfigSnapshot unsetSection(ConfigSnapshot srcState, String section, String subsection) {
        int max2 = srcState.entryList.size();
        ArrayList<ConfigLine> r = new ArrayList<ConfigLine>(max2);
        boolean lastWasMatch = false;
        for (ConfigLine e2 : srcState.entryList) {
            if (e2.match(section, subsection)) {
                lastWasMatch = true;
                continue;
            }
            if (lastWasMatch && e2.section == null && e2.subsection == null) continue;
            r.add(e2);
        }
        return this.newState(r);
    }

    public void setStringList(String section, String subsection, String name2, List<String> values) {
        ConfigSnapshot res2;
        ConfigSnapshot src;
        while (!this.state.compareAndSet(src = this.state.get(), res2 = this.replaceStringList(src, section, subsection, name2, values))) {
        }
        if (this.notifyUponTransientChanges()) {
            this.fireConfigChangedEvent();
        }
    }

    private ConfigSnapshot replaceStringList(ConfigSnapshot srcState, String section, String subsection, String name2, List<String> values) {
        ConfigLine e2;
        int entryIndex;
        List<ConfigLine> entries = Config.copy(srcState, values);
        int valueIndex = 0;
        int insertPosition = -1;
        for (entryIndex = 0; entryIndex < entries.size() && valueIndex < values.size(); ++entryIndex) {
            e2 = entries.get(entryIndex);
            if (!e2.match(section, subsection, name2)) continue;
            entries.set(entryIndex, e2.forValue(values.get(valueIndex++)));
            insertPosition = entryIndex + 1;
        }
        if (valueIndex == values.size() && entryIndex < entries.size()) {
            while (entryIndex < entries.size()) {
                if (!(e2 = entries.get(entryIndex++)).match(section, subsection, name2)) continue;
                entries.remove(--entryIndex);
            }
        }
        if (valueIndex < values.size() && entryIndex == entries.size()) {
            if (insertPosition < 0) {
                insertPosition = Config.findSectionEnd(entries, section, subsection);
            }
            if (insertPosition < 0) {
                e2 = new ConfigLine();
                e2.section = section;
                e2.subsection = subsection;
                entries.add(e2);
                insertPosition = entries.size();
            }
            while (valueIndex < values.size()) {
                e2 = new ConfigLine();
                e2.section = section;
                e2.subsection = subsection;
                e2.name = name2;
                e2.value = values.get(valueIndex++);
                entries.add(insertPosition++, e2);
            }
        }
        return this.newState(entries);
    }

    private static List<ConfigLine> copy(ConfigSnapshot src, List<String> values) {
        int max2 = src.entryList.size() + values.size() + 1;
        ArrayList<ConfigLine> r = new ArrayList<ConfigLine>(max2);
        r.addAll(src.entryList);
        return r;
    }

    private static int findSectionEnd(List<ConfigLine> entries, String section, String subsection) {
        for (int i = 0; i < entries.size(); ++i) {
            ConfigLine e2 = entries.get(i);
            if (!e2.match(section, subsection, null)) continue;
            ++i;
            while (i < entries.size() && (e2 = entries.get(i)).match(section, subsection, e2.name)) {
                ++i;
            }
            return i;
        }
        return -1;
    }

    public String toText() {
        StringBuilder out = new StringBuilder();
        for (ConfigLine e2 : this.state.get().entryList) {
            if (e2.prefix != null) {
                out.append(e2.prefix);
            }
            if (e2.section != null && e2.name == null) {
                out.append('[');
                out.append(e2.section);
                if (e2.subsection != null) {
                    boolean quoted;
                    out.append(' ');
                    String escaped = Config.escapeValue(e2.subsection);
                    boolean bl = quoted = escaped.startsWith("\"") && escaped.endsWith("\"");
                    if (!quoted) {
                        out.append('\"');
                    }
                    out.append(escaped);
                    if (!quoted) {
                        out.append('\"');
                    }
                }
                out.append(']');
            } else if (e2.section != null && e2.name != null) {
                if (e2.prefix == null || "".equals(e2.prefix)) {
                    out.append('\t');
                }
                out.append(e2.name);
                if (MAGIC_EMPTY_VALUE != e2.value) {
                    out.append(" =");
                    if (e2.value != null) {
                        out.append(' ');
                        out.append(Config.escapeValue(e2.value));
                    }
                }
                if (e2.suffix != null) {
                    out.append(' ');
                }
            }
            if (e2.suffix != null) {
                out.append(e2.suffix);
            }
            out.append('\n');
        }
        return out.toString();
    }

    public void fromText(String text) throws ConfigInvalidException {
        this.state.set(this.newState(this.fromTextRecurse(text, 1)));
    }

    private List<ConfigLine> fromTextRecurse(String text, int depth) throws ConfigInvalidException {
        ArrayList<ConfigLine> newEntries;
        block15: {
            if (depth > 10) {
                throw new ConfigInvalidException(JGitText.get().tooManyIncludeRecursions);
            }
            newEntries = new ArrayList<ConfigLine>();
            StringReader in = new StringReader(text);
            ConfigLine last = null;
            ConfigLine e2 = new ConfigLine();
            while (true) {
                int input;
                if (-1 == (input = in.read())) {
                    if (e2.section != null) {
                        newEntries.add(e2);
                    }
                    break block15;
                }
                char c = (char)input;
                if ('\n' == c) {
                    newEntries.add(e2);
                    if (e2.section != null) {
                        last = e2;
                    }
                    e2 = new ConfigLine();
                    continue;
                }
                if (e2.suffix != null) {
                    e2.suffix = e2.suffix + c;
                    continue;
                }
                if (';' == c || '#' == c) {
                    e2.suffix = String.valueOf(c);
                    continue;
                }
                if (e2.section == null && Character.isWhitespace(c)) {
                    if (e2.prefix == null) {
                        e2.prefix = "";
                    }
                    e2.prefix = e2.prefix + c;
                    continue;
                }
                if ('[' == c) {
                    e2.section = Config.readSectionName(in);
                    input = in.read();
                    if (34 == input) {
                        e2.subsection = Config.readSubsectionName(in);
                        input = in.read();
                    }
                    if (93 != input) {
                        throw new ConfigInvalidException(JGitText.get().badGroupHeader);
                    }
                    e2.suffix = "";
                    continue;
                }
                if (last == null) break;
                e2.section = last.section;
                e2.subsection = last.subsection;
                in.reset();
                e2.name = Config.readKeyName(in);
                if (e2.name.endsWith("\n")) {
                    e2.name = e2.name.substring(0, e2.name.length() - 1);
                    e2.value = MAGIC_EMPTY_VALUE;
                } else {
                    e2.value = Config.readValue(in);
                }
                if (!e2.section.equals("include")) continue;
                this.addIncludedConfig(newEntries, e2, depth);
            }
            throw new ConfigInvalidException(JGitText.get().invalidLineInConfigFile);
        }
        return newEntries;
    }

    @Nullable
    protected byte[] readIncludedConfig(String relPath) throws ConfigInvalidException {
        return null;
    }

    private void addIncludedConfig(List<ConfigLine> newEntries, ConfigLine line, int depth) throws ConfigInvalidException {
        if (!line.name.equals("path") || line.value == null || line.value.equals(MAGIC_EMPTY_VALUE)) {
            throw new ConfigInvalidException(JGitText.get().invalidLineInConfigFile);
        }
        byte[] bytes2 = this.readIncludedConfig(line.value);
        if (bytes2 == null) {
            return;
        }
        String decoded = this.isUtf8(bytes2) ? RawParseUtils.decode(RawParseUtils.UTF8_CHARSET, bytes2, 3, bytes2.length) : RawParseUtils.decode(bytes2);
        newEntries.addAll(this.fromTextRecurse(decoded, depth + 1));
    }

    private ConfigSnapshot newState() {
        return new ConfigSnapshot(Collections.emptyList(), this.getBaseState());
    }

    private ConfigSnapshot newState(List<ConfigLine> entries) {
        return new ConfigSnapshot(Collections.unmodifiableList(entries), this.getBaseState());
    }

    protected void clear() {
        this.state.set(this.newState());
    }

    protected boolean isUtf8(byte[] bytes2) {
        return bytes2.length >= 3 && bytes2[0] == -17 && bytes2[1] == -69 && bytes2[2] == -65;
    }

    private static String readSectionName(StringReader in) throws ConfigInvalidException {
        StringBuilder name2;
        block6: {
            name2 = new StringBuilder();
            while (true) {
                int c;
                if ((c = in.read()) < 0) {
                    throw new ConfigInvalidException(JGitText.get().unexpectedEndOfConfigFile);
                }
                if (93 == c) {
                    in.reset();
                    break block6;
                }
                if (32 == c || 9 == c) {
                    do {
                        if ((c = in.read()) < 0) {
                            throw new ConfigInvalidException(JGitText.get().unexpectedEndOfConfigFile);
                        }
                        if (34 != c) continue;
                        in.reset();
                        break block6;
                    } while (32 == c || 9 == c);
                    throw new ConfigInvalidException(MessageFormat.format(JGitText.get().badSectionEntry, name2));
                }
                if (!Character.isLetterOrDigit((char)c) && 46 != c && 45 != c) break;
                name2.append((char)c);
            }
            throw new ConfigInvalidException(MessageFormat.format(JGitText.get().badSectionEntry, name2));
        }
        return name2.toString();
    }

    private static String readKeyName(StringReader in) throws ConfigInvalidException {
        StringBuilder name2;
        block7: {
            int c;
            name2 = new StringBuilder();
            while (true) {
                if ((c = in.read()) < 0) {
                    throw new ConfigInvalidException(JGitText.get().unexpectedEndOfConfigFile);
                }
                if (61 == c) break block7;
                if (32 == c || 9 == c) {
                    do {
                        if ((c = in.read()) < 0) {
                            throw new ConfigInvalidException(JGitText.get().unexpectedEndOfConfigFile);
                        }
                        if (61 == c) break block7;
                        if (59 != c && 35 != c && 10 != c) continue;
                        in.reset();
                        break block7;
                    } while (32 == c || 9 == c);
                    throw new ConfigInvalidException(JGitText.get().badEntryDelimiter);
                }
                if (!Character.isLetterOrDigit((char)c) && c != 45) break;
                name2.append((char)c);
            }
            if (10 == c) {
                in.reset();
                name2.append((char)c);
            } else {
                throw new ConfigInvalidException(MessageFormat.format(JGitText.get().badEntryName, name2));
            }
        }
        return name2.toString();
    }

    private static String readSubsectionName(StringReader in) throws ConfigInvalidException {
        int c;
        StringBuilder r = new StringBuilder();
        block4: while ((c = in.read()) >= 0) {
            if (10 == c) {
                throw new ConfigInvalidException(JGitText.get().newlineInQuotesNotAllowed);
            }
            if (92 == c) {
                c = in.read();
                switch (c) {
                    case -1: {
                        throw new ConfigInvalidException(JGitText.get().endOfFileInEscape);
                    }
                    case 34: 
                    case 92: {
                        r.append((char)c);
                        continue block4;
                    }
                }
                r.append((char)c);
                continue;
            }
            if (34 == c) break;
            r.append((char)c);
        }
        return r.toString();
    }

    private static String readValue(StringReader in) throws ConfigInvalidException {
        int c;
        StringBuilder value = new StringBuilder();
        StringBuilder trailingSpaces = null;
        boolean quote = false;
        boolean inLeadingSpace = true;
        block9: while ((c = in.read()) >= 0) {
            if (10 == c) {
                if (quote) {
                    throw new ConfigInvalidException(JGitText.get().newlineInQuotesNotAllowed);
                }
                in.reset();
                break;
            }
            if (!(quote || 59 != c && 35 != c)) {
                if (trailingSpaces != null) {
                    trailingSpaces.setLength(0);
                }
                in.reset();
                break;
            }
            char cc = (char)c;
            if (Character.isWhitespace(cc)) {
                if (inLeadingSpace) continue;
                if (trailingSpaces == null) {
                    trailingSpaces = new StringBuilder();
                }
                trailingSpaces.append(cc);
                continue;
            }
            inLeadingSpace = false;
            if (trailingSpaces != null) {
                value.append((CharSequence)trailingSpaces);
                trailingSpaces.setLength(0);
            }
            if (92 == c) {
                c = in.read();
                switch (c) {
                    case -1: {
                        throw new ConfigInvalidException(JGitText.get().endOfFileInEscape);
                    }
                    case 10: {
                        continue block9;
                    }
                    case 116: {
                        value.append('\t');
                        continue block9;
                    }
                    case 98: {
                        value.append('\b');
                        continue block9;
                    }
                    case 110: {
                        value.append('\n');
                        continue block9;
                    }
                    case 92: {
                        value.append('\\');
                        continue block9;
                    }
                    case 34: {
                        value.append('\"');
                        continue block9;
                    }
                }
                throw new ConfigInvalidException(MessageFormat.format(JGitText.get().badEscape, Character.valueOf((char)c)));
            }
            if (34 == c) {
                quote = !quote;
                continue;
            }
            value.append(cc);
        }
        return value.length() > 0 ? value.toString() : null;
    }

    static {
        typedGetter = DEFAULT_GETTER = new DefaultTypedConfigGetter();
        MAGIC_EMPTY_VALUE = new String();
    }

    public static interface ConfigEnum {
        public String toConfigValue();

        public boolean matchConfigValue(String var1);
    }

    public static interface SectionParser<T> {
        public T parse(Config var1);
    }

    private static class StringReader {
        private final char[] buf;
        private int pos;

        StringReader(String in) {
            this.buf = in.toCharArray();
        }

        int read() {
            try {
                return this.buf[this.pos++];
            }
            catch (ArrayIndexOutOfBoundsException e2) {
                this.pos = this.buf.length;
                return -1;
            }
        }

        void reset() {
            --this.pos;
        }
    }
}

