/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.transport.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.spi.connector.transport.AbstractTransporter;
import org.eclipse.aether.spi.connector.transport.GetTask;
import org.eclipse.aether.spi.connector.transport.PeekTask;
import org.eclipse.aether.spi.connector.transport.PutTask;
import org.eclipse.aether.spi.connector.transport.TransportTask;
import org.eclipse.aether.spi.log.Logger;
import org.eclipse.aether.transfer.NoTransporterException;
import org.eclipse.aether.transport.file.PathUtils;
import org.eclipse.aether.transport.file.ResourceNotFoundException;

final class FileTransporter
extends AbstractTransporter {
    private final Logger logger;
    private final File basedir;

    FileTransporter(RemoteRepository repository, Logger logger) throws NoTransporterException {
        if (!"file".equalsIgnoreCase(repository.getProtocol())) {
            throw new NoTransporterException(repository);
        }
        this.logger = logger;
        this.basedir = new File(PathUtils.basedir(repository.getUrl())).getAbsoluteFile();
    }

    File getBasedir() {
        return this.basedir;
    }

    @Override
    public int classify(Throwable error) {
        if (error instanceof ResourceNotFoundException) {
            return 1;
        }
        return 0;
    }

    @Override
    protected void implPeek(PeekTask task) throws Exception {
        this.getFile(task, true);
    }

    @Override
    protected void implGet(GetTask task) throws Exception {
        File file2 = this.getFile(task, true);
        this.utilGet(task, new FileInputStream(file2), true, file2.length(), false);
    }

    @Override
    protected void implPut(PutTask task) throws Exception {
        File file2 = this.getFile(task, false);
        file2.getParentFile().mkdirs();
        try {
            this.utilPut(task, new FileOutputStream(file2), true);
        }
        catch (Exception e2) {
            if (!file2.delete() && file2.exists()) {
                this.logger.debug("Could not delete partial file " + file2);
            }
            throw e2;
        }
    }

    private File getFile(TransportTask task, boolean required2) throws Exception {
        String path2 = task.getLocation().getPath();
        if (path2.contains("../")) {
            throw new IllegalArgumentException("illegal resource path: " + path2);
        }
        File file2 = new File(this.basedir, path2);
        if (required2 && !file2.exists()) {
            throw new ResourceNotFoundException("Could not locate " + file2);
        }
        return file2;
    }

    @Override
    protected void implClose() {
    }
}

