/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.provider.res;

import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.vfs.Capability;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystem;
import org.apache.commons.vfs.FileSystemConfigBuilder;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileSystemOptions;
import org.apache.commons.vfs.provider.AbstractFileProvider;
import org.apache.commons.vfs.provider.UriParser;
import org.apache.commons.vfs.provider.res.ResourceFileSystemConfigBuilder;

public class ResourceFileProvider
extends AbstractFileProvider {
    protected static final Collection capabilities = Collections.unmodifiableCollection(Arrays.asList(Capability.DISPATCHER));

    public FileObject findFile(FileObject baseFile, String uri, FileSystemOptions fileSystemOptions) throws FileSystemException {
        URL url;
        StringBuffer buf = new StringBuffer(80);
        UriParser.extractScheme(uri, buf);
        String resourceName = buf.toString();
        ClassLoader cl = ResourceFileSystemConfigBuilder.getInstance().getClassLoader(fileSystemOptions);
        if (cl == null) {
            cl = this.getClass().getClassLoader();
        }
        if ((url = cl.getResource(resourceName)) == null) {
            throw new FileSystemException("vfs.provider.url/badly-formed-uri.error", uri);
        }
        FileObject fo = this.getContext().getFileSystemManager().resolveFile(url.toExternalForm());
        return fo;
    }

    public FileSystemConfigBuilder getConfigBuilder() {
        return ResourceFileSystemConfigBuilder.getInstance();
    }

    public void closeFileSystem(FileSystem filesystem) {
    }

    public Collection getCapabilities() {
        return capabilities;
    }
}

