/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.orabulkloader;

import java.util.List;
import java.util.Map;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Counter;
import org.pentaho.di.core.SQLStatement;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.shared.SharedObjectInterface;
import org.pentaho.di.trans.DatabaseImpact;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.orabulkloader.Messages;
import org.pentaho.di.trans.steps.orabulkloader.OraBulkLoader;
import org.pentaho.di.trans.steps.orabulkloader.OraBulkLoaderData;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OraBulkLoaderMeta
extends BaseStepMeta
implements StepMetaInterface {
    private String schemaName;
    private String tableName;
    private String sqlldr;
    private String controlFile;
    private String dataFile;
    private String logFile;
    private String badFile;
    private String discardFile;
    private DatabaseMeta databaseMeta;
    private String[] fieldTable;
    private String[] fieldStream;
    private String[] dateMask;
    private int commitSize;
    private int bindSize;
    private int readSize;
    private int maxErrors;
    private String loadMethod;
    private String loadAction;
    private String encoding;
    private String characterSetName;
    private boolean directPath;
    private boolean eraseFiles;
    private String dbNameOverride;
    private boolean failOnWarning;
    private boolean failOnError;
    private String altRecordTerm;
    public static final String ACTION_APPEND = "APPEND";
    public static final String ACTION_INSERT = "INSERT";
    public static final String ACTION_REPLACE = "REPLACE";
    public static final String ACTION_TRUNCATE = "TRUNCATE";
    public static final String METHOD_AUTO_CONCURRENT = "AUTO_CONCURRENT";
    public static final String METHOD_AUTO_END = "AUTO_END";
    public static final String METHOD_MANUAL = "MANUAL";
    public static final String DATE_MASK_DATE = "DATE";
    public static final String DATE_MASK_DATETIME = "DATETIME";

    public int getCommitSize() {
        return this.commitSize;
    }

    public void setCommitSize(int commitSize) {
        this.commitSize = commitSize;
    }

    public DatabaseMeta getDatabaseMeta() {
        return this.databaseMeta;
    }

    public void setDatabaseMeta(DatabaseMeta database) {
        this.databaseMeta = database;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getSqlldr() {
        return this.sqlldr;
    }

    public void setSqlldr(String sqlldr) {
        this.sqlldr = sqlldr;
    }

    public String[] getFieldTable() {
        return this.fieldTable;
    }

    public void setFieldTable(String[] updateLookup) {
        this.fieldTable = updateLookup;
    }

    public String[] getFieldStream() {
        return this.fieldStream;
    }

    public void setFieldStream(String[] updateStream) {
        this.fieldStream = updateStream;
    }

    public String[] getDateMask() {
        return this.dateMask;
    }

    public void setDateMask(String[] dateMask) {
        this.dateMask = dateMask;
    }

    public boolean isFailOnWarning() {
        return this.failOnWarning;
    }

    public void setFailOnWarning(boolean failOnWarning) {
        this.failOnWarning = failOnWarning;
    }

    public boolean isFailOnError() {
        return this.failOnError;
    }

    public void setFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
    }

    public String getCharacterSetName() {
        return this.characterSetName;
    }

    public void setCharacterSetName(String characterSetName) {
        this.characterSetName = characterSetName;
    }

    public String getAltRecordTerm() {
        return this.altRecordTerm;
    }

    public void setAltRecordTerm(String altRecordTerm) {
        this.altRecordTerm = altRecordTerm;
    }

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleXMLException {
        this.readData(stepnode, databases);
    }

    public void allocate(int nrvalues) {
        this.fieldTable = new String[nrvalues];
        this.fieldStream = new String[nrvalues];
        this.dateMask = new String[nrvalues];
    }

    @Override
    public Object clone() {
        OraBulkLoaderMeta retval = (OraBulkLoaderMeta)super.clone();
        int nrvalues = this.fieldTable.length;
        retval.allocate(nrvalues);
        for (int i = 0; i < nrvalues; ++i) {
            retval.fieldTable[i] = this.fieldTable[i];
            retval.fieldStream[i] = this.fieldStream[i];
            retval.dateMask[i] = this.dateMask[i];
        }
        return retval;
    }

    private void readData(Node stepnode, List<? extends SharedObjectInterface> databases) throws KettleXMLException {
        try {
            String con = XMLHandler.getTagValue((Node)stepnode, (String)"connection");
            this.databaseMeta = DatabaseMeta.findDatabase(databases, (String)con);
            String csize = XMLHandler.getTagValue((Node)stepnode, (String)"commit");
            this.commitSize = Const.toInt((String)csize, (int)0);
            String bsize = XMLHandler.getTagValue((Node)stepnode, (String)"bind_size");
            this.bindSize = Const.toInt((String)bsize, (int)0);
            String rsize = XMLHandler.getTagValue((Node)stepnode, (String)"read_size");
            this.readSize = Const.toInt((String)rsize, (int)0);
            String serror = XMLHandler.getTagValue((Node)stepnode, (String)"errors");
            this.maxErrors = Const.toInt((String)serror, (int)50);
            this.schemaName = XMLHandler.getTagValue((Node)stepnode, (String)"schema");
            this.tableName = XMLHandler.getTagValue((Node)stepnode, (String)"table");
            this.loadMethod = XMLHandler.getTagValue((Node)stepnode, (String)"load_method");
            this.loadAction = XMLHandler.getTagValue((Node)stepnode, (String)"load_action");
            this.sqlldr = XMLHandler.getTagValue((Node)stepnode, (String)"sqlldr");
            this.controlFile = XMLHandler.getTagValue((Node)stepnode, (String)"control_file");
            this.dataFile = XMLHandler.getTagValue((Node)stepnode, (String)"data_file");
            this.logFile = XMLHandler.getTagValue((Node)stepnode, (String)"log_file");
            this.badFile = XMLHandler.getTagValue((Node)stepnode, (String)"bad_file");
            this.discardFile = XMLHandler.getTagValue((Node)stepnode, (String)"discard_file");
            this.directPath = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"direct_path"));
            this.eraseFiles = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"erase_files"));
            this.encoding = XMLHandler.getTagValue((Node)stepnode, (String)"encoding");
            this.dbNameOverride = XMLHandler.getTagValue((Node)stepnode, (String)"dbname_override");
            this.characterSetName = XMLHandler.getTagValue((Node)stepnode, (String)"character_set");
            this.failOnWarning = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"fail_on_warning"));
            this.failOnError = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"fail_on_error"));
            this.altRecordTerm = XMLHandler.getTagValue((Node)stepnode, (String)"alt_rec_term");
            int nrvalues = XMLHandler.countNodes((Node)stepnode, (String)"mapping");
            this.allocate(nrvalues);
            for (int i = 0; i < nrvalues; ++i) {
                String locDateMask;
                Node vnode = XMLHandler.getSubNodeByNr((Node)stepnode, (String)"mapping", (int)i);
                this.fieldTable[i] = XMLHandler.getTagValue((Node)vnode, (String)"stream_name");
                this.fieldStream[i] = XMLHandler.getTagValue((Node)vnode, (String)"field_name");
                if (this.fieldStream[i] == null) {
                    this.fieldStream[i] = this.fieldTable[i];
                }
                this.dateMask[i] = (locDateMask = XMLHandler.getTagValue((Node)vnode, (String)"date_mask")) == null ? "" : (DATE_MASK_DATE.equals(locDateMask) || DATE_MASK_DATETIME.equals(locDateMask) ? locDateMask : "");
            }
        }
        catch (Exception e) {
            throw new KettleXMLException(Messages.getString("OraBulkLoaderMeta.Exception.UnableToReadStepInfoFromXML"), (Throwable)e);
        }
    }

    @Override
    public void setDefault() {
        this.fieldTable = null;
        this.databaseMeta = null;
        this.commitSize = 100000;
        this.bindSize = 0;
        this.readSize = 0;
        this.maxErrors = 50;
        this.schemaName = "";
        this.tableName = Messages.getString("OraBulkLoaderMeta.DefaultTableName");
        this.loadMethod = METHOD_AUTO_END;
        this.loadAction = ACTION_APPEND;
        this.sqlldr = "sqlldr";
        this.controlFile = "control${Internal.Step.CopyNr}.cfg";
        this.dataFile = "load${Internal.Step.CopyNr}.dat";
        this.logFile = "";
        this.badFile = "";
        this.discardFile = "";
        this.encoding = "";
        this.dbNameOverride = "";
        this.directPath = false;
        this.eraseFiles = true;
        this.characterSetName = "";
        this.failOnWarning = false;
        this.failOnError = false;
        this.altRecordTerm = "";
        int nrvalues = 0;
        this.allocate(nrvalues);
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer(300);
        retval.append("    ").append(XMLHandler.addTagValue((String)"connection", (String)(this.databaseMeta == null ? "" : this.databaseMeta.getName())));
        retval.append("    ").append(XMLHandler.addTagValue((String)"commit", (int)this.commitSize));
        retval.append("    ").append(XMLHandler.addTagValue((String)"bind_size", (int)this.bindSize));
        retval.append("    ").append(XMLHandler.addTagValue((String)"read_size", (int)this.readSize));
        retval.append("    ").append(XMLHandler.addTagValue((String)"errors", (int)this.maxErrors));
        retval.append("    ").append(XMLHandler.addTagValue((String)"schema", (String)this.schemaName));
        retval.append("    ").append(XMLHandler.addTagValue((String)"table", (String)this.tableName));
        retval.append("    ").append(XMLHandler.addTagValue((String)"load_method", (String)this.loadMethod));
        retval.append("    ").append(XMLHandler.addTagValue((String)"load_action", (String)this.loadAction));
        retval.append("    ").append(XMLHandler.addTagValue((String)"sqlldr", (String)this.sqlldr));
        retval.append("    ").append(XMLHandler.addTagValue((String)"control_file", (String)this.controlFile));
        retval.append("    ").append(XMLHandler.addTagValue((String)"data_file", (String)this.dataFile));
        retval.append("    ").append(XMLHandler.addTagValue((String)"log_file", (String)this.logFile));
        retval.append("    ").append(XMLHandler.addTagValue((String)"bad_file", (String)this.badFile));
        retval.append("    ").append(XMLHandler.addTagValue((String)"discard_file", (String)this.discardFile));
        retval.append("    ").append(XMLHandler.addTagValue((String)"direct_path", (boolean)this.directPath));
        retval.append("    ").append(XMLHandler.addTagValue((String)"erase_files", (boolean)this.eraseFiles));
        retval.append("    ").append(XMLHandler.addTagValue((String)"encoding", (String)this.encoding));
        retval.append("    ").append(XMLHandler.addTagValue((String)"dbname_override", (String)this.dbNameOverride));
        retval.append("    ").append(XMLHandler.addTagValue((String)"character_set", (String)this.characterSetName));
        retval.append("    ").append(XMLHandler.addTagValue((String)"fail_on_warning", (boolean)this.failOnWarning));
        retval.append("    ").append(XMLHandler.addTagValue((String)"fail_on_error", (boolean)this.failOnError));
        retval.append("    ").append(XMLHandler.addTagValue((String)"alt_rec_term", (String)this.altRecordTerm));
        for (int i = 0; i < this.fieldTable.length; ++i) {
            retval.append("      <mapping>").append(Const.CR);
            retval.append("        ").append(XMLHandler.addTagValue((String)"stream_name", (String)this.fieldTable[i]));
            retval.append("        ").append(XMLHandler.addTagValue((String)"field_name", (String)this.fieldStream[i]));
            retval.append("        ").append(XMLHandler.addTagValue((String)"date_mask", (String)this.dateMask[i]));
            retval.append("      </mapping>").append(Const.CR);
        }
        return retval.toString();
    }

    @Override
    public void readRep(Repository rep, long id_step, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleException {
        try {
            long id_connection = rep.getStepAttributeInteger(id_step, "id_connection");
            this.databaseMeta = DatabaseMeta.findDatabase(databases, (long)id_connection);
            this.commitSize = (int)rep.getStepAttributeInteger(id_step, "commit");
            this.bindSize = (int)rep.getStepAttributeInteger(id_step, "bind_size");
            this.readSize = (int)rep.getStepAttributeInteger(id_step, "read_size");
            this.maxErrors = (int)rep.getStepAttributeInteger(id_step, "errors");
            this.schemaName = rep.getStepAttributeString(id_step, "schema");
            this.tableName = rep.getStepAttributeString(id_step, "table");
            this.loadMethod = rep.getStepAttributeString(id_step, "load_method");
            this.loadAction = rep.getStepAttributeString(id_step, "load_action");
            this.sqlldr = rep.getStepAttributeString(id_step, "sqlldr");
            this.controlFile = rep.getStepAttributeString(id_step, "control_file");
            this.dataFile = rep.getStepAttributeString(id_step, "data_file");
            this.logFile = rep.getStepAttributeString(id_step, "log_file");
            this.badFile = rep.getStepAttributeString(id_step, "bad_file");
            this.discardFile = rep.getStepAttributeString(id_step, "discard_file");
            this.directPath = rep.getStepAttributeBoolean(id_step, "direct_path");
            this.eraseFiles = rep.getStepAttributeBoolean(id_step, "erase_files");
            this.encoding = rep.getStepAttributeString(id_step, "encoding");
            this.dbNameOverride = rep.getStepAttributeString(id_step, "dbname_override");
            this.characterSetName = rep.getStepAttributeString(id_step, "character_set");
            this.failOnWarning = rep.getStepAttributeBoolean(id_step, "fail_on_warning");
            this.failOnError = rep.getStepAttributeBoolean(id_step, "fail_on_error");
            this.altRecordTerm = rep.getStepAttributeString(id_step, "alt_rec_term");
            int nrvalues = rep.countNrStepAttributes(id_step, "stream_name");
            this.allocate(nrvalues);
            for (int i = 0; i < nrvalues; ++i) {
                this.fieldTable[i] = rep.getStepAttributeString(id_step, i, "stream_name");
                this.fieldStream[i] = rep.getStepAttributeString(id_step, i, "field_name");
                this.dateMask[i] = rep.getStepAttributeString(id_step, i, "date_mask");
            }
        }
        catch (Exception e) {
            throw new KettleException(Messages.getString("OraBulkLoaderMeta.Exception.UnexpectedErrorReadingStepInfoFromRepository"), (Throwable)e);
        }
    }

    @Override
    public void saveRep(Repository rep, long id_transformation, long id_step) throws KettleException {
        try {
            rep.saveStepAttribute(id_transformation, id_step, "id_connection", this.databaseMeta == null ? -1.0 : (double)this.databaseMeta.getID());
            rep.saveStepAttribute(id_transformation, id_step, "commit", this.commitSize);
            rep.saveStepAttribute(id_transformation, id_step, "bind_size", this.bindSize);
            rep.saveStepAttribute(id_transformation, id_step, "read_size", this.readSize);
            rep.saveStepAttribute(id_transformation, id_step, "errors", this.maxErrors);
            rep.saveStepAttribute(id_transformation, id_step, "schema", this.schemaName);
            rep.saveStepAttribute(id_transformation, id_step, "table", this.tableName);
            rep.saveStepAttribute(id_transformation, id_step, "load_method", this.loadMethod);
            rep.saveStepAttribute(id_transformation, id_step, "load_action", this.loadAction);
            rep.saveStepAttribute(id_transformation, id_step, "sqlldr", this.sqlldr);
            rep.saveStepAttribute(id_transformation, id_step, "control_file", this.controlFile);
            rep.saveStepAttribute(id_transformation, id_step, "data_file", this.dataFile);
            rep.saveStepAttribute(id_transformation, id_step, "log_file", this.logFile);
            rep.saveStepAttribute(id_transformation, id_step, "bad_file", this.badFile);
            rep.saveStepAttribute(id_transformation, id_step, "discard_file", this.discardFile);
            rep.saveStepAttribute(id_transformation, id_step, "direct_path", this.directPath);
            rep.saveStepAttribute(id_transformation, id_step, "erase_files", this.eraseFiles);
            rep.saveStepAttribute(id_transformation, id_step, "encoding", this.encoding);
            rep.saveStepAttribute(id_transformation, id_step, "dbname_override", this.dbNameOverride);
            rep.saveStepAttribute(id_transformation, id_step, "character_set", this.characterSetName);
            rep.saveStepAttribute(id_transformation, id_step, "fail_on_warning", this.failOnWarning);
            rep.saveStepAttribute(id_transformation, id_step, "fail_on_error", this.failOnError);
            rep.saveStepAttribute(id_transformation, id_step, "alt_rec_term", this.altRecordTerm);
            for (int i = 0; i < this.fieldTable.length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "stream_name", this.fieldTable[i]);
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "field_name", this.fieldStream[i]);
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "date_mask", this.dateMask[i]);
            }
            if (this.databaseMeta != null) {
                rep.insertStepDatabase(id_transformation, id_step, this.databaseMeta.getID());
            }
        }
        catch (Exception e) {
            throw new KettleException(Messages.getString("OraBulkLoaderMeta.Exception.UnableToSaveStepInfoToRepository") + id_step, (Throwable)e);
        }
    }

    @Override
    public void getFields(RowMetaInterface rowMeta, String origin, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space) throws KettleStepException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info) {
        CheckResult cr;
        block17: {
            String error_message = "";
            if (this.databaseMeta != null) {
                Database db = new Database(this.databaseMeta);
                db.shareVariablesWith((VariableSpace)transMeta);
                try {
                    try {
                        boolean error_found;
                        boolean first;
                        db.connect();
                        if (!Const.isEmpty((String)this.tableName)) {
                            cr = new CheckResult(1, Messages.getString("OraBulkLoaderMeta.CheckResult.TableNameOK"), (CheckResultSourceInterface)stepMeta);
                            remarks.add((CheckResultInterface)cr);
                            first = true;
                            error_found = false;
                            error_message = "";
                            String schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(transMeta.environmentSubstitute(this.schemaName), transMeta.environmentSubstitute(this.tableName));
                            RowMetaInterface r = db.getTableFields(schemaTable);
                            if (r != null) {
                                cr = new CheckResult(1, Messages.getString("OraBulkLoaderMeta.CheckResult.TableExists"), (CheckResultSourceInterface)stepMeta);
                                remarks.add((CheckResultInterface)cr);
                                first = true;
                                error_found = false;
                                error_message = "";
                                for (int i = 0; i < this.fieldTable.length; ++i) {
                                    String field = this.fieldTable[i];
                                    ValueMetaInterface v = r.searchValueMeta(field);
                                    if (v != null) continue;
                                    if (first) {
                                        first = false;
                                        error_message = error_message + Messages.getString("OraBulkLoaderMeta.CheckResult.MissingFieldsToLoadInTargetTable") + Const.CR;
                                    }
                                    error_found = true;
                                    error_message = error_message + "\t\t" + field + Const.CR;
                                }
                                cr = error_found ? new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta) : new CheckResult(1, Messages.getString("OraBulkLoaderMeta.CheckResult.AllFieldsFoundInTargetTable"), (CheckResultSourceInterface)stepMeta);
                                remarks.add((CheckResultInterface)cr);
                            } else {
                                error_message = Messages.getString("OraBulkLoaderMeta.CheckResult.CouldNotReadTableInfo");
                                cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta);
                                remarks.add((CheckResultInterface)cr);
                            }
                        }
                        if (prev != null && prev.size() > 0) {
                            cr = new CheckResult(1, Messages.getString("OraBulkLoaderMeta.CheckResult.StepReceivingDatas", prev.size() + ""), (CheckResultSourceInterface)stepMeta);
                            remarks.add((CheckResultInterface)cr);
                            first = true;
                            error_message = "";
                            error_found = false;
                            for (int i = 0; i < this.fieldStream.length; ++i) {
                                ValueMetaInterface v = prev.searchValueMeta(this.fieldStream[i]);
                                if (v != null) continue;
                                if (first) {
                                    first = false;
                                    error_message = error_message + Messages.getString("OraBulkLoaderMeta.CheckResult.MissingFieldsInInput") + Const.CR;
                                }
                                error_found = true;
                                error_message = error_message + "\t\t" + this.fieldStream[i] + Const.CR;
                            }
                            cr = error_found ? new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta) : new CheckResult(1, Messages.getString("OraBulkLoaderMeta.CheckResult.AllFieldsFoundInInput"), (CheckResultSourceInterface)stepMeta);
                            remarks.add((CheckResultInterface)cr);
                        } else {
                            error_message = Messages.getString("OraBulkLoaderMeta.CheckResult.MissingFieldsInInput3") + Const.CR;
                            cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta);
                            remarks.add((CheckResultInterface)cr);
                        }
                    }
                    catch (KettleException e) {
                        error_message = Messages.getString("OraBulkLoaderMeta.CheckResult.DatabaseErrorOccurred") + e.getMessage();
                        cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta);
                        remarks.add((CheckResultInterface)cr);
                        Object var19_21 = null;
                        db.disconnect();
                        break block17;
                    }
                    Object var19_20 = null;
                }
                catch (Throwable throwable) {
                    Object var19_22 = null;
                    db.disconnect();
                    throw throwable;
                }
                db.disconnect();
            } else {
                error_message = Messages.getString("OraBulkLoaderMeta.CheckResult.InvalidConnection");
                cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            }
        }
        if (input.length > 0) {
            cr = new CheckResult(1, Messages.getString("OraBulkLoaderMeta.CheckResult.StepReceivingInfoFromOtherSteps"), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
            return;
        }
        cr = new CheckResult(4, Messages.getString("OraBulkLoaderMeta.CheckResult.NoInputError"), (CheckResultSourceInterface)stepMeta);
        remarks.add((CheckResultInterface)cr);
    }

    @Override
    public SQLStatement getSQLStatements(TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev) throws KettleStepException {
        SQLStatement retval;
        block12: {
            retval = new SQLStatement(stepMeta.getName(), this.databaseMeta, null);
            if (this.databaseMeta != null) {
                if (prev != null && prev.size() > 0) {
                    RowMeta tableFields = new RowMeta();
                    for (int i = 0; i < this.fieldTable.length; ++i) {
                        ValueMetaInterface v = prev.searchValueMeta(this.fieldStream[i]);
                        if (v == null) {
                            throw new KettleStepException("Unable to find field [" + this.fieldStream[i] + "] in the input rows");
                        }
                        ValueMetaInterface tableField = v.clone();
                        tableField.setName(this.fieldTable[i]);
                        tableFields.addValueMeta(tableField);
                    }
                    if (!Const.isEmpty((String)this.tableName)) {
                        Database db = new Database(this.databaseMeta);
                        db.shareVariablesWith((VariableSpace)transMeta);
                        try {
                            String sql;
                            db.connect();
                            String schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(transMeta.environmentSubstitute(this.schemaName), transMeta.environmentSubstitute(this.tableName));
                            String cr_table = db.getDDL(schemaTable, (RowMetaInterface)tableFields, null, false, null, true);
                            String cr_index = "";
                            String[] idx_fields = null;
                            if (idx_fields != null && idx_fields.length > 0 && !db.checkIndexExists(transMeta.environmentSubstitute(this.schemaName), transMeta.environmentSubstitute(this.tableName), idx_fields)) {
                                String indexname = "idx_" + this.tableName + "_lookup";
                                cr_index = db.getCreateIndexStatement(schemaTable, indexname, idx_fields, false, false, false, true);
                            }
                            if ((sql = cr_table + cr_index).length() == 0) {
                                retval.setSQL(null);
                                break block12;
                            }
                            retval.setSQL(sql);
                        }
                        catch (KettleException e) {
                            retval.setError(Messages.getString("OraBulkLoaderMeta.GetSQL.ErrorOccurred") + e.getMessage());
                        }
                    } else {
                        retval.setError(Messages.getString("OraBulkLoaderMeta.GetSQL.NoTableDefinedOnConnection"));
                    }
                } else {
                    retval.setError(Messages.getString("OraBulkLoaderMeta.GetSQL.NotReceivingAnyFields"));
                }
            } else {
                retval.setError(Messages.getString("OraBulkLoaderMeta.GetSQL.NoConnectionDefined"));
            }
        }
        return retval;
    }

    @Override
    public void analyseImpact(List<DatabaseImpact> impact, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info) throws KettleStepException {
        if (prev != null) {
            for (int i = 0; i < this.fieldTable.length; ++i) {
                ValueMetaInterface v = prev.searchValueMeta(this.fieldStream[i]);
                DatabaseImpact ii = new DatabaseImpact(3, transMeta.getName(), stepMeta.getName(), this.databaseMeta.getDatabaseName(), transMeta.environmentSubstitute(this.tableName), this.fieldTable[i], this.fieldStream[i], v != null ? v.getOrigin() : "?", "", "Type = " + v.toStringMeta());
                impact.add(ii);
            }
        }
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta transMeta, Trans trans) {
        return new OraBulkLoader(stepMeta, stepDataInterface, cnr, transMeta, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new OraBulkLoaderData();
    }

    @Override
    public DatabaseMeta[] getUsedDatabaseConnections() {
        if (this.databaseMeta != null) {
            return new DatabaseMeta[]{this.databaseMeta};
        }
        return super.getUsedDatabaseConnections();
    }

    public boolean isDirectPath() {
        return this.directPath;
    }

    public void setDirectPath(boolean directPath) {
        this.directPath = directPath;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public RowMetaInterface getRequiredFields(VariableSpace space) throws KettleException {
        Database db;
        block5: {
            String realTableName = space.environmentSubstitute(this.tableName);
            String realSchemaName = space.environmentSubstitute(this.schemaName);
            if (this.databaseMeta == null) throw new KettleException(Messages.getString("OraBulkLoaderMeta.Exception.ConnectionNotDefined"));
            db = new Database(this.databaseMeta);
            db.connect();
            if (Const.isEmpty((String)realTableName)) throw new KettleException(Messages.getString("OraBulkLoaderMeta.Exception.TableNotSpecified"));
            String schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(realSchemaName, realTableName);
            if (!db.checkTableExists(schemaTable)) break block5;
            RowMetaInterface rowMetaInterface = db.getTableFields(schemaTable);
            Object var8_8 = null;
            db.disconnect();
            return rowMetaInterface;
        }
        try {
            try {
                throw new KettleException(Messages.getString("OraBulkLoaderMeta.Exception.TableNotFound"));
            }
            catch (Exception e) {
                throw new KettleException(Messages.getString("OraBulkLoaderMeta.Exception.ErrorGettingFields"), (Throwable)e);
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            db.disconnect();
            throw throwable;
        }
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public String getBadFile() {
        return this.badFile;
    }

    public void setBadFile(String badFile) {
        this.badFile = badFile;
    }

    public String getControlFile() {
        return this.controlFile;
    }

    public void setControlFile(String controlFile) {
        this.controlFile = controlFile;
    }

    public String getDataFile() {
        return this.dataFile;
    }

    public void setDataFile(String dataFile) {
        this.dataFile = dataFile;
    }

    public String getDiscardFile() {
        return this.discardFile;
    }

    public void setDiscardFile(String discardFile) {
        this.discardFile = discardFile;
    }

    public String getLogFile() {
        return this.logFile;
    }

    public void setLogFile(String logFile) {
        this.logFile = logFile;
    }

    public void setLoadAction(String action) {
        this.loadAction = action;
    }

    public String getLoadAction() {
        return this.loadAction;
    }

    public void setLoadMethod(String method) {
        this.loadMethod = method;
    }

    public String getLoadMethod() {
        return this.loadMethod;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getDelimiter() {
        return ",";
    }

    public String getEnclosure() {
        return "\"";
    }

    public boolean isEraseFiles() {
        return this.eraseFiles;
    }

    public void setEraseFiles(boolean eraseFiles) {
        this.eraseFiles = eraseFiles;
    }

    public int getBindSize() {
        return this.bindSize;
    }

    public void setBindSize(int bindSize) {
        this.bindSize = bindSize;
    }

    public int getMaxErrors() {
        return this.maxErrors;
    }

    public void setMaxErrors(int maxErrors) {
        this.maxErrors = maxErrors;
    }

    public int getReadSize() {
        return this.readSize;
    }

    public void setReadSize(int readSize) {
        this.readSize = readSize;
    }

    public String getDbNameOverride() {
        return this.dbNameOverride;
    }

    public void setDbNameOverride(String dbNameOverride) {
        this.dbNameOverride = dbNameOverride;
    }
}

