/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.swingui.object;

import ca.sqlpower.object.SPVariableHelper;
import ca.sqlpower.swingui.DataEntryPanelBuilder;
import ca.sqlpower.swingui.object.VariableInserter;
import ca.sqlpower.swingui.object.VariablesPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.UUID;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;

public class VariableLabel
extends JLabel {
    public static final String VAR_VALUE = "sqlp-variable-value";
    public static final String UUID = "sqlp-variable-uuid";
    public static final String VARIABLE_CHAR = "\u0001";
    private static final int MARGIN = 10;
    private String variableDef;

    public VariableLabel(String variableDef, SPVariableHelper helper) {
        super("  " + SPVariableHelper.getKey(variableDef) + "  > ");
        super.setForeground(super.getBackground());
        this.variableDef = variableDef;
        this.setAlignmentY(3.0f);
        this.setHorizontalAlignment(0);
    }

    @Override
    public void paint(Graphics g) {
        Color colorBackup = g.getColor();
        g.setColor(Color.BLUE);
        g.fillRoundRect(0, 0, this.getWidth(), this.getHeight(), 10, 10);
        g.setColor(Color.WHITE);
        g.drawString("  " + SPVariableHelper.getKey(this.variableDef) + "  > ", 0, this.getHeight() - 4);
        g.setColor(colorBackup);
    }

    @Override
    public String toString() {
        return VariableLabel.formatVariable(this.variableDef);
    }

    public void setVariableDef(String variableDef) {
        this.variableDef = variableDef;
        this.setText("  " + SPVariableHelper.getKey(this.variableDef) + "  > ");
    }

    public static void insertLabel(String variableDef, SPVariableHelper helper, Document target, int insertPosition, Component dialogOwner) throws BadLocationException {
        VariableLabel.insertLabel(variableDef, helper, target, insertPosition, dialogOwner, true);
    }

    public static void insertLabel(final String variableDef, final SPVariableHelper helper, final Document target, int insertPosition, final Component dialogOwner, boolean showVariablesPanelOnClick) throws BadLocationException {
        final String uuid = java.util.UUID.randomUUID().toString();
        SimpleAttributeSet varStyle = new SimpleAttributeSet();
        varStyle.addAttribute(VAR_VALUE, variableDef);
        varStyle.addAttribute(UUID, uuid);
        VariableLabel labelToInsert = new VariableLabel(variableDef, helper);
        StyleConstants.setComponent(varStyle, labelToInsert);
        target.insertString(insertPosition, VARIABLE_CHAR, varStyle);
        if (showVariablesPanelOnClick) {
            labelToInsert.addMouseListener(new MouseListener(){

                @Override
                public void mouseReleased(MouseEvent e) {
                }

                @Override
                public void mousePressed(MouseEvent e) {
                }

                @Override
                public void mouseExited(MouseEvent e) {
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                    VariablesPanel vp = new VariablesPanel(helper, new VariableInserter(){

                        @Override
                        public void insert(String variable) {
                            for (int i = 0; i < target.getLength(); ++i) {
                                try {
                                    if (!VariableLabel.getCharacterElement(target, i).getAttributes().isDefined(VariableLabel.UUID) || !VariableLabel.getCharacterElement(target, i).getAttributes().getAttribute(VariableLabel.UUID).equals(uuid) || !target.getText(i, 1).equals(VariableLabel.VARIABLE_CHAR)) continue;
                                    target.remove(i, 1);
                                    String newVariableDef = variable.replaceFirst("\\$", "").replaceFirst("\\{", "").replaceFirst("\\}", "");
                                    VariableLabel.insertLabel(newVariableDef, helper, target, i, dialogOwner);
                                    continue;
                                }
                                catch (BadLocationException e) {
                                    throw new AssertionError((Object)e);
                                }
                            }
                        }
                    }, variableDef);
                    JDialog dialog = DataEntryPanelBuilder.createDataEntryPanelDialog(vp, dialogOwner, "Edit variable", "Update");
                    dialog.setVisible(true);
                }
            });
        }
    }

    public static void removeLabels(Document target) {
        try {
            for (int i = 0; i < target.getLength(); ++i) {
                if (!VariableLabel.getCharacterElement(target, i).getAttributes().isDefined(VAR_VALUE) || !target.getText(i, 1).equals(VARIABLE_CHAR)) continue;
                String varValue = (String)VariableLabel.getCharacterElement(target, i).getAttributes().getAttribute(VAR_VALUE);
                target.remove(i, 1);
                target.insertString(i, VariableLabel.formatVariable(varValue), null);
            }
        }
        catch (BadLocationException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getText(Document target) {
        try {
            StringBuffer sb = new StringBuffer("");
            for (int i = 0; i < target.getLength(); ++i) {
                if (VariableLabel.getCharacterElement(target, i).getAttributes().isDefined(VAR_VALUE) && target.getText(i, 1).equals(VARIABLE_CHAR)) {
                    String varValue = (String)VariableLabel.getCharacterElement(target, i).getAttributes().getAttribute(VAR_VALUE);
                    sb.append(VariableLabel.formatVariable(varValue));
                    continue;
                }
                sb.append(target.getText(i, 1));
            }
            return sb.toString();
        }
        catch (BadLocationException e) {
            throw new RuntimeException(e);
        }
    }

    public static void insertLabels(SPVariableHelper helper, Document target, Component dialogOwner) {
        VariableLabel.insertLabels(helper, target, dialogOwner, true);
    }

    public static void insertLabels(SPVariableHelper helper, Document target, Component dialogOwner, boolean showVariablesPanelOnClick) {
        try {
            while (true) {
                String text = target.getText(0, target.getLength());
                int indexStart = text.indexOf("${");
                int indexEnd = text.indexOf("}");
                if (indexStart != -1 && indexEnd != -1) {
                    String var = text.substring(indexStart, indexEnd + 1);
                    var = var.replaceFirst("\\$", "").replaceFirst("\\{", "").replaceFirst("\\}", "");
                    target.remove(indexStart, indexEnd - indexStart + 1);
                    VariableLabel.insertLabel(var, helper, target, indexStart, dialogOwner, showVariablesPanelOnClick);
                    continue;
                }
                break;
            }
        }
        catch (BadLocationException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static void insertLabelForPicollo(String variableDef, Document target, int insertPosition) throws BadLocationException {
        SimpleAttributeSet varStyle = new SimpleAttributeSet();
        varStyle.addAttribute(VAR_VALUE, variableDef);
        StyleConstants.setBackground(varStyle, Color.BLUE);
        StyleConstants.setForeground(varStyle, Color.WHITE);
        StyleConstants.setBold(varStyle, true);
        target.insertString(insertPosition, " " + SPVariableHelper.getKey(variableDef) + " ", varStyle);
    }

    public static void insertLabelsForPicollo(Document target) {
        try {
            while (true) {
                String text = target.getText(0, target.getLength());
                int indexStart = text.indexOf("${");
                int indexEnd = text.indexOf("}");
                if (indexStart != -1 && indexEnd != -1) {
                    String var = text.substring(indexStart, indexEnd + 1);
                    var = var.replaceFirst("\\$", "").replaceFirst("\\{", "").replaceFirst("\\}", "");
                    target.remove(indexStart, indexEnd - indexStart + 1);
                    VariableLabel.insertLabelForPicollo(var, target, indexStart);
                    continue;
                }
                break;
            }
        }
        catch (BadLocationException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static void removeLabelsForPicollo(Document target) {
        try {
            for (int i = 0; i < target.getLength(); ++i) {
                int endIndex;
                if (!VariableLabel.getCharacterElement(target, i).getAttributes().isDefined(VAR_VALUE)) continue;
                for (endIndex = i; endIndex < target.getLength() && VariableLabel.getCharacterElement(target, endIndex).getAttributes().isDefined(VAR_VALUE); ++endIndex) {
                }
                String varValue = (String)VariableLabel.getCharacterElement(target, i).getAttributes().getAttribute(VAR_VALUE);
                target.remove(i, endIndex - i);
                target.insertString(i, VariableLabel.formatVariable(varValue), null);
            }
        }
        catch (BadLocationException e) {
            throw new RuntimeException(e);
        }
    }

    public static String formatVariable(String variableName) {
        return "${" + variableName + "}";
    }

    public static String stripVariable(String formattedVariableName) {
        int indexStart = formattedVariableName.indexOf("${");
        int indexEnd = formattedVariableName.indexOf("}");
        if (indexStart == -1 || indexEnd == -1 || indexStart > indexEnd) {
            return formattedVariableName;
        }
        String var = formattedVariableName.substring(indexStart, indexEnd + 1);
        return var.replaceFirst("\\$", "").replaceFirst("\\{", "").replaceFirst("\\}", "");
    }

    public static Element getCharacterElement(Document doc, int pos) {
        Element e = null;
        e = doc.getDefaultRootElement();
        while (!e.isLeaf()) {
            int index = e.getElementIndex(pos);
            e = e.getElement(index);
        }
        return e;
    }
}

