/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui.critic;

import ca.sqlpower.architect.ddl.critic.CriticGrouping;
import ca.sqlpower.architect.ddl.critic.CriticManager;
import ca.sqlpower.architect.swingui.ArchitectSwingSession;
import ca.sqlpower.architect.swingui.critic.CriticGroupingPanel;
import ca.sqlpower.architect.swingui.critic.CriticSettingsPanelFactory;
import ca.sqlpower.swingui.DataEntryPanel;
import com.jgoodies.forms.builder.ButtonBarBuilder2;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.prefs.BackingStoreException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class CriticManagerPanel
implements DataEntryPanel {
    private final JPanel mainPanel;
    private final List<CriticGroupingPanel> groupingPanels = new ArrayList<CriticGroupingPanel>();
    private CriticManager criticManager;
    private int preferredCriticPanelSize = 0;
    private final CriticSettingsPanelFactory settingsPanelFactory;

    public CriticManagerPanel(ArchitectSwingSession session, CriticSettingsPanelFactory settingsPanelFactory) {
        this.settingsPanelFactory = settingsPanelFactory;
        this.mainPanel = new JPanel();
        DefaultFormBuilder builder = new DefaultFormBuilder(new FormLayout("pref"));
        this.criticManager = session.getWorkspace().getCriticManager();
        for (CriticGrouping grouping : this.criticManager.getCriticGroupings()) {
            CriticGroupingPanel criticGroupingPanel = new CriticGroupingPanel(grouping, this);
            builder.append((Component)criticGroupingPanel.getPanel());
            builder.nextLine();
            this.groupingPanels.add(criticGroupingPanel);
        }
        DefaultFormBuilder outerBuilder = new DefaultFormBuilder(new FormLayout("pref:grow", "min(pref;400dlu):grow"), this.mainPanel);
        JScrollPane criticsPane = new JScrollPane(builder.getPanel());
        criticsPane.setVerticalScrollBarPolicy(22);
        outerBuilder.append((Component)criticsPane);
        outerBuilder.nextLine();
        ButtonBarBuilder2 buttonBar = new ButtonBarBuilder2();
        buttonBar.addButton((Action)new AbstractAction("Restore Defaults"){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (CriticManagerPanel.this.doApplyChanges()) {
                    CriticManagerPanel.this.criticManager.loadDefaults();
                }
            }
        });
        buttonBar.addButton((Action)new AbstractAction("Set As Defaults"){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    if (CriticManagerPanel.this.doApplyChanges()) {
                        CriticManagerPanel.this.criticManager.saveAsDefaults();
                    }
                }
                catch (BackingStoreException ex) {
                    throw new RuntimeException(ex);
                }
            }
        });
        buttonBar.addGlue();
        outerBuilder.append((Component)buttonBar.getPanel());
    }

    public boolean applyChanges() {
        boolean changesApplied = this.doApplyChanges();
        if (changesApplied) {
            this.cleanup();
        }
        return changesApplied;
    }

    private boolean doApplyChanges() {
        try {
            this.criticManager.begin("Updating manager by user");
            for (CriticGroupingPanel panel : this.groupingPanels) {
                if (panel.applyChanges()) continue;
                this.criticManager.rollback("Could not apply changes.");
                return false;
            }
            this.criticManager.commit();
        }
        catch (Throwable t) {
            this.criticManager.rollback(t.getMessage());
            throw new RuntimeException(t);
        }
        return true;
    }

    public void discardChanges() {
        for (CriticGroupingPanel panel : this.groupingPanels) {
            panel.discardChanges();
        }
        this.cleanup();
    }

    public JComponent getPanel() {
        return this.mainPanel;
    }

    public boolean hasUnsavedChanges() {
        for (CriticGroupingPanel panel : this.groupingPanels) {
            if (!panel.hasUnsavedChanges()) continue;
            return true;
        }
        return false;
    }

    private void cleanup() {
        for (CriticGroupingPanel panel : this.groupingPanels) {
            panel.cleanup();
        }
    }

    public void setPreferredCriticPanelSize(int preferredCriticPanelSize) {
        int oldSize = this.preferredCriticPanelSize;
        this.preferredCriticPanelSize = preferredCriticPanelSize;
        if (oldSize != preferredCriticPanelSize) {
            for (CriticGroupingPanel groupPanel : this.groupingPanels) {
                groupPanel.revalidateTree();
            }
        }
    }

    public int getPreferredCriticPanelSize() {
        return this.preferredCriticPanelSize;
    }

    public CriticSettingsPanelFactory getSettingsPanelFactory() {
        return this.settingsPanelFactory;
    }
}

