/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.extension.report;

import java.io.File;
import java.util.List;
import org.parosproxy.paros.CommandLine;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.extension.CommandLineArgument;
import org.parosproxy.paros.extension.CommandLineListener;
import org.parosproxy.paros.extension.ExtensionAdaptor;
import org.parosproxy.paros.extension.ExtensionHook;
import org.parosproxy.paros.extension.report.ReportLastScan;
import org.zaproxy.zap.view.ZapMenuItem;

public class ExtensionReport
extends ExtensionAdaptor
implements CommandLineListener {
    private static final String NAME = "ExtensionReport";
    private static final int ARG_LAST_SCAN_REPORT_IDX = 0;
    private ZapMenuItem menuItemHtmlReport = null;
    private ZapMenuItem menuItemMdReport = null;
    private ZapMenuItem menuItemXmlReport = null;
    private ZapMenuItem menuItemJsonReport = null;
    private CommandLineArgument[] arguments = new CommandLineArgument[1];

    public ExtensionReport() {
        super(NAME);
        this.setOrder(14);
    }

    @Override
    public String getUIName() {
        return Constant.messages.getString("report.name");
    }

    @Override
    public void hook(ExtensionHook extensionHook) {
        super.hook(extensionHook);
        if (this.getView() != null) {
            extensionHook.getHookMenu().addReportMenuItem(this.getMenuItemHtmlReport());
            extensionHook.getHookMenu().addReportMenuItem(this.getMenuItemXmlReport());
            extensionHook.getHookMenu().addReportMenuItem(this.getMenuItemMdReport());
            extensionHook.getHookMenu().addReportMenuItem(this.getMenuItemJsonReport());
        }
        extensionHook.addCommandLine(this.getCommandLineArguments());
    }

    private ZapMenuItem getMenuItemHtmlReport() {
        if (this.menuItemHtmlReport == null) {
            this.menuItemHtmlReport = new ZapMenuItem("menu.report.html.generate");
            this.menuItemHtmlReport.addActionListener(e -> new ReportLastScan().generateReport(this.getView(), ReportLastScan.ReportType.HTML));
        }
        return this.menuItemHtmlReport;
    }

    private ZapMenuItem getMenuItemXmlReport() {
        if (this.menuItemXmlReport == null) {
            this.menuItemXmlReport = new ZapMenuItem("menu.report.xml.generate");
            this.menuItemXmlReport.addActionListener(e -> new ReportLastScan().generateReport(this.getView(), ReportLastScan.ReportType.XML));
        }
        return this.menuItemXmlReport;
    }

    private ZapMenuItem getMenuItemMdReport() {
        if (this.menuItemMdReport == null) {
            this.menuItemMdReport = new ZapMenuItem("menu.report.md.generate");
            this.menuItemMdReport.addActionListener(e -> new ReportLastScan().generateReport(this.getView(), ReportLastScan.ReportType.MD));
        }
        return this.menuItemMdReport;
    }

    private ZapMenuItem getMenuItemJsonReport() {
        if (this.menuItemJsonReport == null) {
            this.menuItemJsonReport = new ZapMenuItem("menu.report.json.generate");
            this.menuItemJsonReport.addActionListener(e -> new ReportLastScan().generateReport(this.getView(), ReportLastScan.ReportType.JSON));
        }
        return this.menuItemJsonReport;
    }

    @Override
    public void execute(CommandLineArgument[] args) {
        if (this.arguments[0].isEnabled()) {
            CommandLineArgument arg = this.arguments[0];
            ReportLastScan report = new ReportLastScan();
            String fileName = arg.getArguments().get(0);
            try {
                report.generate(fileName, ReportLastScan.ReportType.HTML);
                CommandLine.info("Last Scan Report generated at " + fileName);
            }
            catch (Exception e) {
                CommandLine.error(e.getMessage(), e);
            }
        } else {
            return;
        }
    }

    private CommandLineArgument[] getCommandLineArguments() {
        this.arguments[0] = new CommandLineArgument("-last_scan_report", 1, null, "", Constant.messages.getString("report.cmdline.gen.help"));
        return this.arguments;
    }

    @Override
    public String getAuthor() {
        return "Chinotec Technologies";
    }

    @Override
    public boolean handleFile(File file) {
        return false;
    }

    @Override
    public List<String> getHandledExtensions() {
        return null;
    }
}

