/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search.scope.packageSet;

import com.intellij.ProjectTopics;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.ModuleListener;
import com.intellij.openapi.project.Project;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.psi.search.scope.packageSet.PackageSet;
import com.intellij.psi.search.scope.packageSet.PatternBasedPackageSet;
import com.intellij.util.Function;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public final class UpdatingScopeOnProjectStructureChangeListener
implements ProjectComponent,
ModuleListener {
    public UpdatingScopeOnProjectStructureChangeListener(@NotNull Project project) {
        if (project == null) {
            UpdatingScopeOnProjectStructureChangeListener.$$$reportNull$$$0(0);
        }
        project.getMessageBus().connect().subscribe(ProjectTopics.MODULES, (Object)this);
    }

    @Override
    public void modulesRenamed(@NotNull Project project, @NotNull List<Module> modules, @NotNull Function<Module, String> oldNameProvider) {
        if (project == null) {
            UpdatingScopeOnProjectStructureChangeListener.$$$reportNull$$$0(1);
        }
        if (modules == null) {
            UpdatingScopeOnProjectStructureChangeListener.$$$reportNull$$$0(2);
        }
        if (oldNameProvider == null) {
            UpdatingScopeOnProjectStructureChangeListener.$$$reportNull$$$0(3);
        }
        Map<String, String> moduleMap = modules.stream().collect(Collectors.toMap(arg_0 -> oldNameProvider.fun(arg_0), Module::getName));
        for (NamedScopesHolder holder : NamedScopesHolder.getAllNamedScopeHolders(project)) {
            Object[] oldScopes = holder.getEditableScopes();
            Object[] newScopes = new NamedScope[oldScopes.length];
            for (int i = 0; i < oldScopes.length; ++i) {
                newScopes[i] = UpdatingScopeOnProjectStructureChangeListener.renameModulesIn((NamedScope)oldScopes[i], moduleMap);
            }
            if (Arrays.equals(newScopes, oldScopes)) continue;
            holder.setScopes((NamedScope[])newScopes);
        }
    }

    private static NamedScope renameModulesIn(NamedScope scope, Map<String, String> nameMapping) {
        PackageSet oldSet = scope.getValue();
        if (oldSet == null) {
            return scope;
        }
        PackageSet newSet = oldSet.map(packageSet -> {
            String modulePattern;
            String newName;
            if (packageSet instanceof PatternBasedPackageSet && (newName = (String)nameMapping.get(modulePattern = ((PatternBasedPackageSet)packageSet).getModulePattern())) != null) {
                return ((PatternBasedPackageSet)packageSet).updateModulePattern(modulePattern, newName);
            }
            return packageSet;
        });
        if (newSet != oldSet) {
            String presentableName = scope.getPresentableName();
            return new NamedScope(scope.getScopeId(), () -> presentableName, scope.getIcon(), newSet);
        }
        return scope;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modules";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldNameProvider";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/search/scope/packageSet/UpdatingScopeOnProjectStructureChangeListener";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "modulesRenamed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

