/*
 * Decompiled with CFR 0.152.
 */
package org.fest.reflect.field;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.fest.reflect.exception.ReflectionError;
import org.fest.reflect.util.Accessibles;
import org.fest.reflect.util.Types;
import org.fest.util.Preconditions;

public final class FieldAccessor<T> {
    private final Class<T> fieldType;
    private final Object target;
    private final Field field;
    private final boolean accessible;

    FieldAccessor(@Nonnull String fieldName, @Nonnull Class<T> fieldType, @Nonnull Object target) {
        this.fieldType = (Class)Preconditions.checkNotNull(fieldType);
        this.target = Preconditions.checkNotNull((Object)target);
        this.field = this.findFieldInClassHierarchy(Preconditions.checkNotNullOrEmpty((String)fieldName));
        this.accessible = this.field.isAccessible();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    private Field findFieldInClassHierarchy(@Nonnull String fieldName) {
        Class<?> originalType;
        AccessibleObject field = null;
        for (Class<?> targetType = originalType = this.target instanceof Class ? (Class<?>)this.target : this.target.getClass(); targetType != null; targetType = targetType.getSuperclass()) {
            try {
                field = targetType.getDeclaredField(fieldName);
                break;
            }
            catch (NoSuchFieldException e) {
                continue;
            }
        }
        if (field != null) {
            boolean isAccessible = field.isAccessible();
            try {
                Accessibles.makeAccessible(field);
                Class<?> actualType = ((Field)field).getType();
                if (!this.fieldType.isAssignableFrom(actualType)) {
                    String format = "Expecting type of field '%s' in %s to be <%s> but was <%s>";
                    String msg = String.format(format, fieldName, originalType.getName(), this.fieldType.getName(), actualType.getName());
                    throw new ReflectionError(msg);
                }
            }
            finally {
                Accessibles.setAccessibleIgnoringExceptions(field, isAccessible);
            }
            return field;
        }
        String format = "Failed to find field '%s' in %s";
        String msg = String.format(format, fieldName, originalType.getName());
        throw new ReflectionError(msg);
    }

    public void set(@Nullable T value) {
        Field f = (Field)Preconditions.checkNotNull((Object)this.field);
        try {
            Accessibles.setAccessible(f, true);
            f.set(this.target, value);
        }
        catch (Throwable t) {
            String format = "Failed to set value %s in field '%s'";
            String msg = String.format(format, String.valueOf(value), f.getName());
            throw new ReflectionError(msg, t);
        }
        finally {
            Accessibles.setAccessibleIgnoringExceptions(f, this.accessible);
        }
    }

    @Nullable
    public T get() {
        Field f = (Field)Preconditions.checkNotNull((Object)this.field);
        try {
            Accessibles.setAccessible(f, true);
            Object value = f.get(this.target);
            Object t = Types.castSafely(value, (Class)Preconditions.checkNotNull(this.fieldType));
            return t;
        }
        catch (Throwable t) {
            String msg = String.format("Failed to get the value of field '%s'", f.getName());
            throw new ReflectionError(msg, t);
        }
        finally {
            Accessibles.setAccessibleIgnoringExceptions(f, this.accessible);
        }
    }

    @Nonnull
    public Field target() {
        return this.field;
    }
}

