/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.process;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.io.IOException;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProcessInfo {
    public static final ProcessInfo[] EMPTY_ARRAY = new ProcessInfo[0];
    private final int myPid;
    @NotNull
    private final String myCommandLine;
    @NotNull
    private final Optional<String> myExecutablePath;
    @NotNull
    private final String myExecutableName;
    @NotNull
    private final String myArgs;

    public ProcessInfo(int pid, @NotNull String commandLine, @NotNull String executableName, @NotNull String args) {
        if (commandLine == null) {
            ProcessInfo.$$$reportNull$$$0(0);
        }
        if (executableName == null) {
            ProcessInfo.$$$reportNull$$$0(1);
        }
        if (args == null) {
            ProcessInfo.$$$reportNull$$$0(2);
        }
        this.myPid = pid;
        this.myCommandLine = commandLine;
        this.myExecutablePath = Optional.empty();
        this.myExecutableName = executableName;
        this.myArgs = args;
    }

    public ProcessInfo(int pid, @NotNull String commandLine, @NotNull String executableName, @NotNull String args, @Nullable String executablePath) {
        if (commandLine == null) {
            ProcessInfo.$$$reportNull$$$0(3);
        }
        if (executableName == null) {
            ProcessInfo.$$$reportNull$$$0(4);
        }
        if (args == null) {
            ProcessInfo.$$$reportNull$$$0(5);
        }
        this.myPid = pid;
        this.myCommandLine = commandLine;
        this.myExecutableName = executableName;
        this.myExecutablePath = StringUtil.isNotEmpty((String)executablePath) ? Optional.of(executablePath) : Optional.empty();
        this.myArgs = args;
    }

    public int getPid() {
        return this.myPid;
    }

    @NotNull
    @NlsSafe
    public String getCommandLine() {
        String string = this.myCommandLine;
        if (string == null) {
            ProcessInfo.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    @NlsSafe
    public String getExecutableName() {
        String string = this.myExecutableName;
        if (string == null) {
            ProcessInfo.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    @NlsSafe
    public Optional<String> getExecutableCannonicalPath() {
        Optional<String> optional = this.myExecutablePath.map(s -> {
            try {
                return new File((String)s).getCanonicalPath();
            }
            catch (IOException e) {
                return s;
            }
        });
        if (optional == null) {
            ProcessInfo.$$$reportNull$$$0(8);
        }
        return optional;
    }

    @NotNull
    @NlsSafe
    public String getExecutableDisplayName() {
        String string = StringUtil.trimEnd((String)this.myExecutableName, (String)".exe", (boolean)true);
        if (string == null) {
            ProcessInfo.$$$reportNull$$$0(9);
        }
        return string;
    }

    @NotNull
    @NlsSafe
    public String getArgs() {
        String string = this.myArgs;
        if (string == null) {
            ProcessInfo.$$$reportNull$$$0(10);
        }
        return string;
    }

    public String toString() {
        return this.myPid + " '" + this.myCommandLine + "' '" + this.myExecutableName + "' '" + this.myArgs + "'" + this.myExecutablePath.map(s -> " " + s).orElse("");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProcessInfo info = (ProcessInfo)o;
        if (this.myPid != info.myPid) {
            return false;
        }
        if (!this.myExecutableName.equals(info.myExecutableName)) {
            return false;
        }
        if (!this.myArgs.equals(info.myArgs)) {
            return false;
        }
        if (!this.myCommandLine.equals(info.myCommandLine)) {
            return false;
        }
        return this.myExecutablePath.equals(info.myExecutablePath);
    }

    public int hashCode() {
        int result = this.myPid;
        result = 31 * result + this.myExecutableName.hashCode();
        result = 31 * result + this.myArgs.hashCode();
        result = 31 * result + this.myCommandLine.hashCode();
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executableName";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/process/ProcessInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/process/ProcessInfo";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandLine";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getExecutableName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getExecutableCannonicalPath";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getExecutableDisplayName";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getArgs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

