/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.settingsRepository.git;

import java.text.MessageFormat;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.eclipse.jgit.dircache.BaseDirCacheEditor;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.Repository;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.settingsRepository.git.AddFile;
import org.jetbrains.settingsRepository.git.AddLoadedFile;
import org.jetbrains.settingsRepository.git.DeleteDirectory;
import org.jetbrains.settingsRepository.git.DeleteFile;
import org.jetbrains.settingsRepository.git.DirCacheEditorKt;
import org.jetbrains.settingsRepository.git.PathEdit;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B+\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\f\u001a\u00020\rH\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\rH\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/settingsRepository/git/DirCacheEditor;", "Lorg/eclipse/jgit/dircache/BaseDirCacheEditor;", "edits", "", "Lorg/jetbrains/settingsRepository/git/PathEdit;", "repository", "Lorg/eclipse/jgit/lib/Repository;", "dirCache", "Lorg/eclipse/jgit/dircache/DirCache;", "estimatedNumberOfEntries", "", "(Ljava/util/List;Lorg/eclipse/jgit/lib/Repository;Lorg/eclipse/jgit/dircache/DirCache;I)V", "applyEdits", "", "commit", "", "finish", "intellij.settingsRepository"})
public final class DirCacheEditor
extends BaseDirCacheEditor {
    private final List<PathEdit> edits;
    private final Repository repository;

    public boolean commit() {
        if (this.edits.isEmpty()) {
            this.cache.unlock();
            return true;
        }
        return super.commit();
    }

    public void finish() {
        if (!this.edits.isEmpty()) {
            this.applyEdits();
            this.replace();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void applyEdits() {
        DirCache dirCache = this.cache;
        Intrinsics.checkNotNullExpressionValue((Object)dirCache, (String)"cache");
        int maxIndex = dirCache.getEntryCount();
        int lastIndex = 0;
        for (PathEdit edit2 : this.edits) {
            int count;
            boolean missing;
            int entryIndex = this.cache.findEntry(edit2.getPath(), edit2.getPath().length);
            boolean bl = missing = entryIndex < 0;
            if (entryIndex < 0) {
                entryIndex = -(entryIndex + 1);
            }
            if ((count = Math.min(entryIndex, maxIndex) - lastIndex) > 0) {
                this.fastKeep(lastIndex, count);
            }
            int n = lastIndex = missing ? entryIndex : this.cache.nextEntry(entryIndex);
            if (edit2 instanceof DeleteFile) continue;
            if (edit2 instanceof DeleteDirectory) {
                lastIndex = this.cache.nextEntry(edit2.getPath(), edit2.getPath().length, entryIndex);
                continue;
            }
            if (missing) {
                DirCacheEntry entry = new DirCacheEntry(edit2.getPath());
                edit2.apply(entry, this.repository);
                if (entry.getRawMode() == 0) {
                    throw (Throwable)new IllegalArgumentException(MessageFormat.format(JGitText.get().fileModeNotSetForPath, entry.getPathString()));
                }
                this.fastAdd(entry);
                continue;
            }
            if (edit2 instanceof AddFile || edit2 instanceof AddLoadedFile) {
                DirCacheEntry firstEntry = this.cache.getEntry(entryIndex);
                DirCacheEntry entry = null;
                DirCacheEntry dirCacheEntry = firstEntry;
                Intrinsics.checkNotNullExpressionValue((Object)dirCacheEntry, (String)"firstEntry");
                if (dirCacheEntry.isMerged()) {
                    entry = firstEntry;
                } else {
                    entry = new DirCacheEntry(edit2.getPath());
                    entry.setCreationTime(firstEntry.getCreationTime());
                }
                edit2.apply(entry, this.repository);
                this.fastAdd(entry);
                continue;
            }
            int firstEntry = entryIndex;
            int n2 = lastIndex;
            while (firstEntry < n2) {
                void i;
                DirCacheEntry entry;
                DirCacheEntry dirCacheEntry = entry = this.cache.getEntry((int)i);
                Intrinsics.checkNotNullExpressionValue((Object)dirCacheEntry, (String)"entry");
                edit2.apply(dirCacheEntry, this.repository);
                this.fastAdd(entry);
                ++i;
            }
        }
        int count = maxIndex - lastIndex;
        if (count > 0) {
            this.fastKeep(lastIndex, count);
        }
    }

    public DirCacheEditor(@NotNull List<? extends PathEdit> edits, @NotNull Repository repository2, @NotNull DirCache dirCache, int estimatedNumberOfEntries) {
        Intrinsics.checkNotNullParameter(edits, (String)"edits");
        Intrinsics.checkNotNullParameter((Object)repository2, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)dirCache, (String)"dirCache");
        super(dirCache, estimatedNumberOfEntries);
        this.repository = repository2;
        this.edits = CollectionsKt.sortedWith((Iterable)edits, (Comparator)DirCacheEditorKt.access$getEDIT_CMP$p());
    }
}

