/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.diff;

import com.intellij.diff.DiffContentFactory;
import com.intellij.diff.DiffManager;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.SimpleDiffRequest;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.api.Revision;
import org.jetbrains.idea.svn.api.Target;
import org.jetbrains.idea.svn.api.Url;
import org.jetbrains.idea.svn.diff.ElementWithBranchComparer;

public class FileWithBranchComparer
extends ElementWithBranchComparer {
    @NotNull
    private final Ref<byte[]> content;
    private final @NlsContexts.Label @NotNull StringBuilder remoteTitleBuilder;
    @NotNull
    private final Ref<Boolean> success;

    public FileWithBranchComparer(@NotNull Project project, @NotNull VirtualFile virtualFile, @NotNull Url branchUrl, long branchRevision) {
        if (project == null) {
            FileWithBranchComparer.$$$reportNull$$$0(0);
        }
        if (virtualFile == null) {
            FileWithBranchComparer.$$$reportNull$$$0(1);
        }
        if (branchUrl == null) {
            FileWithBranchComparer.$$$reportNull$$$0(2);
        }
        super(project, virtualFile, branchUrl, branchRevision);
        this.content = new Ref();
        this.remoteTitleBuilder = new StringBuilder();
        this.success = new Ref();
    }

    @Override
    protected void beforeCompare() {
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        if (indicator != null) {
            indicator.setIndeterminate(true);
        }
    }

    @Override
    protected void compare() throws VcsException {
        this.remoteTitleBuilder.append(this.myElementUrl.toDecodedString());
        this.content.set((Object)SvnUtil.getFileContents(this.myVcs, Target.on(this.myElementUrl), Revision.HEAD, Revision.UNDEFINED));
        this.success.set((Object)true);
    }

    @Override
    protected void showResult() {
        if (!this.success.isNull()) {
            String title = SvnBundle.message("compare.with.branch.diff.title", new Object[0]);
            String title1 = this.remoteTitleBuilder.toString();
            String title2 = this.myVirtualFile.getPresentableUrl();
            try {
                DiffContent content1 = DiffContentFactory.getInstance().createFromBytes(this.myProject, (byte[])this.content.get(), this.myVirtualFile);
                DiffContent content2 = DiffContentFactory.getInstance().create(this.myProject, this.myVirtualFile);
                SimpleDiffRequest request = new SimpleDiffRequest(title, content1, content2, title1, title2);
                DiffManager.getInstance().showDiff(this.myProject, (DiffRequest)request);
            }
            catch (IOException e) {
                this.reportGeneralException(e);
            }
        }
    }

    @Override
    @NotNull
    public String getTitle() {
        String string = SvnBundle.message("compare.with.branch.progress.loading.content", new Object[0]);
        if (string == null) {
            FileWithBranchComparer.$$$reportNull$$$0(3);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branchUrl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/svn/diff/FileWithBranchComparer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/svn/diff/FileWithBranchComparer";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTitle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

