/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.VcsShowToolWindowTabAction;
import com.intellij.vcs.log.VcsLogBundle;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.impl.VcsProjectLog;
import com.intellij.vcs.log.util.VcsLogUtil;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u0014\u0010\u0003\u001a\u00020\u00048TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lcom/intellij/vcs/log/ui/actions/VcsShowLogAction;", "Lcom/intellij/vcs/VcsShowToolWindowTabAction;", "()V", "tabName", "", "getTabName", "()Ljava/lang/String;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.platform.vcs.log.impl"})
public final class VcsShowLogAction
extends VcsShowToolWindowTabAction {
    @Override
    @NotNull
    protected String getTabName() {
        return "Log";
    }

    @Override
    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        super.update(e);
        Project project = e.getProject();
        if (project != null) {
            Map<VirtualFile, VcsLogProvider> map2 = VcsProjectLog.getLogProviders(project);
            Intrinsics.checkNotNullExpressionValue(map2, (String)"VcsProjectLog.getLogProviders(project)");
            Map<VirtualFile, VcsLogProvider> providers = map2;
            String string = VcsLogUtil.getVcsDisplayName(project, providers.values());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"VcsLogUtil.getVcsDisplay\u2026roject, providers.values)");
            String vcsName = string;
            Presentation presentation = e.getPresentation();
            Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"e.presentation");
            presentation.setText(VcsLogBundle.message((String)"action.Vcs.Show.Log.text.template", (Object[])new Object[]{vcsName}));
        }
    }
}

