/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui.table;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.DottedBorder;
import com.intellij.ui.EditorSettingsProvider;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.TableUtil;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.table.JBTable;
import com.intellij.util.ui.AbstractTableCellEditor;
import com.intellij.util.ui.MouseEventHandler;
import com.intellij.util.ui.TimerUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.table.JBListTableFocusTraversalPolicy;
import com.intellij.util.ui.table.JBListTableModel;
import com.intellij.util.ui.table.JBTableRow;
import com.intellij.util.ui.table.JBTableRowEditor;
import com.intellij.util.ui.table.JBTableRowRenderer;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.EventObject;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.Timer;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;

public abstract class JBListTable {
    protected final JBTable myInternalTable;
    private final JBTable myMainTable;
    private final RowResizeAnimator myRowResizeAnimator;
    protected MouseEvent myMouseEvent;
    private MyCellEditor myCellEditor;
    private int myLastFocusedEditorComponentIdx;

    public JBListTable(@NotNull JBTable t, @NotNull Disposable parent) {
        if (t == null) {
            JBListTable.$$$reportNull$$$0(0);
        }
        if (parent == null) {
            JBListTable.$$$reportNull$$$0(1);
        }
        this.myLastFocusedEditorComponentIdx = -1;
        this.myInternalTable = t;
        this.myMainTable = new MyTable();
        this.myMainTable.setTableHeader(null);
        this.myMainTable.setShowGrid(false);
        this.myRowResizeAnimator = new RowResizeAnimator((JTable)this.myMainTable);
        Disposer.register((Disposable)parent, (Disposable)this.myRowResizeAnimator);
    }

    public void setVisibleRowCount(int rowCount) {
        this.myInternalTable.setVisibleRowCount(rowCount);
    }

    public void stopEditing() {
        TableUtil.stopEditing((JTable)this.myMainTable);
    }

    private static void installPaddingAndBordersForEditors(JBTableRowEditor editor) {
        List editors2 = UIUtil.findComponentsOfType((JComponent)editor, EditorTextField.class);
        for (EditorTextField textField2 : editors2) {
            textField2.putClientProperty("JComboBox.isTableCellEditor", Boolean.FALSE);
            textField2.putClientProperty("JBListTable.isTableCellEditor", Boolean.TRUE);
        }
    }

    public final JBTable getTable() {
        return this.myMainTable;
    }

    protected abstract JBTableRowRenderer getRowRenderer(int var1);

    protected abstract JBTableRowEditor getRowEditor(int var1);

    protected JBTableRow getRowAt(final int row) {
        return new JBTableRow(){

            @Override
            public Object getValueAt(int column) {
                return JBListTable.this.myInternalTable.getValueAt(row, column);
            }
        };
    }

    protected boolean isRowEditable(int row) {
        return true;
    }

    protected boolean isRowEmpty(int row) {
        return false;
    }

    public static JComponent createEditorTextFieldPresentation(Project project, FileType type, String text2, boolean selected2, boolean focused) {
        JPanel panel2 = new JPanel(new BorderLayout());
        EditorTextField field = new EditorTextField(text2, project, type){

            @Override
            protected boolean shouldHaveBorder() {
                return false;
            }
        };
        Font font = EditorColorsManager.getInstance().getGlobalScheme().getFont(EditorFontType.PLAIN);
        font = new Font(font.getFontName(), font.getStyle(), JBUIScale.scaleFontSize((float)12.0f));
        field.setFont(font);
        field.addSettingsProvider(EditorSettingsProvider.NO_WHITESPACE);
        if (selected2 && focused) {
            panel2.setBackground(UIUtil.getTableSelectionBackground((boolean)true));
            field.setAsRendererWithSelection(UIUtil.getTableSelectionBackground((boolean)true), UIUtil.getTableSelectionForeground());
        } else {
            panel2.setBackground(UIUtil.getTableBackground());
            if (selected2) {
                panel2.setBorder((Border)new DottedBorder(UIUtil.getTableForeground()));
            }
        }
        panel2.add((Component)((Object)field), "West");
        return panel2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "t";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "parent";
                break;
            }
        }
        objectArray[1] = "com/intellij/util/ui/table/JBListTable";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class MyTableModel
    extends JBListTableModel {
        MyTableModel(TableModel model2) {
            super(model2);
        }

        @Override
        public JBTableRow getRow(int index) {
            return JBListTable.this.getRowAt(index);
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return JBListTable.this.isRowEditable(rowIndex);
        }

        @Override
        public void addRow() {
            JBListTable.this.myLastFocusedEditorComponentIdx = -1;
            super.addRow();
        }
    }

    private class MyTable
    extends JBTable {
        MyTable() {
            super((TableModel)new MyTableModel(JBListTable.this.myInternalTable.getModel()));
        }

        public MyTableModel getModel() {
            return (MyTableModel)super.getModel();
        }

        protected void processKeyEvent(KeyEvent e) {
            JBListTable.this.myMouseEvent = null;
            if (e.isAltDown()) {
                super.processKeyEvent(e);
                return;
            }
            if (e.getKeyCode() == 9) {
                if (e.getID() == 401) {
                    KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
                    if (e.isShiftDown()) {
                        keyboardFocusManager.focusPreviousComponent((Component)((Object)this));
                    } else {
                        keyboardFocusManager.focusNextComponent((Component)((Object)this));
                    }
                }
                e.consume();
                return;
            }
            super.processKeyEvent(e);
        }

        protected void processMouseEvent(MouseEvent e) {
            JBListTable.this.myMouseEvent = e;
            super.processMouseEvent(e);
        }

        public TableCellRenderer getCellRenderer(int row, int column) {
            final JBTableRowRenderer rowRenderer = JBListTable.this.getRowRenderer(row);
            return new TableCellRenderer(){

                @Override
                public Component getTableCellRendererComponent(JTable table, Object value2, boolean selected2, boolean focused, int row, int col) {
                    return rowRenderer.getRowRendererComponent((JTable)JBListTable.this.myInternalTable, row, selected2, focused);
                }
            };
        }

        protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
            boolean isDown;
            int row;
            if (e.isAltDown() || e.isMetaDown() || e.isControlDown()) {
                return false;
            }
            if (e.getKeyCode() == 27 && pressed && (row = this.getSelectedRow()) != -1 && JBListTable.this.isRowEmpty(row)) {
                int newRow;
                MyTableModel model2 = this.getModel();
                int count = model2.getRowCount();
                model2.removeRow(row);
                int n = newRow = count == row + 1 ? row - 1 : row;
                if (0 <= newRow && newRow < model2.getRowCount()) {
                    this.setRowSelectionInterval(newRow, newRow);
                }
            }
            if (e.getKeyCode() == 10) {
                if (e.getID() == 401) {
                    if (!this.isEditing() && e.getModifiers() == 0) {
                        this.editCellAt(this.getSelectedRow(), this.getSelectedColumn());
                    } else if (this.isEditing()) {
                        TableUtil.stopEditing((JTable)((Object)this));
                        if (e.isControlDown() || e.isMetaDown()) {
                            return false;
                        }
                        row = this.getSelectedRow() + 1;
                        if (row < this.getRowCount()) {
                            this.getSelectionModel().setSelectionInterval(row, row);
                        }
                    } else if (e.isControlDown() || e.isMetaDown()) {
                        return false;
                    }
                }
                e.consume();
                return true;
            }
            if (this.isEditing() && e.getKeyCode() == 9) {
                if (pressed) {
                    KeyboardFocusManager mgr = KeyboardFocusManager.getCurrentKeyboardFocusManager();
                    if (e.isShiftDown()) {
                        mgr.focusPreviousComponent();
                    } else {
                        mgr.focusNextComponent();
                    }
                }
                return true;
            }
            boolean isUp = e.getKeyCode() == 38;
            boolean bl = isDown = e.getKeyCode() == 40;
            if (this.isEditing() && (isUp || isDown) && e.getModifiers() == 0 && e.getID() == 401) {
                int row2 = this.getSelectedRow();
                super.processKeyBinding(ks, e, condition, pressed);
                if (!this.isEditing() && row2 != this.getSelectedRow()) {
                    TableUtil.editCellAt((JTable)((Object)this), (int)this.getSelectedRow(), (int)0);
                    e.consume();
                    return true;
                }
            }
            return super.processKeyBinding(ks, e, condition, pressed);
        }

        public void columnMarginChanged(ChangeEvent e) {
            TableColumn resizingColumn;
            TableColumn tableColumn = resizingColumn = this.tableHeader != null ? this.tableHeader.getResizingColumn() : null;
            if (resizingColumn != null && this.autoResizeMode == 0) {
                resizingColumn.setPreferredWidth(resizingColumn.getWidth());
            }
            this.resizeAndRepaint();
        }

        public TableCellEditor getCellEditor(int row, int column) {
            JBTableRowEditor editor = JBListTable.this.getRowEditor(row);
            if (editor != null) {
                editor.setMouseEvent(JBListTable.this.myMouseEvent);
                editor.prepareEditor((JTable)JBListTable.this.myInternalTable, row);
                JBListTable.installPaddingAndBordersForEditors(editor);
                editor.setFocusCycleRoot(true);
                editor.setFocusTraversalPolicy(new JBListTableFocusTraversalPolicy(editor));
                editor.addMouseListener((MouseListener)MouseEventHandler.CONSUMER);
                JBListTable.this.myCellEditor = new MyCellEditor(editor);
                return JBListTable.this.myCellEditor;
            }
            JBListTable.this.myCellEditor = null;
            return null;
        }

        public Component prepareEditor(TableCellEditor editor, int row, int column) {
            Object value2 = this.getValueAt(row, column);
            boolean isSelected = this.isCellSelected(row, column);
            return editor.getTableCellEditorComponent((JTable)((Object)this), value2, isSelected, row, column);
        }

        public void addNotify() {
            super.addNotify();
            JBListTable.this.myRowResizeAnimator.revive();
        }

        public void removeNotify() {
            super.removeNotify();
            Disposer.dispose((Disposable)JBListTable.this.myRowResizeAnimator);
        }
    }

    private static final class RowResizeAnimator
    implements ActionListener,
    Disposable {
        private static final int ANIMATION_STEP_MILLIS = 15;
        private static final int RESIZE_AMOUNT_PER_STEP = 5;
        private final Int2ObjectMap<RowAnimationState> myRowAnimationStates = new Int2ObjectOpenHashMap();
        private final Timer myAnimationTimer = TimerUtil.createNamedTimer((String)"JBListTableTimer", (int)15, (ActionListener)this);
        private final JTable myTable;
        private boolean myDisposed;

        RowResizeAnimator(JTable table) {
            this.myTable = table;
        }

        public void resize(int row, int targetHeight) {
            this.myRowAnimationStates.put(row, (Object)new RowAnimationState(row, targetHeight));
            this.startAnimation();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.doAnimationStep(e.getWhen());
        }

        void revive() {
            this.myDisposed = false;
        }

        public void dispose() {
            this.myDisposed = true;
            this.stopAnimation();
            this.doAnimationStep(Long.MAX_VALUE);
        }

        private void startAnimation() {
            if (!this.myAnimationTimer.isRunning() && !this.myDisposed) {
                this.myAnimationTimer.start();
            }
        }

        private void stopAnimation() {
            this.myAnimationTimer.stop();
        }

        private void doAnimationStep(long updateTime) {
            IntArrayList completeRows = new IntArrayList(this.myRowAnimationStates.size());
            for (Int2ObjectMap.Entry entry : this.myRowAnimationStates.int2ObjectEntrySet()) {
                if (!((RowAnimationState)entry.getValue()).doAnimationStep(updateTime)) continue;
                completeRows.add(entry.getIntKey());
            }
            completeRows.forEach(row -> this.myRowAnimationStates.remove(row));
            if (this.myRowAnimationStates.isEmpty()) {
                this.stopAnimation();
            }
        }

        private final class RowAnimationState {
            private final int myRow;
            private final int myTargetHeight;
            private long myLastUpdateTime;

            RowAnimationState(int row, int targetHeight) {
                this.myRow = row;
                this.myTargetHeight = targetHeight;
                this.myLastUpdateTime = System.currentTimeMillis();
            }

            public boolean doAnimationStep(long currentTime) {
                if (this.myRow >= RowResizeAnimator.this.myTable.getRowCount()) {
                    return true;
                }
                int currentRowHeight = RowResizeAnimator.this.myTable.getRowHeight(this.myRow);
                int resizeAbs = (int)(5.0 * ((double)(currentTime - this.myLastUpdateTime) / 15.0));
                int leftToAnimate = this.myTargetHeight - currentRowHeight;
                int newHeight = Math.abs(leftToAnimate) <= resizeAbs ? this.myTargetHeight : currentRowHeight + (leftToAnimate < 0 ? -resizeAbs : resizeAbs);
                RowResizeAnimator.this.myTable.setRowHeight(this.myRow, newHeight);
                this.myLastUpdateTime = currentTime;
                TableUtil.scrollSelectionToVisible((JTable)RowResizeAnimator.this.myTable);
                return this.myTargetHeight == newHeight;
            }
        }
    }

    private class MyCellEditor
    extends AbstractTableCellEditor {
        private final JBTableRowEditor myEditor;

        MyCellEditor(JBTableRowEditor editor) {
            this.myEditor = editor;
        }

        public boolean isCellEditable(EventObject e) {
            if (e instanceof MouseEvent && UIUtil.isSelectionButtonDown((MouseEvent)((MouseEvent)e))) {
                return false;
            }
            return super.isCellEditable(e);
        }

        public Component getTableCellEditorComponent(final JTable table, Object value2, boolean isSelected, final int row, int column) {
            final JPanel p = new JPanel(new BorderLayout()){

                @Override
                public void addNotify() {
                    super.addNotify();
                    int height = this.getPreferredSize().height;
                    if (height > table.getRowHeight(row)) {
                        JBListTable.this.myRowResizeAnimator.resize(row, height);
                    }
                }

                @Override
                public void removeNotify() {
                    if (JBListTable.this.myCellEditor != null) {
                        JBListTable.this.myCellEditor.saveFocusIndex();
                    }
                    super.removeNotify();
                    JBListTable.this.myRowResizeAnimator.resize(row, table.getRowHeight());
                }
            };
            p.addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent e) {
                    IdeFocusManager focusManager = IdeFocusManager.findInstanceByComponent((Component)p);
                    focusManager.requestFocus(this.getComponentToFocus(), true);
                }

                private Component getComponentToFocus() {
                    JComponent[] focusableComponents;
                    if (JBListTable.this.myLastFocusedEditorComponentIdx >= 0 && JBListTable.this.myLastFocusedEditorComponentIdx < (focusableComponents = MyCellEditor.this.myEditor.getFocusableComponents()).length) {
                        return focusableComponents[JBListTable.this.myLastFocusedEditorComponentIdx];
                    }
                    return MyCellEditor.this.myEditor.getPreferredFocusedComponent();
                }
            });
            p.add((Component)this.myEditor, "Center");
            return p;
        }

        public Object getCellEditorValue() {
            return this.myEditor.getValue();
        }

        public boolean stopCellEditing() {
            this.saveFocusIndex();
            return super.stopCellEditing();
        }

        public void cancelCellEditing() {
            this.saveFocusIndex();
            super.cancelCellEditing();
        }

        private void saveFocusIndex() {
            JComponent[] components = this.myEditor.getFocusableComponents();
            for (int i2 = 0; i2 < components.length; ++i2) {
                if (!components[i2].hasFocus()) continue;
                JBListTable.this.myLastFocusedEditorComponentIdx = i2;
                break;
            }
        }
    }
}

