/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Bitness;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.JdkBundle;
import com.intellij.util.lang.JavaVersion;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JdkBundleList {
    private static final Logger LOG = Logger.getInstance(JdkBundleList.class);
    private final Map<String, JdkBundle> myBundles = new LinkedHashMap<String, JdkBundle>();

    public void addBundlesFromLocation(@NotNull String location, @Nullable JavaVersion min, @Nullable JavaVersion max) {
        File[] vms;
        if (location == null) {
            JdkBundleList.$$$reportNull$$$0(0);
        }
        if ((vms = new File(location).listFiles()) == null || vms.length == 0) {
            return;
        }
        Bitness arch = SystemInfo.is64Bit ? Bitness.x64 : Bitness.x32;
        boolean jdkRequired = "true".equals(System.getProperty("idea.jre.check"));
        for (File vm : vms) {
            JdkBundle bundle = JdkBundle.createBundle(vm);
            if (bundle == null) continue;
            LOG.trace(bundle.getLocation() + ": " + bundle.getBundleVersion() + " " + bundle.getBitness() + " jdk=" + bundle.isJdk());
            if (bundle.getBitness() != arch || min != null && bundle.getBundleVersion().compareTo(min) < 0 || max != null && bundle.getBundleVersion().compareTo(max) >= 0 || jdkRequired && !bundle.isJdk() || !bundle.isOperational()) continue;
            this.addBundle(bundle);
        }
    }

    public void addBundle(@NotNull JdkBundle bundle) {
        String path;
        JdkBundle existing;
        if (bundle == null) {
            JdkBundleList.$$$reportNull$$$0(1);
        }
        if ((existing = this.myBundles.get(path = bundle.getLocation().getAbsolutePath())) == null || bundle.isBoot() && !existing.isBoot()) {
            this.myBundles.put(path, bundle);
        }
    }

    @NotNull
    public Collection<JdkBundle> getBundles() {
        Collection<JdkBundle> collection = Collections.unmodifiableCollection(this.myBundles.values());
        if (collection == null) {
            JdkBundleList.$$$reportNull$$$0(2);
        }
        return collection;
    }

    @Nullable
    public JdkBundle getBundle(@NotNull String path) {
        if (path == null) {
            JdkBundleList.$$$reportNull$$$0(3);
        }
        return this.myBundles.get(path);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bundle";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/JdkBundleList";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/JdkBundleList";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getBundles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addBundlesFromLocation";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "addBundle";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getBundle";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

