/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.actions;

import com.intellij.navigation.ChooserKt;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.UpdateInBackground;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.SyntheticElement;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.rename.PsiElementRenameHandler;
import com.intellij.refactoring.rename.Renamer;
import com.intellij.refactoring.rename.RenamerFactory;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class RenameElementAction
extends AnAction
implements UpdateInBackground {
    public RenameElementAction() {
        this.setInjectedContext(true);
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            RenameElementAction.$$$reportNull$$$0(0);
        }
        e.getPresentation().setEnabled(this.isAvailable(e.getDataContext()));
    }

    @ApiStatus.Internal
    public boolean isAvailable(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            RenameElementAction.$$$reportNull$$$0(1);
        }
        return dataContext.getData(CommonDataKeys.PROJECT) != null && RenameElementAction.getAvailableRenamers(dataContext).findAny().isPresent();
    }

    public final void actionPerformed(@NotNull AnActionEvent e) {
        DataContext dataContext;
        Project project;
        if (e == null) {
            RenameElementAction.$$$reportNull$$$0(2);
        }
        if ((project = (Project)(dataContext = e.getDataContext()).getData(CommonDataKeys.PROJECT)) == null) {
            return;
        }
        if (!PsiDocumentManager.getInstance((Project)project).commitAllDocumentsUnderProgress()) {
            return;
        }
        List renamers = RenameElementAction.getAvailableRenamers(dataContext).collect(Collectors.toList());
        if (renamers.isEmpty()) {
            String message = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"error.wrong.caret.position.symbol.to.refactor"));
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)((Editor)e.getData(CommonDataKeys.EDITOR)), (String)message, (String)RefactoringBundle.getCannotRefactorMessage(null), null);
        } else if (renamers.size() == 1) {
            ((Renamer)renamers.get(0)).performRename();
        } else {
            ChooserKt.chooseTargetPopup(RefactoringBundle.message((String)"what.would.you.like.to.do"), renamers, renamer -> () -> ((Renamer)renamer).getPresentableText(), Renamer::performRename).showInBestPositionFor(dataContext);
        }
    }

    @NotNull
    private static Stream<Renamer> getAvailableRenamers(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            RenameElementAction.$$$reportNull$$$0(3);
        }
        Stream<Renamer> stream = RenamerFactory.EP_NAME.extensions().flatMap(factory2 -> factory2.createRenamers(dataContext).stream());
        if (stream == null) {
            RenameElementAction.$$$reportNull$$$0(4);
        }
        return stream;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.2")
    public final boolean isAvailableInEditorOnly() {
        return false;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.2")
    public final boolean isEnabledOnElements(PsiElement @NotNull [] elements2) {
        if (elements2 == null) {
            RenameElementAction.$$$reportNull$$$0(5);
        }
        return RenameElementAction.isRenameEnabledOnElements(elements2);
    }

    public static boolean isRenameEnabledOnElements(PsiElement @NotNull [] elements2) {
        if (elements2 == null) {
            RenameElementAction.$$$reportNull$$$0(6);
        }
        if (elements2.length != 1) {
            return false;
        }
        PsiElement element2 = elements2[0];
        return element2 instanceof PsiNamedElement && !(element2 instanceof SyntheticElement) && !PsiElementRenameHandler.isVetoed(element2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/actions/RenameElementAction";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/actions/RenameElementAction";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getAvailableRenamers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getAvailableRenamers";
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isEnabledOnElements";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isRenameEnabledOnElements";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

