/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.impl;

import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.impl.UnknownMissingSdk;
import com.intellij.openapi.projectRoots.impl.UnknownMissingSdkFix;
import com.intellij.openapi.projectRoots.impl.UnknownSdkDownloadTask;
import com.intellij.openapi.projectRoots.impl.UnknownSdkFixAction;
import com.intellij.openapi.projectRoots.impl.UnknownSdkFixActionDownloadBase;
import com.intellij.openapi.roots.ui.configuration.UnknownSdk;
import com.intellij.openapi.roots.ui.configuration.UnknownSdkDownloadableSdkFix;
import com.intellij.util.Consumer;
import com.intellij.util.EmptyConsumer;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

final class UnknownMissingSdkFixDownload
extends UnknownSdkFixActionDownloadBase
implements UnknownSdkFixAction {
    @NotNull
    private final UnknownSdkDownloadableSdkFix myFix;
    @NotNull
    private final UnknownSdk mySdk;

    UnknownMissingSdkFixDownload(@NotNull UnknownSdk sdk2, @NotNull UnknownSdkDownloadableSdkFix fix) {
        if (sdk2 == null) {
            UnknownMissingSdkFixDownload.$$$reportNull$$$0(0);
        }
        if (fix == null) {
            UnknownMissingSdkFixDownload.$$$reportNull$$$0(1);
        }
        this.myFix = fix;
        this.mySdk = sdk2;
    }

    @NotNull
    String getSdkNameForUi() {
        String string = UnknownMissingSdk.getSdkNameForUi(this.mySdk);
        if (string == null) {
            UnknownMissingSdkFixDownload.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    @NotNull
    @Nls
    public String getActionShortText() {
        String string = ProjectBundle.message((String)"action.text.config.unknown.sdk.download", (Object[])new Object[]{this.myFix.getDownloadDescription()});
        if (string == null) {
            UnknownMissingSdkFixDownload.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    @NotNull
    @Nls
    public String getActionDetailedText() {
        String sdkTypeName = this.mySdk.getSdkType().getPresentableName();
        String string = ProjectBundle.message((String)"label.text.download.for.missing.sdk", (Object[])new Object[]{this.myFix.getDownloadDescription(), sdkTypeName, this.getSdkNameForUi()});
        if (string == null) {
            UnknownMissingSdkFixDownload.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Override
    @NotNull
    protected UnknownSdkDownloadTask createTask() {
        return new UnknownSdkDownloadTask(this.mySdk, this.myFix, task2 -> UnknownMissingSdkFix.createNewSdk(this.mySdk, task2::getSuggestedSdkName), (Consumer<? super Sdk>)EmptyConsumer.getInstance(), (Consumer<? super Sdk>)((Consumer)sdk2 -> {
            if (sdk2 == null) {
                return;
            }
            this.myFix.configureSdk((Sdk)sdk2);
            UnknownMissingSdkFix.registerNewSdkInJdkTable(sdk2.getName(), sdk2);
        }));
    }

    public String toString() {
        return this.myFix.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fix";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/projectRoots/impl/UnknownMissingSdkFixDownload";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/projectRoots/impl/UnknownMissingSdkFixDownload";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSdkNameForUi";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionShortText";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionDetailedText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

