/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileTypes.impl.associate.linux;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.fileTypes.impl.associate.OSFileAssociationException;
import com.intellij.openapi.fileTypes.impl.associate.linux.LocalDesktopEntryCreator;
import com.intellij.openapi.fileTypes.impl.associate.linux.MimeTypeDescription;
import com.intellij.openapi.util.Key;
import com.intellij.util.PlatformUtils;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jetbrains.annotations.NotNull;

final class LinuxMimeTypeUpdater {
    private static final String LOCAL_MIME_DIR = ".local/share/mime";
    private static final String LOCAL_APP_DIR = ".local/share/applications";
    private static final String LOCAL_MIME_PACKAGES_PATH = ".local/share/mime/packages";
    private static final String EXTENSIONS_FILE_NAME = "jb-" + PlatformUtils.getPlatformPrefix() + "-extensions.xml";
    private static final String MIME_INFO_TAG = "mime-info";
    private static final String MIME_XMLNS = "http://www.freedesktop.org/standards/shared-mime-info";
    private static final String MIME_TYPE_TAG = "mime-type";
    private static final String MIME_TYPE_ATTR = "type";
    private static final String OS_MIME_UTIL = "xdg-mime";
    private static final String[] OS_MIME_UTIL_INSTALL_PARAMS = new String[]{"install", "--mode", "user", "--novendor", "$file"};
    private static final String[] OS_MIME_UTIL_DEFAULT_APP_PARAMS = new String[]{"default", "$desktop-entry"};
    private static final String OS_UPDATE_DESKTOP_DB_COMMAND = "update-desktop-database";

    private LinuxMimeTypeUpdater() {
    }

    static void updateMimeTypes(@NotNull List<MimeTypeDescription> mimeTypeDescriptions) throws OSFileAssociationException {
        if (mimeTypeDescriptions == null) {
            LinuxMimeTypeUpdater.$$$reportNull$$$0(0);
        }
        try {
            LinuxMimeTypeUpdater.createMimeFile(mimeTypeDescriptions);
            LinuxMimeTypeUpdater.runCommand(OS_MIME_UTIL, LinuxMimeTypeUpdater.makeParamList(OS_MIME_UTIL_INSTALL_PARAMS, System.getProperty("user.home") + File.separator + LOCAL_MIME_DIR));
            String desktopEntry = LocalDesktopEntryCreator.createDesktopEntry();
            List<String> defaultAppParams = LinuxMimeTypeUpdater.makeParamList(OS_MIME_UTIL_DEFAULT_APP_PARAMS, desktopEntry);
            defaultAppParams.addAll(ContainerUtil.map(mimeTypeDescriptions, description -> description.getType()));
            LinuxMimeTypeUpdater.runCommand(OS_MIME_UTIL, defaultAppParams);
            LinuxMimeTypeUpdater.runCommand(OS_UPDATE_DESKTOP_DB_COMMAND, Collections.singletonList(System.getProperty("user.home") + File.separator + LOCAL_APP_DIR));
        }
        catch (ExecutionException | IOException | XMLStreamException e) {
            throw new OSFileAssociationException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void createMimeFile(@NotNull List<MimeTypeDescription> mimeTypeDescriptions) throws IOException, XMLStreamException, OSFileAssociationException {
        if (mimeTypeDescriptions == null) {
            LinuxMimeTypeUpdater.$$$reportNull$$$0(1);
        }
        XMLOutputFactory outputFactory = XMLOutputFactory.newInstance();
        String mimePackagesPath = System.getProperty("user.home") + File.separator + LOCAL_MIME_PACKAGES_PATH;
        LinuxMimeTypeUpdater.ensureMimePackagesDirExists(mimePackagesPath);
        FileWriter fileWriter = new FileWriter(mimePackagesPath + File.separator + EXTENSIONS_FILE_NAME, StandardCharsets.UTF_8);
        XMLStreamWriter writer = outputFactory.createXMLStreamWriter(fileWriter);
        try {
            writer.writeStartDocument("UTF-8", "1.0");
            writer.writeCharacters("\n");
            writer.writeStartElement(MIME_INFO_TAG);
            writer.writeAttribute("xmlns", MIME_XMLNS);
            writer.writeCharacters("\n");
            for (MimeTypeDescription description : mimeTypeDescriptions) {
                LinuxMimeTypeUpdater.writeDescription(writer, description);
            }
            writer.writeEndElement();
            writer.writeEndDocument();
        }
        finally {
            writer.flush();
            writer.close();
        }
    }

    private static void ensureMimePackagesDirExists(@NotNull String mimePackagesPath) throws OSFileAssociationException {
        File packagesDir;
        if (mimePackagesPath == null) {
            LinuxMimeTypeUpdater.$$$reportNull$$$0(2);
        }
        if (!(packagesDir = new File(mimePackagesPath)).exists() && !packagesDir.mkdirs()) {
            throw new OSFileAssociationException(mimePackagesPath + " directory doesn't exist and can't be created.");
        }
    }

    private static void writeDescription(@NotNull XMLStreamWriter writer, @NotNull MimeTypeDescription description) throws XMLStreamException {
        if (writer == null) {
            LinuxMimeTypeUpdater.$$$reportNull$$$0(3);
        }
        if (description == null) {
            LinuxMimeTypeUpdater.$$$reportNull$$$0(4);
        }
        writer.writeCharacters("  ");
        writer.writeStartElement(MIME_TYPE_TAG);
        writer.writeAttribute(MIME_TYPE_ATTR, description.getType());
        writer.writeCharacters("\n");
        writer.writeCharacters("    ");
        writer.writeStartElement("comment");
        writer.writeCharacters(description.getComment());
        writer.writeEndElement();
        writer.writeCharacters("\n");
        for (String pattern : description.getGlobPatterns()) {
            writer.writeCharacters("    ");
            writer.writeStartElement("glob");
            writer.writeAttribute("pattern", pattern);
            writer.writeEndElement();
            writer.writeCharacters("\n");
        }
        writer.writeCharacters("  ");
        writer.writeEndElement();
        writer.writeCharacters("\n");
    }

    private static void runCommand(@NotNull String command, List<String> params) throws ExecutionException, OSFileAssociationException {
        if (command == null) {
            LinuxMimeTypeUpdater.$$$reportNull$$$0(5);
        }
        GeneralCommandLine commandLine = new GeneralCommandLine();
        commandLine.setExePath(command);
        for (String param : params) {
            commandLine.addParameter(param);
        }
        final StringBuilder errorMessage = new StringBuilder();
        OSProcessHandler mimeDatabaseUpdateHandler = new OSProcessHandler(commandLine);
        mimeDatabaseUpdateHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (outputType == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (ProcessOutputTypes.STDERR.equals((Object)outputType)) {
                    errorMessage.append(event.getText());
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "event";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "outputType";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/openapi/fileTypes/impl/associate/linux/LinuxMimeTypeUpdater$1";
                objectArray[2] = "onTextAvailable";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        mimeDatabaseUpdateHandler.startNotify();
        if (!mimeDatabaseUpdateHandler.waitFor(1000L)) {
            throw new OSFileAssociationException("Failed to run update-mime-database in 1 sec");
        }
        if (errorMessage.length() > 0) {
            throw new OSFileAssociationException("xdg-mime returned: " + errorMessage.toString());
        }
    }

    private static List<String> makeParamList(String[] args, String ... params) {
        ArrayList<String> result2 = new ArrayList<String>();
        int count = 0;
        for (String arg : args) {
            if (arg.startsWith("$")) {
                if (count >= params.length) {
                    throw new RuntimeException("Missing argument " + arg);
                }
                result2.add(params[count++]);
                continue;
            }
            result2.add(arg);
        }
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mimeTypeDescriptions";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mimePackagesPath";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "writer";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/fileTypes/impl/associate/linux/LinuxMimeTypeUpdater";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "updateMimeTypes";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "createMimeFile";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "ensureMimePackagesDirExists";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "writeDescription";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "runCommand";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

