/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notification.impl;

import com.intellij.ide.plugins.PluginManager;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.impl.NotificationCollector;
import com.intellij.notification.impl.NotificationGroupEP;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.PluginId;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public final class NotificationGroupManagerImpl
implements NotificationGroupManager {
    private static final Logger LOG = Logger.getInstance(NotificationGroupManagerImpl.class);
    private final Map<String, NotificationGroup> myRegisteredGroups;
    private final Set<String> myRegisteredNotificationIds = new HashSet<String>();

    public NotificationGroupManagerImpl() {
        this.myRegisteredGroups = new ConcurrentHashMap<String, NotificationGroup>(NotificationGroupEP.EP_NAME.getPoint().size());
        NotificationGroupEP.EP_NAME.processWithPluginDescriptor((extension, descriptor2) -> this.registerNotificationGroup((NotificationGroupEP)extension, (PluginDescriptor)descriptor2));
        NotificationGroupEP.EP_NAME.addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<NotificationGroupEP>(){

            public void extensionAdded(@NotNull NotificationGroupEP extension, @NotNull PluginDescriptor pluginDescriptor) {
                if (extension == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (pluginDescriptor == null) {
                    1.$$$reportNull$$$0(1);
                }
                NotificationGroupManagerImpl.this.registerNotificationGroup(extension, pluginDescriptor);
            }

            public void extensionRemoved(@NotNull NotificationGroupEP extension, @NotNull PluginDescriptor pluginDescriptor) {
                NotificationGroup group2;
                if (extension == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (pluginDescriptor == null) {
                    1.$$$reportNull$$$0(3);
                }
                if (Objects.equals((group2 = NotificationGroupManagerImpl.this.myRegisteredGroups.get(extension.id)).getPluginId(), pluginDescriptor.getPluginId())) {
                    NotificationGroupManagerImpl.this.myRegisteredGroups.remove(extension.id);
                }
                NotificationGroupManagerImpl.this.myRegisteredNotificationIds.removeAll(NotificationCollector.parseIds(extension.notificationIds));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "extension";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "pluginDescriptor";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/notification/impl/NotificationGroupManagerImpl$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionAdded";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionRemoved";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, null);
    }

    private void registerNotificationGroup(@NotNull NotificationGroupEP extension, @NotNull PluginDescriptor pluginDescriptor) {
        if (extension == null) {
            NotificationGroupManagerImpl.$$$reportNull$$$0(0);
        }
        if (pluginDescriptor == null) {
            NotificationGroupManagerImpl.$$$reportNull$$$0(1);
        }
        try {
            String groupId2 = extension.id;
            NotificationDisplayType type = extension.getDisplayType();
            if (type == null) {
                LOG.warn("Cannot create notification group \"" + groupId2 + "`\": displayType should be not null");
                return;
            }
            NotificationGroup notificationGroup = NotificationGroup.create((String)groupId2, (NotificationDisplayType)type, (boolean)extension.isLogByDefault, (String)extension.toolWindowId, (Icon)extension.getIcon(), (String)extension.getDisplayName(), (PluginId)pluginDescriptor.getPluginId());
            NotificationGroup old = this.myRegisteredGroups.put(groupId2, notificationGroup);
            if (old != null) {
                LOG.warn("Notification group " + groupId2 + " is already registered (group=" + old + "). Plugin descriptor: " + pluginDescriptor);
            }
            if (PluginManager.getInstance().isDevelopedByJetBrains(pluginDescriptor)) {
                this.myRegisteredNotificationIds.addAll(NotificationCollector.parseIds(extension.notificationIds));
            }
        }
        catch (Exception e) {
            LOG.warn("Cannot create notification group: " + extension, (Throwable)e);
        }
    }

    public NotificationGroup getNotificationGroup(@NotNull String groupId2) {
        if (groupId2 == null) {
            NotificationGroupManagerImpl.$$$reportNull$$$0(2);
        }
        return this.myRegisteredGroups.get(groupId2);
    }

    @NotNull
    public Collection<NotificationGroup> getRegisteredNotificationGroups() {
        Collection<NotificationGroup> collection = this.myRegisteredGroups.values();
        if (collection == null) {
            NotificationGroupManagerImpl.$$$reportNull$$$0(3);
        }
        return collection;
    }

    public boolean isRegisteredNotificationId(@NotNull String notificationId) {
        if (notificationId == null) {
            NotificationGroupManagerImpl.$$$reportNull$$$0(4);
        }
        return this.myRegisteredNotificationIds.contains(notificationId);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginDescriptor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupId";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/notification/impl/NotificationGroupManagerImpl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notificationId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/notification/impl/NotificationGroupManagerImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRegisteredNotificationGroups";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "registerNotificationGroup";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getNotificationGroup";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isRegisteredNotificationId";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

