/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl.nodes;

import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.ide.bookmarks.Bookmark;
import com.intellij.ide.bookmarks.BookmarkManager;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.ProjectViewSettings;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.CompoundProjectViewNodeDecorator;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.ValidateableNode;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.StatePreservingNavigatable;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.IconManager;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.icons.RowIcon;
import com.intellij.util.AstLoadingFilter;
import com.intellij.util.PlatformIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractPsiBasedNode<Value>
extends ProjectViewNode<Value>
implements ValidateableNode,
StatePreservingNavigatable {
    private static final Logger LOG = Logger.getInstance((String)AbstractPsiBasedNode.class.getName());

    protected AbstractPsiBasedNode(Project project, @NotNull Value value2, ViewSettings viewSettings) {
        if (value2 == null) {
            AbstractPsiBasedNode.$$$reportNull$$$0(0);
        }
        super(project, value2, viewSettings);
    }

    @Nullable
    protected abstract PsiElement extractPsiFromValue();

    @Nullable
    protected abstract Collection<AbstractTreeNode<?>> getChildrenImpl();

    protected abstract void updateImpl(@NotNull PresentationData var1);

    @NotNull
    public final Collection<? extends AbstractTreeNode<?>> getChildren() {
        Collection collection = (Collection)AstLoadingFilter.disallowTreeLoading(this::doGetChildren);
        if (collection == null) {
            AbstractPsiBasedNode.$$$reportNull$$$0(1);
        }
        return collection;
    }

    @NotNull
    private Collection<? extends AbstractTreeNode<?>> doGetChildren() {
        PsiElement psiElement = this.extractPsiFromValue();
        if (psiElement == null) {
            return new ArrayList();
        }
        if (!psiElement.isValid()) {
            LOG.error((Throwable)new IllegalStateException("Node contains invalid PSI: \n" + ((Object)((Object)this)).getClass() + " [" + this + "]\n" + psiElement.getClass() + " [" + psiElement + "]"));
            List list2 = Collections.emptyList();
            if (list2 == null) {
                AbstractPsiBasedNode.$$$reportNull$$$0(2);
            }
            return list2;
        }
        Collection<AbstractTreeNode<?>> children2 = this.getChildrenImpl();
        Collection<Object> collection = children2 != null ? children2 : Collections.emptyList();
        if (collection == null) {
            AbstractPsiBasedNode.$$$reportNull$$$0(3);
        }
        return collection;
    }

    public boolean isValid() {
        PsiElement psiElement = this.extractPsiFromValue();
        return psiElement != null && psiElement.isValid();
    }

    protected boolean isMarkReadOnly() {
        AbstractTreeNode parent = this.getParent();
        if (parent == null) {
            return false;
        }
        if (parent instanceof AbstractPsiBasedNode) {
            PsiElement psiElement = ((AbstractPsiBasedNode)parent).extractPsiFromValue();
            return psiElement instanceof PsiDirectory;
        }
        Object parentValue = parent.getValue();
        return parentValue instanceof PsiDirectory || parentValue instanceof Module;
    }

    public FileStatus getFileStatus() {
        return AbstractPsiBasedNode.computeFileStatus(this.getVirtualFileForValue(), Objects.requireNonNull(this.getProject()));
    }

    protected static FileStatus computeFileStatus(@Nullable VirtualFile virtualFile, @NotNull Project project) {
        if (project == null) {
            AbstractPsiBasedNode.$$$reportNull$$$0(4);
        }
        if (virtualFile == null) {
            return FileStatus.NOT_CHANGED;
        }
        return FileStatusManager.getInstance((Project)project).getStatus(virtualFile);
    }

    @Nullable
    private VirtualFile getVirtualFileForValue() {
        PsiElement psiElement = this.extractPsiFromValue();
        if (psiElement == null) {
            return null;
        }
        return PsiUtilCore.getVirtualFile((PsiElement)psiElement);
    }

    public void update(@NotNull PresentationData data2) {
        if (data2 == null) {
            AbstractPsiBasedNode.$$$reportNull$$$0(5);
        }
        AstLoadingFilter.disallowTreeLoading(() -> this.doUpdate(data2));
    }

    private void doUpdate(@NotNull PresentationData data2) {
        if (data2 == null) {
            AbstractPsiBasedNode.$$$reportNull$$$0(6);
        }
        ApplicationManager.getApplication().runReadAction(() -> {
            if (!this.validate()) {
                return;
            }
            PsiElement value2 = this.extractPsiFromValue();
            LOG.assertTrue(value2.isValid());
            int flags = this.getIconableFlags();
            try {
                Icon icon2 = value2.getIcon(flags);
                data2.setIcon(icon2);
            }
            catch (IndexNotReadyException indexNotReadyException) {
                // empty catch block
            }
            data2.setPresentableText(this.myName);
            try {
                if (this.isDeprecated()) {
                    data2.setAttributesKey(CodeInsightColors.DEPRECATED_ATTRIBUTES);
                }
            }
            catch (IndexNotReadyException indexNotReadyException) {
                // empty catch block
            }
            this.updateImpl(data2);
            data2.setIcon(AbstractPsiBasedNode.patchIcon(this.myProject, data2.getIcon(true), this.getVirtualFile()));
            CompoundProjectViewNodeDecorator.get(this.myProject).decorate(this, data2);
        });
    }

    @Iconable.IconFlags
    protected int getIconableFlags() {
        int flags = 0;
        ViewSettings settings = this.getSettings();
        if (settings instanceof ProjectViewSettings && ((ProjectViewSettings)settings).isShowVisibilityIcons()) {
            flags |= 1;
        }
        if (this.isMarkReadOnly()) {
            flags |= 2;
        }
        return flags;
    }

    @Nullable
    public static Icon patchIcon(@NotNull Project project, @Nullable Icon original, @Nullable VirtualFile file2) {
        if (project == null) {
            AbstractPsiBasedNode.$$$reportNull$$$0(7);
        }
        if (file2 == null || original == null) {
            return original;
        }
        Icon icon2 = original;
        Bookmark bookmarkAtFile = BookmarkManager.getInstance(project).findFileBookmark(file2);
        if (bookmarkAtFile != null) {
            RowIcon composite = IconManager.getInstance().createRowIcon(2, RowIcon.Alignment.CENTER);
            composite.setIcon(icon2, 0);
            composite.setIcon(bookmarkAtFile.getIcon(), 1);
            icon2 = composite;
        }
        if (file2.is(VFileProperty.SYMLINK)) {
            icon2 = LayeredIcon.create((Icon)icon2, (Icon)PlatformIcons.SYMLINK_ICON);
        }
        return icon2;
    }

    protected boolean isDeprecated() {
        return false;
    }

    public boolean contains(@NotNull VirtualFile file2) {
        PsiElement psiElement;
        if (file2 == null) {
            AbstractPsiBasedNode.$$$reportNull$$$0(8);
        }
        if ((psiElement = this.extractPsiFromValue()) == null || !psiElement.isValid()) {
            return false;
        }
        PsiFile containingFile = psiElement.getContainingFile();
        if (containingFile == null) {
            return false;
        }
        VirtualFile valueFile = containingFile.getVirtualFile();
        return file2.equals(valueFile);
    }

    @Nullable
    public NavigationItem getNavigationItem() {
        PsiElement psiElement = this.extractPsiFromValue();
        return psiElement instanceof NavigationItem ? (NavigationItem)psiElement : null;
    }

    public void navigate(boolean requestFocus, boolean preserveState) {
        if (this.canNavigate()) {
            if (requestFocus || preserveState) {
                NavigationUtil.openFileWithPsiElement(this.extractPsiFromValue(), requestFocus, requestFocus);
            } else {
                this.getNavigationItem().navigate(false);
            }
        }
    }

    public void navigate(boolean requestFocus) {
        this.navigate(requestFocus, false);
    }

    public boolean canNavigate() {
        NavigationItem item = this.getNavigationItem();
        return item != null && item.canNavigate();
    }

    public boolean canNavigateToSource() {
        NavigationItem item = this.getNavigationItem();
        return item != null && item.canNavigateToSource();
    }

    @Nullable
    protected String calcTooltip() {
        return null;
    }

    public boolean validate() {
        PsiElement psiElement = this.extractPsiFromValue();
        if (psiElement == null || !psiElement.isValid()) {
            this.setValue(null);
        }
        return this.getValue() != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/projectView/impl/nodes/AbstractPsiBasedNode";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/projectView/impl/nodes/AbstractPsiBasedNode";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "doGetChildren";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "computeFileStatus";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "doUpdate";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "patchIcon";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

