/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.actions.ToolwindowFusEventFields;
import com.intellij.idea.ActionsBundle;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.impl.FusAwareAction;
import com.intellij.openapi.project.DumbAwareToggleAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ToolWindowType;
import com.intellij.openapi.wm.WindowInfo;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ToolWindowViewModeAction
extends DumbAwareToggleAction
implements FusAwareAction {
    @NotNull
    protected final ViewMode myMode;

    protected ToolWindowViewModeAction(@NotNull ViewMode mode) {
        if (mode == null) {
            ToolWindowViewModeAction.$$$reportNull$$$0(0);
        }
        this.myMode = mode;
        this.getTemplatePresentation().setText(ActionsBundle.actionText((String)this.myMode.myActionID));
        this.getTemplatePresentation().setDescription(ActionsBundle.actionDescription((String)this.myMode.myActionID));
    }

    @Nullable
    protected ToolWindowManager getToolWindowManager(AnActionEvent e) {
        Project project = e.getProject();
        return project == null || project.isDisposed() ? null : ToolWindowManager.getInstance((Project)project);
    }

    @Nullable
    protected ToolWindow getToolWindow(AnActionEvent e) {
        ToolWindowManager manager = this.getToolWindowManager(e);
        if (manager == null) {
            return null;
        }
        ToolWindow window = (ToolWindow)e.getData(PlatformDataKeys.TOOL_WINDOW);
        if (window != null) {
            return window;
        }
        String id2 = manager.getActiveToolWindowId();
        return id2 == null ? null : manager.getToolWindow(id2);
    }

    public final boolean isSelected(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            ToolWindowViewModeAction.$$$reportNull$$$0(1);
        }
        if ((project = e.getProject()) == null || project.isDisposed()) {
            return false;
        }
        ToolWindow window = this.getToolWindow(e);
        return window != null && this.isSelected(window);
    }

    protected boolean isSelected(@NotNull ToolWindow window) {
        if (window == null) {
            ToolWindowViewModeAction.$$$reportNull$$$0(2);
        }
        return this.myMode.isApplied(window);
    }

    public void setSelected(@NotNull AnActionEvent e, boolean state) {
        ToolWindow window;
        if (e == null) {
            ToolWindowViewModeAction.$$$reportNull$$$0(3);
        }
        if ((window = this.getToolWindow(e)) == null) {
            return;
        }
        if (!this.myMode.isApplied(window)) {
            this.myMode.applyTo(window);
        }
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            ToolWindowViewModeAction.$$$reportNull$$$0(4);
        }
        super.update(e);
        e.getPresentation().setEnabled(this.getToolWindow(e) != null);
    }

    @Override
    @NotNull
    public List<EventPair<?>> getAdditionalUsageData(@NotNull AnActionEvent event) {
        ToolWindow toolWindow;
        if (event == null) {
            ToolWindowViewModeAction.$$$reportNull$$$0(5);
        }
        if ((toolWindow = this.getToolWindow(event)) != null) {
            List<EventPair<?>> list2 = Collections.singletonList(ToolwindowFusEventFields.TOOLWINDOW.with((Object)toolWindow.getId()));
            if (list2 == null) {
                ToolWindowViewModeAction.$$$reportNull$$$0(6);
            }
            return list2;
        }
        List<EventPair<?>> list3 = Collections.emptyList();
        if (list3 == null) {
            ToolWindowViewModeAction.$$$reportNull$$$0(7);
        }
        return list3;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mode";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "window";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/actions/ToolWindowViewModeAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/actions/ToolWindowViewModeAction";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalUsageData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isSelected";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setSelected";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getAdditionalUsageData";
                break;
            }
            case 6: 
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Group
    extends DefaultActionGroup {
        private boolean isInitialized = false;

        public boolean isDumbAware() {
            return true;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                Group.$$$reportNull$$$0(0);
            }
            if (!this.isInitialized) {
                ActionManager actionManager = ActionManager.getInstance();
                for (ViewMode viewMode : ViewMode.values()) {
                    ToolWindowViewModeAction action2 = new ToolWindowViewModeAction(viewMode);
                    AnAction template = actionManager.getAction(viewMode.getActionID());
                    if (template != null) {
                        action2.copyShortcutFrom(template);
                    }
                    this.add((AnAction)action2);
                }
                this.isInitialized = true;
            }
            super.update(e);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/actions/ToolWindowViewModeAction$Group", "update"));
        }
    }

    public static enum ViewMode {
        DockPinned("DockPinnedMode"),
        DockUnpinned("DockUnpinnedMode"),
        Undock("UndockMode"),
        Float("FloatMode"),
        Window("WindowMode");

        private final String myActionID;

        private ViewMode(String actionID) {
            this.myActionID = actionID;
        }

        public String getActionID() {
            return this.myActionID;
        }

        boolean isApplied(@NotNull ToolWindow window) {
            if (window == null) {
                ViewMode.$$$reportNull$$$0(0);
            }
            ToolWindowType type = window.getType();
            switch (this) {
                case DockPinned: {
                    return type == ToolWindowType.DOCKED && !window.isAutoHide();
                }
                case DockUnpinned: {
                    return type == ToolWindowType.DOCKED && window.isAutoHide();
                }
                case Undock: {
                    return type == ToolWindowType.SLIDING;
                }
                case Float: {
                    return type == ToolWindowType.FLOATING;
                }
                case Window: {
                    return type == ToolWindowType.WINDOWED;
                }
            }
            return false;
        }

        public static ViewMode fromWindowInfo(@NotNull WindowInfo info) {
            if (info == null) {
                ViewMode.$$$reportNull$$$0(1);
            }
            switch (info.getType()) {
                case DOCKED: {
                    return info.isAutoHide() ? DockUnpinned : DockPinned;
                }
                case FLOATING: {
                    return Float;
                }
                case SLIDING: {
                    return Undock;
                }
                case WINDOWED: {
                    return Window;
                }
            }
            return DockPinned;
        }

        void applyTo(@NotNull ToolWindow window) {
            if (window == null) {
                ViewMode.$$$reportNull$$$0(2);
            }
            switch (this) {
                case DockPinned: {
                    window.setType(ToolWindowType.DOCKED, null);
                    window.setAutoHide(false);
                    return;
                }
                case DockUnpinned: {
                    window.setType(ToolWindowType.DOCKED, null);
                    window.setAutoHide(true);
                    return;
                }
                case Undock: {
                    window.setType(ToolWindowType.SLIDING, null);
                    return;
                }
                case Float: {
                    window.setType(ToolWindowType.FLOATING, null);
                    return;
                }
                case Window: {
                    window.setType(ToolWindowType.WINDOWED, null);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "window";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "info";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ide/actions/ToolWindowViewModeAction$ViewMode";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isApplied";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fromWindowInfo";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "applyTo";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

