/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.ide.MyIcon;
import com.intellij.ide.RecentProjectIconHelperKt;
import com.intellij.ide.RecentProjectsManagerBase;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.Pair;
import com.intellij.ui.IconDeferrer;
import com.intellij.util.ImageLoader;
import com.intellij.util.io.PathKt;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.HashMap;
import java.util.function.Function;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.imgscalr.Scalr;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0000\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001f\u0010\b\u001a\u0004\u0018\u00010\t2\u000b\u0010\n\u001a\u00070\u0005\u00a2\u0006\u0002\b\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u001b\u0010\u000e\u001a\u00020\t2\u000b\u0010\n\u001a\u00070\u0005\u00a2\u0006\u0002\b\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0013\u0010\u000f\u001a\u00020\t2\u000b\u0010\n\u001a\u00070\u0005\u00a2\u0006\u0002\b\u000bR*\u0010\u0003\u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004j\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/ide/RecentProjectIconHelper;", "", "()V", "projectIcons", "Ljava/util/HashMap;", "", "Lcom/intellij/ide/MyIcon;", "Lkotlin/collections/HashMap;", "calculateIcon", "Ljavax/swing/Icon;", "path", "Lorg/jetbrains/annotations/SystemIndependent;", "isDark", "", "getProjectIcon", "getProjectOrAppIcon", "Companion", "intellij.platform.ide.impl"})
public final class RecentProjectIconHelper {
    private final HashMap<String, MyIcon> projectIcons = new HashMap();
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final Icon getProjectIcon(@NotNull String path, boolean isDark) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        MyIcon icon2 = this.projectIcons.get(path);
        if (icon2 != null) {
            return icon2.getIcon();
        }
        if (!RecentProjectsManagerBase.Companion.isFileSystemPath(path)) {
            Icon icon3 = EmptyIcon.ICON_16;
            Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"EmptyIcon.ICON_16");
            return icon3;
        }
        Icon icon4 = IconDeferrer.getInstance().defer(EmptyIcon.ICON_16, (Object)new Pair((Object)path, (Object)isDark), (Function)new Function<Pair<String, Boolean>, Icon>(this){
            final /* synthetic */ RecentProjectIconHelper this$0;

            public final Icon apply(Pair<String, Boolean> it) {
                Object object = it.first;
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"it.first");
                String string = (String)object;
                Object object2 = it.second;
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"it.second");
                return RecentProjectIconHelper.access$calculateIcon(this.this$0, string, (Boolean)object2);
            }
            {
                this.this$0 = recentProjectIconHelper;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)icon4, (String)"IconDeferrer.getInstance\u2026t.first, it.second)\n    }");
        return icon4;
    }

    @NotNull
    public final Icon getProjectOrAppIcon(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return this.getProjectIcon(path, StartupUiUtil.isUnderDarcula());
    }

    private final Icon calculateIcon(String path, boolean isDark) {
        Path file2 = Paths.get(path, ".idea", isDark ? "icon_dark.png" : "icon.png");
        boolean recolor = false;
        if (isDark) {
            Path path2 = file2;
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"file");
            if (!PathKt.exists((Path)path2)) {
                file2 = Paths.get(path, ".idea", "icon.png");
                recolor = true;
            }
        }
        Path path3 = file2;
        Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"file");
        BasicFileAttributes basicFileAttributes = PathKt.basicAttributesIfExists((Path)path3);
        if (basicFileAttributes == null) {
            return null;
        }
        BasicFileAttributes fileInfo = basicFileAttributes;
        long timestamp = fileInfo.lastModifiedTime().toMillis();
        MyIcon iconWrapper = this.projectIcons.get(path);
        if (iconWrapper != null) {
            Long l = iconWrapper.getTimestamp();
            if (l != null && l == timestamp) {
                return iconWrapper.getIcon();
            }
        }
        try {
            Icon icon2 = Companion.createIcon(file2);
            if (icon2 == null) {
                return null;
            }
            Icon icon3 = icon2;
            if (recolor) {
                Icon icon4 = IconLoader.getDarkIcon((Icon)icon3, (boolean)true);
                Intrinsics.checkNotNullExpressionValue((Object)icon4, (String)"IconLoader.getDarkIcon(icon, true)");
                icon3 = icon4;
            }
            iconWrapper = new MyIcon(icon3, timestamp);
            this.projectIcons.put(path, iconWrapper);
            return iconWrapper.getIcon();
        }
        catch (Exception e) {
            RecentProjectIconHelperKt.access$getLOG$p().error((Throwable)e);
            return null;
        }
    }

    public static final /* synthetic */ Icon access$calculateIcon(RecentProjectIconHelper $this, String path, boolean isDark) {
        return $this.calculateIcon(path, isDark);
    }

    @JvmStatic
    @Nullable
    public static final Icon createIcon(@NotNull Path file2) {
        return Companion.createIcon(file2);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Lcom/intellij/ide/RecentProjectIconHelper$Companion;", "", "()V", "createIcon", "Ljavax/swing/Icon;", "file", "Ljava/nio/file/Path;", "intellij.platform.ide.impl"})
    public static final class Companion {
        @JvmStatic
        @Nullable
        public final Icon createIcon(@NotNull Path file2) {
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            try {
                Image image = ImageLoader.loadFromUrl((URL)file2.toUri().toURL());
                if (image == null) {
                    return null;
                }
                Intrinsics.checkNotNullExpressionValue((Object)image, (String)"ImageLoader.loadFromUrl(\u2026).toURL()) ?: return null");
                Image image2 = image;
                int targetSize = UIUtil.isRetina() ? 32 : (int)JBUI.pixScale((float)16.0f);
                BufferedImage bufferedImage = Scalr.resize((BufferedImage)ImageUtil.toBufferedImage((Image)image2), (Scalr.Method)Scalr.Method.ULTRA_QUALITY, (int)targetSize, (BufferedImageOp[])new BufferedImageOp[0]);
                Intrinsics.checkNotNullExpressionValue((Object)bufferedImage, (String)"Scalr.resize(ImageUtil.t\u2026LTRA_QUALITY, targetSize)");
                return RecentProjectIconHelperKt.access$toRetinaAwareIcon(bufferedImage);
            }
            catch (MalformedURLException e) {
                RecentProjectIconHelperKt.access$getLOG$p().debug((Throwable)e);
                return null;
            }
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

