/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.extapi.psi;

import com.intellij.extapi.psi.ASTDelegatePsiElement;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.RuntimeExceptionWithAttachments;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectCoreUtil;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.SubstrateRef;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.RecursiveTreeElementWalkingVisitor;
import com.intellij.psi.impl.source.tree.SharedImplUtil;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.ObjectStubBase;
import com.intellij.psi.stubs.PsiFileStub;
import com.intellij.psi.stubs.PsiFileStubImpl;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubTree;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayFactory;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StubBasedPsiElementBase<T extends StubElement>
extends ASTDelegatePsiElement {
    public static final Key<String> CREATION_TRACE = Key.create((String)"CREATION_TRACE");
    public static final boolean ourTraceStubAstBinding = "true".equals(System.getProperty("trace.stub.ast.binding", "false"));
    private volatile SubstrateRef mySubstrateRef;
    private final IElementType myElementType;

    public StubBasedPsiElementBase(@NotNull T stub, @NotNull IStubElementType nodeType) {
        if (stub == null) {
            StubBasedPsiElementBase.$$$reportNull$$$0(0);
        }
        if (nodeType == null) {
            StubBasedPsiElementBase.$$$reportNull$$$0(1);
        }
        this.mySubstrateRef = new SubstrateRef.StubRef((StubElement)stub);
        this.myElementType = nodeType;
    }

    public StubBasedPsiElementBase(@NotNull ASTNode node) {
        if (node == null) {
            StubBasedPsiElementBase.$$$reportNull$$$0(2);
        }
        this.mySubstrateRef = SubstrateRef.createAstStrongRef(node);
        this.myElementType = node.getElementType();
    }

    public StubBasedPsiElementBase(T stub, IElementType nodeType, ASTNode node) {
        if (stub != null) {
            if (nodeType == null) {
                throw new IllegalArgumentException("null cannot be passed to 'nodeType' when 'stub' is non-null");
            }
            if (node != null) {
                throw new IllegalArgumentException("null must be passed to 'node' parameter when 'stub' is non-null");
            }
            this.mySubstrateRef = new SubstrateRef.StubRef((StubElement)stub);
            this.myElementType = nodeType;
        } else {
            if (node == null) {
                throw new IllegalArgumentException("'stub' and 'node' parameters cannot be null both");
            }
            if (nodeType != null) {
                throw new IllegalArgumentException("null must be passed to 'nodeType' parameter when 'node' is non-null");
            }
            this.mySubstrateRef = SubstrateRef.createAstStrongRef(node);
            this.myElementType = node.getElementType();
        }
    }

    @Override
    @NotNull
    public ASTNode getNode() {
        if (this.mySubstrateRef instanceof SubstrateRef.StubRef) {
            ApplicationManager.getApplication().assertReadAccessAllowed();
            PsiFileImpl file2 = (PsiFileImpl)this.getContainingFile();
            if (!file2.isValid()) {
                throw new PsiInvalidElementAccessException((PsiElement)file2);
            }
            FileElement treeElement = file2.getTreeElement();
            if (treeElement != null && this.mySubstrateRef instanceof SubstrateRef.StubRef) {
                ASTNode aSTNode = this.notBoundInExistingAst(file2, treeElement);
                if (aSTNode == null) {
                    StubBasedPsiElementBase.$$$reportNull$$$0(3);
                }
                return aSTNode;
            }
            treeElement = file2.calcTreeElement();
            if (this.mySubstrateRef instanceof SubstrateRef.StubRef) {
                ASTNode aSTNode = this.failedToBindStubToAst(file2, treeElement);
                if (aSTNode == null) {
                    StubBasedPsiElementBase.$$$reportNull$$$0(4);
                }
                return aSTNode;
            }
        }
        ASTNode aSTNode = this.mySubstrateRef.getNode();
        if (aSTNode == null) {
            StubBasedPsiElementBase.$$$reportNull$$$0(5);
        }
        return aSTNode;
    }

    private ASTNode failedToBindStubToAst(@NotNull PsiFileImpl file2, @NotNull FileElement fileElement) {
        if (file2 == null) {
            StubBasedPsiElementBase.$$$reportNull$$$0(6);
        }
        if (fileElement == null) {
            StubBasedPsiElementBase.$$$reportNull$$$0(7);
        }
        VirtualFile vFile = file2.getVirtualFile();
        StubTree stubTree = file2.getStubTree();
        String stubString = stubTree != null ? ((PsiFileStubImpl)stubTree.getRoot()).printTree() : null;
        String astString = (String)RecursionManager.doPreventingRecursion((Object)"failedToBindStubToAst", (boolean)true, () -> DebugUtil.treeToString(fileElement, true));
        @NonNls String message = "Failed to bind stub to AST for element " + this.getClass() + " in " + (vFile == null ? "<unknown file>" : vFile.getPath()) + "\nFile:\n" + file2 + "@" + System.identityHashCode(file2);
        String creationTraces = ourTraceStubAstBinding ? this.dumpCreationTraces(fileElement) : null;
        ArrayList<Attachment> attachments = new ArrayList<Attachment>();
        if (stubString != null) {
            attachments.add(new Attachment("stubTree.txt", stubString));
        }
        if (astString != null) {
            attachments.add(new Attachment("ast.txt", astString));
        }
        if (creationTraces != null) {
            attachments.add(new Attachment("creationTraces.txt", creationTraces));
        }
        throw new RuntimeExceptionWithAttachments(message, attachments.toArray(Attachment.EMPTY_ARRAY));
    }

    @NotNull
    private String dumpCreationTraces(@NotNull FileElement fileElement) {
        if (fileElement == null) {
            StubBasedPsiElementBase.$$$reportNull$$$0(8);
        }
        final @NonNls StringBuilder traces = new StringBuilder("\nNow " + Thread.currentThread() + "\n");
        traces.append("My creation trace:\n").append((String)this.getUserData(CREATION_TRACE));
        traces.append("AST creation traces:\n");
        fileElement.acceptTree(new RecursiveTreeElementWalkingVisitor(false){

            @Override
            public void visitComposite(CompositeElement composite) {
                PsiElement psi = composite.getPsi();
                if (psi != null) {
                    traces.append(psi).append("@").append(System.identityHashCode(psi)).append("\n");
                    String trace = (String)psi.getUserData(CREATION_TRACE);
                    if (trace != null) {
                        traces.append(trace).append("\n");
                    }
                }
                super.visitComposite(composite);
            }
        });
        String string = traces.toString();
        if (string == null) {
            StubBasedPsiElementBase.$$$reportNull$$$0(9);
        }
        return string;
    }

    private ASTNode notBoundInExistingAst(@NotNull PsiFileImpl file2, @NotNull FileElement treeElement) {
        if (file2 == null) {
            StubBasedPsiElementBase.$$$reportNull$$$0(10);
        }
        if (treeElement == null) {
            StubBasedPsiElementBase.$$$reportNull$$$0(11);
        }
        @NonNls String message = "file=" + file2 + "; tree=" + treeElement;
        for (StubBasedPsiElementBase each = this; each != null; each = each.getParentByStub()) {
            message = message + "\n each of class " + each.getClass() + "; valid=" + each.isValid();
            if (each instanceof StubBasedPsiElementBase) {
                message = message + "; ref=" + each.mySubstrateRef;
                continue;
            }
            if (!(each instanceof PsiFile)) break;
            message = message + "; same file=" + (each == file2) + "; current tree= " + file2.getTreeElement() + "; stubTree=" + file2.getStubTree() + "; physical=" + file2.isPhysical();
            break;
        }
        for (Object eachStub = this.getStub(); eachStub != null; eachStub = eachStub.getParentStub()) {
            message = message + "\n each stub " + (eachStub instanceof PsiFileStubImpl ? ((PsiFileStubImpl)((Object)eachStub)).getDiagnostics() : eachStub);
        }
        if (ourTraceStubAstBinding) {
            message = message + this.dumpCreationTraces(treeElement);
        }
        throw new AssertionError((Object)message);
    }

    public final void setNode(@NotNull ASTNode node) {
        if (node == null) {
            StubBasedPsiElementBase.$$$reportNull$$$0(12);
        }
        this.setSubstrateRef(SubstrateRef.createAstStrongRef(node));
    }

    public final void setSubstrateRef(@NotNull SubstrateRef substrateRef) {
        if (substrateRef == null) {
            StubBasedPsiElementBase.$$$reportNull$$$0(13);
        }
        this.mySubstrateRef = substrateRef;
    }

    @Override
    @NotNull
    public Language getLanguage() {
        Language language = this.myElementType.getLanguage();
        if (language == null) {
            StubBasedPsiElementBase.$$$reportNull$$$0(14);
        }
        return language;
    }

    @Override
    @NotNull
    public PsiFile getContainingFile() {
        PsiFile psiFile;
        try {
            psiFile = this.mySubstrateRef.getContainingFile();
        }
        catch (PsiInvalidElementAccessException e) {
            if (PsiInvalidElementAccessException.getInvalidationTrace((UserDataHolder)this) != null) {
                throw new PsiInvalidElementAccessException((PsiElement)this, (Throwable)e);
            }
            throw e;
        }
        if (psiFile == null) {
            StubBasedPsiElementBase.$$$reportNull$$$0(15);
        }
        return psiFile;
    }

    @Override
    public boolean isWritable() {
        return this.getContainingFile().isWritable();
    }

    @Override
    public boolean isValid() {
        ProgressManager.checkCanceled();
        return this.mySubstrateRef.isValid();
    }

    @Override
    public PsiManagerEx getManager() {
        Project project = ProjectCoreUtil.theOnlyOpenProject();
        if (project != null) {
            return PsiManagerEx.getInstanceEx(project);
        }
        return (PsiManagerEx)this.getContainingFile().getManager();
    }

    @Override
    @NotNull
    public Project getProject() {
        Project project = ProjectCoreUtil.theOnlyOpenProject();
        if (project != null) {
            Project project2 = project;
            if (project2 == null) {
                StubBasedPsiElementBase.$$$reportNull$$$0(16);
            }
            return project2;
        }
        Project project3 = this.getContainingFile().getProject();
        if (project3 == null) {
            StubBasedPsiElementBase.$$$reportNull$$$0(17);
        }
        return project3;
    }

    @Override
    public boolean isPhysical() {
        return this.getContainingFile().isPhysical();
    }

    @Override
    public PsiElement getContext() {
        T stub = this.getStub();
        if (stub != null && !(stub instanceof PsiFileStub)) {
            return stub.getParentStub().getPsi();
        }
        return super.getContext();
    }

    protected final PsiElement getParentByStub() {
        T stub = this.getStub();
        if (stub != null) {
            return stub.getParentStub().getPsi();
        }
        return SharedImplUtil.getParent(this.getNode());
    }

    @Deprecated
    protected final PsiElement getParentByTree() {
        return SharedImplUtil.getParent(this.getNode());
    }

    public PsiElement getParent() {
        T stub = this.getGreenStub();
        if (stub != null && !((ObjectStubBase)stub).isDangling()) {
            return stub.getParentStub().getPsi();
        }
        return SourceTreeToPsiMap.treeElementToPsi(this.getNode().getTreeParent());
    }

    @NotNull
    public IStubElementType getElementType() {
        if (!(this.myElementType instanceof IStubElementType)) {
            throw new ClassCastException("Not a stub type: " + this.myElementType + " in " + this.getClass());
        }
        IStubElementType iStubElementType = (IStubElementType)this.myElementType;
        if (iStubElementType == null) {
            StubBasedPsiElementBase.$$$reportNull$$$0(18);
        }
        return iStubElementType;
    }

    @Nullable
    public T getStub() {
        ProgressIndicatorProvider.checkCanceled();
        return (T)((StubElement)this.mySubstrateRef.getStub());
    }

    @Nullable
    public final T getGreenStub() {
        ProgressIndicatorProvider.checkCanceled();
        return (T)((StubElement)this.mySubstrateRef.getGreenStub());
    }

    @Nullable
    public <Psi extends PsiElement> Psi getStubOrPsiChild(@NotNull IStubElementType<? extends StubElement, Psi> elementType) {
        T stub;
        if (elementType == null) {
            StubBasedPsiElementBase.$$$reportNull$$$0(19);
        }
        if ((stub = this.getGreenStub()) != null) {
            StubElement element2 = stub.findChildStubByType(elementType);
            if (element2 != null) {
                return (Psi)element2.getPsi();
            }
        } else {
            ASTNode childNode = this.getNode().findChildByType(elementType);
            if (childNode != null) {
                return (Psi)childNode.getPsi();
            }
        }
        return null;
    }

    @NotNull
    public <S extends StubElement<?>, Psi extends PsiElement> Psi getRequiredStubOrPsiChild(@NotNull IStubElementType<S, Psi> elementType) {
        Psi result2;
        if (elementType == null) {
            StubBasedPsiElementBase.$$$reportNull$$$0(20);
        }
        if ((result2 = this.getStubOrPsiChild(elementType)) == null) {
            throw new AssertionError((Object)("Missing required child of type " + elementType + "; tree: " + DebugUtil.psiToString((PsiElement)this, false)));
        }
        Psi Psi = result2;
        if (Psi == null) {
            StubBasedPsiElementBase.$$$reportNull$$$0(21);
        }
        return Psi;
    }

    public <S extends StubElement<?>, Psi extends PsiElement> Psi @NotNull [] getStubOrPsiChildren(@NotNull IStubElementType<S, ? extends Psi> elementType, Psi @NotNull [] array2) {
        T stub;
        if (elementType == null) {
            StubBasedPsiElementBase.$$$reportNull$$$0(22);
        }
        if (array2 == null) {
            StubBasedPsiElementBase.$$$reportNull$$$0(23);
        }
        if ((stub = this.getGreenStub()) != null) {
            PsiElement[] psiElementArray = stub.getChildrenByType(elementType, array2);
            if (psiElementArray == null) {
                StubBasedPsiElementBase.$$$reportNull$$$0(24);
            }
            return psiElementArray;
        }
        ASTNode[] nodes = SharedImplUtil.getChildrenOfType(this.getNode(), elementType);
        PsiElement[] psiElements = (PsiElement[])ArrayUtil.newArray((Class)ArrayUtil.getComponentType((Object[])array2), (int)nodes.length);
        for (int i2 = 0; i2 < nodes.length; ++i2) {
            psiElements[i2] = nodes[i2].getPsi();
        }
        if (psiElements == null) {
            StubBasedPsiElementBase.$$$reportNull$$$0(25);
        }
        return psiElements;
    }

    public <S extends StubElement<?>, Psi extends PsiElement> Psi @NotNull [] getStubOrPsiChildren(@NotNull IStubElementType<S, ? extends Psi> elementType, @NotNull ArrayFactory<? extends Psi> f) {
        T stub;
        if (elementType == null) {
            StubBasedPsiElementBase.$$$reportNull$$$0(26);
        }
        if (f == null) {
            StubBasedPsiElementBase.$$$reportNull$$$0(27);
        }
        if ((stub = this.getGreenStub()) != null) {
            PsiElement[] psiElementArray = stub.getChildrenByType(elementType, f);
            if (psiElementArray == null) {
                StubBasedPsiElementBase.$$$reportNull$$$0(28);
            }
            return psiElementArray;
        }
        ASTNode[] nodes = SharedImplUtil.getChildrenOfType(this.getNode(), elementType);
        PsiElement[] psiElements = (PsiElement[])f.create(nodes.length);
        for (int i2 = 0; i2 < nodes.length; ++i2) {
            psiElements[i2] = nodes[i2].getPsi();
        }
        if (psiElements == null) {
            StubBasedPsiElementBase.$$$reportNull$$$0(29);
        }
        return psiElements;
    }

    public <Psi extends PsiElement> Psi @NotNull [] getStubOrPsiChildren(@NotNull TokenSet filter2, Psi @NotNull [] array2) {
        T stub;
        if (filter2 == null) {
            StubBasedPsiElementBase.$$$reportNull$$$0(30);
        }
        if (array2 == null) {
            StubBasedPsiElementBase.$$$reportNull$$$0(31);
        }
        if ((stub = this.getGreenStub()) != null) {
            PsiElement[] psiElementArray = stub.getChildrenByType(filter2, array2);
            if (psiElementArray == null) {
                StubBasedPsiElementBase.$$$reportNull$$$0(32);
            }
            return psiElementArray;
        }
        ASTNode[] nodes = this.getNode().getChildren(filter2);
        PsiElement[] psiElements = (PsiElement[])ArrayUtil.newArray((Class)ArrayUtil.getComponentType((Object[])array2), (int)nodes.length);
        for (int i2 = 0; i2 < nodes.length; ++i2) {
            psiElements[i2] = nodes[i2].getPsi();
        }
        if (psiElements == null) {
            StubBasedPsiElementBase.$$$reportNull$$$0(33);
        }
        return psiElements;
    }

    public <Psi extends PsiElement> Psi @NotNull [] getStubOrPsiChildren(@NotNull TokenSet filter2, @NotNull ArrayFactory<? extends Psi> f) {
        T stub;
        if (filter2 == null) {
            StubBasedPsiElementBase.$$$reportNull$$$0(34);
        }
        if (f == null) {
            StubBasedPsiElementBase.$$$reportNull$$$0(35);
        }
        if ((stub = this.getGreenStub()) != null) {
            PsiElement[] psiElementArray = stub.getChildrenByType(filter2, f);
            if (psiElementArray == null) {
                StubBasedPsiElementBase.$$$reportNull$$$0(36);
            }
            return psiElementArray;
        }
        ASTNode[] nodes = this.getNode().getChildren(filter2);
        PsiElement[] psiElements = (PsiElement[])f.create(nodes.length);
        for (int i2 = 0; i2 < nodes.length; ++i2) {
            psiElements[i2] = nodes[i2].getPsi();
        }
        if (psiElements == null) {
            StubBasedPsiElementBase.$$$reportNull$$$0(37);
        }
        return psiElements;
    }

    @Nullable
    protected <E extends PsiElement> E getStubOrPsiParentOfType(@NotNull Class<E> parentClass) {
        T stub;
        if (parentClass == null) {
            StubBasedPsiElementBase.$$$reportNull$$$0(38);
        }
        if ((stub = this.getStub()) != null) {
            return (E)stub.getParentStubOfType(parentClass);
        }
        return (E)PsiTreeUtil.getParentOfType((PsiElement)this, parentClass);
    }

    protected Object clone() {
        StubBasedPsiElementBase copy2 = (StubBasedPsiElementBase)super.clone();
        copy2.setSubstrateRef(SubstrateRef.createAstStrongRef(this.getNode()));
        return copy2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 24: 
            case 25: 
            case 28: 
            case 29: 
            case 32: 
            case 33: 
            case 36: 
            case 37: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 24: 
            case 25: 
            case 28: 
            case 29: 
            case 32: 
            case 33: 
            case 36: 
            case 37: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeType";
                break;
            }
            case 2: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 24: 
            case 25: 
            case 28: 
            case 29: 
            case 32: 
            case 33: 
            case 36: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/extapi/psi/StubBasedPsiElementBase";
                break;
            }
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileElement";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "treeElement";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substrateRef";
                break;
            }
            case 19: 
            case 20: 
            case 22: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 23: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "array";
                break;
            }
            case 27: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "f";
                break;
            }
            case 30: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/extapi/psi/StubBasedPsiElementBase";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getNode";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "dumpCreationTraces";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguage";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getContainingFile";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementType";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getRequiredStubOrPsiChild";
                break;
            }
            case 24: 
            case 25: 
            case 28: 
            case 29: 
            case 32: 
            case 33: 
            case 36: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getStubOrPsiChildren";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 24: 
            case 25: 
            case 28: 
            case 29: 
            case 32: 
            case 33: 
            case 36: 
            case 37: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "failedToBindStubToAst";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "dumpCreationTraces";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "notBoundInExistingAst";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "setNode";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "setSubstrateRef";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getStubOrPsiChild";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getRequiredStubOrPsiChild";
                break;
            }
            case 22: 
            case 23: 
            case 26: 
            case 27: 
            case 30: 
            case 31: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getStubOrPsiChildren";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getStubOrPsiParentOfType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 24: 
            case 25: 
            case 28: 
            case 29: 
            case 32: 
            case 33: 
            case 36: 
            case 37: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

