/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.impl;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

class TemplateSegments {
    private final ArrayList<RangeMarker> mySegments;
    @NotNull
    private final Document myDocument;

    TemplateSegments(@NotNull Document document) {
        if (document == null) {
            TemplateSegments.$$$reportNull$$$0(0);
        }
        this.mySegments = new ArrayList();
        this.myDocument = document;
    }

    int getSegmentStart(int i2) {
        RangeMarker rangeMarker = this.mySegments.get(i2);
        return rangeMarker.getStartOffset();
    }

    int getSegmentEnd(int i2) {
        RangeMarker rangeMarker = this.mySegments.get(i2);
        return rangeMarker.getEndOffset();
    }

    boolean isValid(int i2) {
        return this.mySegments.get(i2).isValid();
    }

    void removeAll() {
        for (RangeMarker segment : this.mySegments) {
            segment.dispose();
        }
        this.mySegments.clear();
    }

    void addSegment(int start2, int end) {
        RangeMarker rangeMarker = this.myDocument.createRangeMarker(start2, end);
        this.mySegments.add(rangeMarker);
    }

    void setSegmentsGreedy(boolean greedy) {
        for (RangeMarker segment : this.mySegments) {
            segment.setGreedyToRight(greedy);
            segment.setGreedyToLeft(greedy);
        }
    }

    boolean isInvalid() {
        for (RangeMarker marker : this.mySegments) {
            if (marker.isValid()) continue;
            return true;
        }
        return false;
    }

    void replaceSegmentAt(int index, int start2, int end) {
        this.replaceSegmentAt(index, start2, end, false);
    }

    void replaceSegmentAt(int index, int start2, int end, boolean preserveGreediness) {
        RangeMarker rangeMarker = this.mySegments.get(index);
        boolean greedyToLeft = rangeMarker.isGreedyToLeft();
        boolean greedyToRight = rangeMarker.isGreedyToRight();
        rangeMarker.dispose();
        rangeMarker = this.myDocument.createRangeMarker(start2, end);
        rangeMarker.setGreedyToLeft(greedyToLeft || !preserveGreediness);
        rangeMarker.setGreedyToRight(greedyToRight || !preserveGreediness);
        this.mySegments.set(index, rangeMarker);
    }

    void setNeighboursGreedy(int segmentNumber, boolean greedy) {
        if (segmentNumber > 0) {
            RangeMarker left = this.mySegments.get(segmentNumber - 1);
            left.setGreedyToLeft(greedy);
            left.setGreedyToRight(greedy);
        }
        if (segmentNumber + 1 < this.mySegments.size()) {
            RangeMarker right = this.mySegments.get(segmentNumber + 1);
            right.setGreedyToLeft(greedy);
            right.setGreedyToRight(greedy);
        }
    }

    void lockSegmentAtTheSameOffsetIfAny(int number) {
        if (number == -1) {
            return;
        }
        RangeMarker current2 = this.mySegments.get(number);
        int offset = current2.getStartOffset();
        for (int i2 = 0; i2 < this.mySegments.size(); ++i2) {
            RangeMarker segment;
            int startOffset2;
            if (i2 == number || offset != (startOffset2 = (segment = this.mySegments.get(i2)).getStartOffset())) continue;
            segment.setGreedyToLeft(false);
        }
    }

    int getSegmentsCount() {
        return this.mySegments.size();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/codeInsight/template/impl/TemplateSegments", "<init>"));
    }
}

