/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.instrumentation;

import com.intellij.rt.coverage.data.ProjectData;
import com.intellij.rt.coverage.instrumentation.AbstractIntellijClassfileTransformer;
import com.intellij.rt.coverage.instrumentation.ClassInstrumenter;
import com.intellij.rt.coverage.instrumentation.NewSamplingInstrumenter;
import com.intellij.rt.coverage.instrumentation.SamplingInstrumenter;
import com.intellij.rt.coverage.util.ClassNameUtil;
import com.intellij.rt.coverage.util.classFinder.ClassFinder;
import java.util.List;
import java.util.regex.Pattern;
import org.jetbrains.coverage.org.objectweb.asm.ClassReader;
import org.jetbrains.coverage.org.objectweb.asm.ClassVisitor;
import org.jetbrains.coverage.org.objectweb.asm.ClassWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoverageClassfileTransformer
extends AbstractIntellijClassfileTransformer {
    private final ProjectData data;
    private final boolean shouldCalculateSource;
    private final List<Pattern> excludePatterns;
    private final List<Pattern> includePatterns;
    private final ClassFinder cf;

    public CoverageClassfileTransformer(ProjectData data, boolean shouldCalculateSource, List<Pattern> excludePatterns, List<Pattern> includePatterns, ClassFinder cf) {
        this.data = data;
        this.shouldCalculateSource = shouldCalculateSource;
        this.excludePatterns = excludePatterns;
        this.includePatterns = includePatterns;
        this.cf = cf;
    }

    @Override
    protected ClassVisitor createClassVisitor(String className, ClassLoader loader, ClassReader cr, ClassWriter cw) {
        if (this.data.isSampling()) {
            if (System.getProperty("idea.new.sampling.coverage") != null) {
                return new NewSamplingInstrumenter(this.data, cw, cr, className, this.shouldCalculateSource);
            }
            return new SamplingInstrumenter(this.data, cw, className, this.shouldCalculateSource);
        }
        return new ClassInstrumenter(this.data, cw, className, this.shouldCalculateSource);
    }

    @Override
    protected boolean shouldExclude(String className) {
        return ClassNameUtil.shouldExclude(className, this.excludePatterns);
    }

    @Override
    protected AbstractIntellijClassfileTransformer.InclusionPattern getInclusionPattern() {
        return this.includePatterns.isEmpty() ? null : new AbstractIntellijClassfileTransformer.InclusionPattern(){

            public boolean accept(String className) {
                for (Pattern includePattern : CoverageClassfileTransformer.this.includePatterns) {
                    if (!includePattern.matcher(className).matches()) continue;
                    return true;
                }
                return false;
            }
        };
    }

    @Override
    protected void visitClassLoader(ClassLoader classLoader) {
        this.cf.addClassLoader(classLoader);
    }

    @Override
    protected boolean isStopped() {
        return this.data.isStopped();
    }
}

