/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.XmlRecursiveElementVisitor;
import com.intellij.psi.impl.source.xml.SchemaPrefix;
import com.intellij.psi.impl.source.xml.SchemaPrefixReference;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.SequentialModalProgressTask;
import com.intellij.util.SequentialTask;
import com.intellij.xml.XmlBundle;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConvertSchemaPrefixToDefaultIntention
extends PsiElementBaseIntentionAction {
    public ConvertSchemaPrefixToDefaultIntention() {
        this.setText(XmlBundle.message((String)"xml.intention.reset.to.default.namespace.name", (Object[])new Object[0]));
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        XmlAttribute xmlns;
        if (project == null) {
            ConvertSchemaPrefixToDefaultIntention.$$$reportNull$$$0(0);
        }
        if (element == null) {
            ConvertSchemaPrefixToDefaultIntention.$$$reportNull$$$0(1);
        }
        if ((xmlns = ConvertSchemaPrefixToDefaultIntention.getXmlnsDeclaration(element)) == null) {
            return;
        }
        SchemaPrefixReference prefixRef = null;
        for (PsiReference ref : xmlns.getReferences()) {
            if (!(ref instanceof SchemaPrefixReference)) continue;
            prefixRef = (SchemaPrefixReference)ref;
            break;
        }
        if (prefixRef == null) {
            return;
        }
        final SchemaPrefix prefix = prefixRef.resolve();
        final String ns = prefixRef.getNamespacePrefix();
        final ArrayList tags = new ArrayList();
        final ArrayList attrs = new ArrayList();
        xmlns.getParent().accept((PsiElementVisitor)new XmlRecursiveElementVisitor(){

            public void visitXmlTag(XmlTag tag) {
                if (ns.equals(tag.getNamespacePrefix())) {
                    tags.add(tag);
                }
                super.visitXmlTag(tag);
            }

            public void visitXmlAttributeValue(XmlAttributeValue value) {
                if (value.getValue().startsWith(ns + ":")) {
                    for (PsiReference ref : value.getReferences()) {
                        if (!(ref instanceof SchemaPrefixReference) || !ref.isReferenceTo((PsiElement)prefix)) continue;
                        attrs.add((XmlAttribute)value.getParent());
                    }
                }
            }
        });
        if (!FileModificationService.getInstance().preparePsiElementsForWrite(new PsiElement[]{xmlns.getContainingFile()})) {
            return;
        }
        CommandProcessor.getInstance().executeCommand(project, () -> {
            ConvertSchemaPrefixToDefaultIntention.convertTagsAndAttributes(ns, tags, attrs, project);
            ApplicationManager.getApplication().runWriteAction(() -> xmlns.setName("xmlns"));
        }, XmlBundle.message((String)"xml.intention.reset.to.default.namespace.command", (Object[])new Object[0]), null);
        WriteCommandAction.writeCommandAction((Project)project, (PsiFile[])new PsiFile[]{xmlns.getContainingFile()}).withName(XmlBundle.message((String)"xml.intention.reset.to.default.namespace.command", (Object[])new Object[0])).run(() -> xmlns.setName("xmlns"));
    }

    private static void convertTagsAndAttributes(String ns, final List<? extends XmlTag> tags, final List<? extends XmlAttribute> attrs, Project project) {
        final int localNameIndex = ns.length() + 1;
        final int totalCount = tags.size() + attrs.size();
        final SequentialModalProgressTask progressTask = new SequentialModalProgressTask(project, XmlBundle.message((String)"xml.progress.changing.to.default.namespace", (Object[])new Object[0]), true);
        progressTask.setTask(new SequentialTask(){
            int tagIndex = 0;
            int attrIndex = 0;

            public boolean isDone() {
                return this.tagIndex + this.attrIndex >= totalCount;
            }

            public boolean iteration() {
                progressTask.getIndicator().setFraction((double)(this.tagIndex + this.attrIndex) / (double)totalCount);
                ApplicationManager.getApplication().runWriteAction(() -> {
                    if (this.tagIndex < tags.size()) {
                        XmlTag tag;
                        String s;
                        if (!(s = (tag = (XmlTag)tags.get(this.tagIndex++)).getName().substring(localNameIndex)).isEmpty()) {
                            tag.setName(s);
                        }
                    } else if (this.attrIndex < attrs.size()) {
                        XmlAttribute attr = (XmlAttribute)attrs.get(this.attrIndex++);
                        attr.setValue(attr.getValue().substring(localNameIndex));
                    }
                });
                return this.isDone();
            }
        });
        ProgressManager.getInstance().run((Task)progressTask);
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            ConvertSchemaPrefixToDefaultIntention.$$$reportNull$$$0(2);
        }
        if (element == null) {
            ConvertSchemaPrefixToDefaultIntention.$$$reportNull$$$0(3);
        }
        return ConvertSchemaPrefixToDefaultIntention.getXmlnsDeclaration(element) != null;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            ConvertSchemaPrefixToDefaultIntention.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Nullable
    private static XmlAttribute getXmlnsDeclaration(PsiElement element) {
        PsiElement parent = element.getParent();
        if (!(parent instanceof XmlElement)) {
            return null;
        }
        for (PsiReference ref : parent.getReferences()) {
            PsiElement tag;
            PsiElement attr;
            PsiElement elem;
            if (!(ref instanceof SchemaPrefixReference) || (elem = ref.resolve()) == null || !((attr = elem.getParent()) instanceof XmlAttribute) || !((tag = attr.getParent()) instanceof XmlTag) || ((XmlTag)tag).getAttribute("xmlns") != null) continue;
            return (XmlAttribute)attr;
        }
        return null;
    }

    public boolean startInWriteAction() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/analysis/ConvertSchemaPrefixToDefaultIntention";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/analysis/ConvertSchemaPrefixToDefaultIntention";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

