/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.run;

import com.intellij.execution.target.TargetEnvironment;
import com.intellij.execution.target.TargetEnvironmentRequest;
import com.intellij.execution.target.local.LocalTargetEnvironmentRequest;
import com.intellij.execution.target.value.TargetEnvironmentFunctions;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.PersistentLibraryKind;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PlatformUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PythonHelpersLocator;
import com.jetbrains.python.library.PythonLibraryType;
import com.jetbrains.python.run.PythonScripts;
import com.jetbrains.python.sdk.PythonSdkAdditionalData;
import com.jetbrains.python.sdk.flavors.JythonSdkFlavor;
import com.jetbrains.python.sdk.flavors.PythonSdkFlavor;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TargetedPythonPaths {
    private TargetedPythonPaths() {
    }

    public static void initPythonPath(@NotNull Map<String, Function<TargetEnvironment, String>> envs, boolean passParentEnvs, @NotNull Collection<Function<TargetEnvironment, String>> pythonPathList, @NotNull TargetEnvironmentRequest targetEnvironmentRequest) {
        if (envs == null) {
            TargetedPythonPaths.$$$reportNull$$$0(0);
        }
        if (pythonPathList == null) {
            TargetedPythonPaths.$$$reportNull$$$0(1);
        }
        if (targetEnvironmentRequest == null) {
            TargetedPythonPaths.$$$reportNull$$$0(2);
        }
        if (passParentEnvs && targetEnvironmentRequest instanceof LocalTargetEnvironmentRequest && !envs.containsKey("PYTHONPATH")) {
            TargetedPythonPaths.appendSystemPythonPath(pythonPathList);
        }
        PythonScripts.appendToPythonPath(envs, pythonPathList, targetEnvironmentRequest.getTargetPlatform());
    }

    private static void appendSystemPythonPath(@NotNull Collection<Function<TargetEnvironment, String>> pythonPath) {
        String syspath;
        if (pythonPath == null) {
            TargetedPythonPaths.$$$reportNull$$$0(3);
        }
        if ((syspath = System.getenv("PYTHONPATH")) != null) {
            pythonPath.addAll(ContainerUtil.map((Object[])syspath.split(File.pathSeparator), s -> TargetEnvironmentFunctions.constant((Object)s)));
        }
    }

    @NotNull
    public static Collection<Function<TargetEnvironment, String>> collectPythonPath(@NotNull TargetEnvironmentRequest targetEnvironmentRequest, @Nullable Module module, @Nullable String sdkHome, boolean shouldAddContentRoots, boolean shouldAddSourceRoots, boolean isDebug) {
        if (targetEnvironmentRequest == null) {
            TargetedPythonPaths.$$$reportNull$$$0(4);
        }
        LinkedHashSet<Function<TargetEnvironment, String>> pythonPath = new LinkedHashSet<Function<TargetEnvironment, String>>(TargetedPythonPaths.collectPythonPath(targetEnvironmentRequest, module, shouldAddContentRoots, shouldAddSourceRoots));
        if (isDebug && PythonSdkFlavor.getFlavor(sdkHome) instanceof JythonSdkFlavor) {
            for (String helpersResource : Arrays.asList("pycharm", "pydev")) {
                String helperPath = PythonHelpersLocator.getHelperPath(helpersResource);
                Function targetHelperPath = TargetEnvironmentFunctions.getTargetEnvironmentValueForLocalPath((TargetEnvironmentRequest)targetEnvironmentRequest, (String)helperPath);
                pythonPath.add(targetHelperPath);
            }
        }
        LinkedHashSet<Function<TargetEnvironment, String>> linkedHashSet = pythonPath;
        if (linkedHashSet == null) {
            TargetedPythonPaths.$$$reportNull$$$0(5);
        }
        return linkedHashSet;
    }

    @NotNull
    public static Collection<Function<TargetEnvironment, String>> collectPythonPath(@NotNull TargetEnvironmentRequest targetEnvironmentRequest, @Nullable Module module, boolean addContentRoots, boolean addSourceRoots) {
        if (targetEnvironmentRequest == null) {
            TargetedPythonPaths.$$$reportNull$$$0(6);
        }
        LinkedHashSet<Function<TargetEnvironment, String>> pythonPathList = new LinkedHashSet<Function<TargetEnvironment, String>>();
        if (module != null) {
            HashSet dependencies = new HashSet();
            ModuleUtilCore.getDependencies((Module)module, dependencies);
            if (addContentRoots) {
                TargetedPythonPaths.addRoots(targetEnvironmentRequest, pythonPathList, ModuleRootManager.getInstance((Module)module).getContentRoots());
                for (Module dependency : dependencies) {
                    TargetedPythonPaths.addRoots(targetEnvironmentRequest, pythonPathList, ModuleRootManager.getInstance((Module)dependency).getContentRoots());
                }
            }
            if (addSourceRoots) {
                TargetedPythonPaths.addRoots(targetEnvironmentRequest, pythonPathList, ModuleRootManager.getInstance((Module)module).getSourceRoots());
                for (Module dependency : dependencies) {
                    TargetedPythonPaths.addRoots(targetEnvironmentRequest, pythonPathList, ModuleRootManager.getInstance((Module)dependency).getSourceRoots());
                }
            }
            TargetedPythonPaths.addLibrariesFromModule(targetEnvironmentRequest, module, pythonPathList);
            TargetedPythonPaths.addRootsFromModule(module, pythonPathList);
            for (Module dependency : dependencies) {
                TargetedPythonPaths.addLibrariesFromModule(targetEnvironmentRequest, dependency, pythonPathList);
                TargetedPythonPaths.addRootsFromModule(dependency, pythonPathList);
            }
        }
        LinkedHashSet<Function<TargetEnvironment, String>> linkedHashSet = pythonPathList;
        if (linkedHashSet == null) {
            TargetedPythonPaths.$$$reportNull$$$0(7);
        }
        return linkedHashSet;
    }

    @NotNull
    public static List<Function<TargetEnvironment, String>> getAddedPaths(@NotNull TargetEnvironmentRequest targetEnvironmentRequest, @NotNull Sdk pythonSdk2) {
        if (targetEnvironmentRequest == null) {
            TargetedPythonPaths.$$$reportNull$$$0(8);
        }
        if (pythonSdk2 == null) {
            TargetedPythonPaths.$$$reportNull$$$0(9);
        }
        ArrayList<Function<TargetEnvironment, String>> pathList = new ArrayList<Function<TargetEnvironment, String>>();
        SdkAdditionalData sdkAdditionalData = pythonSdk2.getSdkAdditionalData();
        if (sdkAdditionalData instanceof PythonSdkAdditionalData) {
            Set<VirtualFile> addedPaths = ((PythonSdkAdditionalData)sdkAdditionalData).getAddedPathFiles();
            for (VirtualFile file : addedPaths) {
                TargetedPythonPaths.addToPythonPath(targetEnvironmentRequest, file, pathList);
            }
        }
        ArrayList<Function<TargetEnvironment, String>> arrayList = pathList;
        if (arrayList == null) {
            TargetedPythonPaths.$$$reportNull$$$0(10);
        }
        return arrayList;
    }

    private static void addToPythonPath(@NotNull TargetEnvironmentRequest targetEnvironmentRequest, @NotNull VirtualFile file, @NotNull Collection<Function<TargetEnvironment, String>> pathList) {
        if (targetEnvironmentRequest == null) {
            TargetedPythonPaths.$$$reportNull$$$0(11);
        }
        if (file == null) {
            TargetedPythonPaths.$$$reportNull$$$0(12);
        }
        if (pathList == null) {
            TargetedPythonPaths.$$$reportNull$$$0(13);
        }
        if (file.getFileSystem() instanceof JarFileSystem) {
            VirtualFile realFile = JarFileSystem.getInstance().getVirtualFileForJar(file);
            if (realFile != null) {
                TargetedPythonPaths.addIfNeeded(targetEnvironmentRequest, realFile, pathList);
            }
        } else {
            TargetedPythonPaths.addIfNeeded(targetEnvironmentRequest, file, pathList);
        }
    }

    private static void addIfNeeded(@NotNull TargetEnvironmentRequest targetEnvironmentRequest, @NotNull VirtualFile file, @NotNull Collection<Function<TargetEnvironment, String>> pathList) {
        if (targetEnvironmentRequest == null) {
            TargetedPythonPaths.$$$reportNull$$$0(14);
        }
        if (file == null) {
            TargetedPythonPaths.$$$reportNull$$$0(15);
        }
        if (pathList == null) {
            TargetedPythonPaths.$$$reportNull$$$0(16);
        }
        String filePath = FileUtil.toSystemDependentName((String)file.getPath());
        pathList.add(TargetEnvironmentFunctions.getTargetEnvironmentValueForLocalPath((TargetEnvironmentRequest)targetEnvironmentRequest, (String)filePath));
    }

    private static void addLibrariesFromModule(@NotNull TargetEnvironmentRequest targetEnvironmentRequest, @NotNull Module module, @NotNull Collection<Function<TargetEnvironment, String>> list) {
        OrderEntry[] entries;
        if (targetEnvironmentRequest == null) {
            TargetedPythonPaths.$$$reportNull$$$0(17);
        }
        if (module == null) {
            TargetedPythonPaths.$$$reportNull$$$0(18);
        }
        if (list == null) {
            TargetedPythonPaths.$$$reportNull$$$0(19);
        }
        for (OrderEntry entry : entries = ModuleRootManager.getInstance((Module)module).getOrderEntries()) {
            String name;
            if (!(entry instanceof LibraryOrderEntry) || (name = ((LibraryOrderEntry)entry).getLibraryName()) != null && name.endsWith(" interpreter library")) continue;
            for (VirtualFile root : ((LibraryOrderEntry)entry).getRootFiles(OrderRootType.CLASSES)) {
                PersistentLibraryKind kind;
                Library library = ((LibraryOrderEntry)entry).getLibrary();
                if (!PlatformUtils.isPyCharm()) {
                    TargetedPythonPaths.addToPythonPath(targetEnvironmentRequest, root, list);
                    continue;
                }
                if (!(library instanceof LibraryEx) || (kind = ((LibraryEx)library).getKind()) != PythonLibraryType.getInstance().getKind()) continue;
                TargetedPythonPaths.addToPythonPath(targetEnvironmentRequest, root, list);
            }
        }
    }

    private static void addRootsFromModule(@NotNull Module module, @NotNull Collection<Function<TargetEnvironment, String>> pythonPathList) {
        CompilerModuleExtension extension;
        if (module == null) {
            TargetedPythonPaths.$$$reportNull$$$0(20);
        }
        if (pythonPathList == null) {
            TargetedPythonPaths.$$$reportNull$$$0(21);
        }
        if ((extension = CompilerModuleExtension.getInstance((Module)module)) != null) {
            VirtualFile pathForTests;
            VirtualFile path = extension.getCompilerOutputPath();
            if (path != null) {
                pythonPathList.add(TargetEnvironmentFunctions.constant((Object)path.getPath()));
            }
            if ((pathForTests = extension.getCompilerOutputPathForTests()) != null) {
                pythonPathList.add(TargetEnvironmentFunctions.constant((Object)pathForTests.getPath()));
            }
        }
    }

    private static void addRoots(@NotNull TargetEnvironmentRequest targetEnvironmentRequest, @NotNull Collection<Function<TargetEnvironment, String>> pythonPathList, @NotNull @NotNull VirtualFile @NotNull [] roots) {
        if (targetEnvironmentRequest == null) {
            TargetedPythonPaths.$$$reportNull$$$0(22);
        }
        if (pythonPathList == null) {
            TargetedPythonPaths.$$$reportNull$$$0(23);
        }
        if (roots == null) {
            TargetedPythonPaths.$$$reportNull$$$0(24);
        }
        for (VirtualFile root : roots) {
            TargetedPythonPaths.addToPythonPath(targetEnvironmentRequest, root, pythonPathList);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 7: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 7: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "envs";
                break;
            }
            case 1: 
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pythonPathList";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 11: 
            case 14: 
            case 17: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetEnvironmentRequest";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pythonPath";
                break;
            }
            case 5: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/run/TargetedPythonPaths";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pythonSdk";
                break;
            }
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathList";
                break;
            }
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/run/TargetedPythonPaths";
                break;
            }
            case 5: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "collectPythonPath";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getAddedPaths";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "initPythonPath";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "appendSystemPythonPath";
                break;
            }
            case 4: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "collectPythonPath";
                break;
            }
            case 5: 
            case 7: 
            case 10: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getAddedPaths";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "addToPythonPath";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "addIfNeeded";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "addLibrariesFromModule";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "addRootsFromModule";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "addRoots";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 7: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

