/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.python.PyElementTypes;
import com.jetbrains.python.PyNames;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.psi.FutureFeature;
import com.jetbrains.python.psi.PyBinaryExpression;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyCallable;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyElementType;
import com.jetbrains.python.psi.PyElementVisitor;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import com.jetbrains.python.psi.impl.PyCallExpressionHelper;
import com.jetbrains.python.psi.impl.PyElementImpl;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.impl.references.PyOperatorReference;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.types.PyCallableParameter;
import com.jetbrains.python.psi.types.PyCallableType;
import com.jetbrains.python.psi.types.PyStructuralType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyTypeChecker;
import com.jetbrains.python.psi.types.PyUnionType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyBinaryExpressionImpl
extends PyElementImpl
implements PyBinaryExpression {
    public PyBinaryExpressionImpl(ASTNode astNode) {
        super(astNode);
    }

    @Override
    protected void acceptPyVisitor(PyElementVisitor pyVisitor) {
        pyVisitor.visitPyBinaryExpression(this);
    }

    @Override
    @Nullable
    public PyExpression getLeftExpression() {
        return (PyExpression)PsiTreeUtil.getChildOfType((PsiElement)this, PyExpression.class);
    }

    @Override
    @Nullable
    public PyExpression getRightExpression() {
        return (PyExpression)PsiTreeUtil.getNextSiblingOfType((PsiElement)this.getLeftExpression(), PyExpression.class);
    }

    @Override
    @Nullable
    public PyElementType getOperator() {
        PsiElement psiOperator = this.getPsiOperator();
        return psiOperator != null ? (PyElementType)psiOperator.getNode().getElementType() : null;
    }

    @Override
    @Nullable
    public PsiElement getPsiOperator() {
        ASTNode node = this.getNode();
        ASTNode child = node.findChildByType(PyElementTypes.BINARY_OPS);
        if (child != null) {
            return child.getPsi();
        }
        return null;
    }

    @Override
    public boolean isOperator(String chars) {
        StringBuilder buf = new StringBuilder();
        for (ASTNode child = this.getNode().getFirstChildNode(); child != null; child = child.getTreeNext()) {
            IElementType elType = child.getElementType();
            if (!(elType instanceof PyElementType) || !PyElementTypes.BINARY_OPS.contains(elType)) continue;
            buf.append(child.getText());
        }
        return buf.toString().equals(chars);
    }

    @Override
    @Nullable
    public PyExpression getOppositeExpression(PyExpression expression) throws IllegalArgumentException {
        PyExpression right = this.getRightExpression();
        PyExpression left = this.getLeftExpression();
        if (expression.equals(left)) {
            return right;
        }
        if (expression.equals(right)) {
            return left;
        }
        throw new IllegalArgumentException("expression " + expression + " is neither left exp or right exp");
    }

    public void deleteChildInternal(@NotNull ASTNode child) {
        if (child == null) {
            PyBinaryExpressionImpl.$$$reportNull$$$0(0);
        }
        PyExpression left = this.getLeftExpression();
        PyExpression right = this.getRightExpression();
        if (left == child.getPsi() && right != null) {
            this.replace((PsiElement)right);
        } else if (right == child.getPsi() && left != null) {
            this.replace((PsiElement)left);
        } else {
            throw new IncorrectOperationException("Element " + child.getPsi() + " is neither left expression or right expression");
        }
    }

    @NotNull
    public PsiPolyVariantReference getReference() {
        PsiPolyVariantReference psiPolyVariantReference = this.getReference(PyResolveContext.defaultContext());
        if (psiPolyVariantReference == null) {
            PyBinaryExpressionImpl.$$$reportNull$$$0(1);
        }
        return psiPolyVariantReference;
    }

    @Override
    @NotNull
    public PsiPolyVariantReference getReference(@NotNull PyResolveContext context) {
        if (context == null) {
            PyBinaryExpressionImpl.$$$reportNull$$$0(2);
        }
        return new PyOperatorReference(this, context);
    }

    @Override
    @Nullable
    public PyType getType(@NotNull TypeEvalContext context, @NotNull TypeEvalContext.Key key) {
        if (context == null) {
            PyBinaryExpressionImpl.$$$reportNull$$$0(3);
        }
        if (key == null) {
            PyBinaryExpressionImpl.$$$reportNull$$$0(4);
        }
        if (this.isOperator("and") || this.isOperator("or")) {
            PyType rightType;
            PyExpression left = this.getLeftExpression();
            PyType leftType = left != null ? context.getType(left) : null;
            PyExpression right = this.getRightExpression();
            PyType pyType = rightType = right != null ? context.getType(right) : null;
            if (leftType == null && rightType == null) {
                return null;
            }
            return PyUnionType.union(leftType, rightType);
        }
        if ("__contains__".equals(this.getReferencedName())) {
            return PyBuiltinCache.getInstance((PsiElement)this).getBoolType();
        }
        List<PyCallExpression.PyArgumentsMapping> results = PyCallExpressionHelper.mapArguments(this, PyResolveContext.defaultContext().withTypeEvalContext(context));
        if (!results.isEmpty()) {
            ArrayList<PyType> resultTypes;
            ArrayList<PyType> types = new ArrayList<PyType>();
            ArrayList<PyType> matchedTypes = new ArrayList<PyType>();
            for (PyCallExpression.PyArgumentsMapping result : results) {
                PyCallableType callableType = result.getCallableType();
                if (callableType == null) continue;
                boolean matched = true;
                for (Map.Entry<PyExpression, PyCallableParameter> entry : result.getMappedParameters().entrySet()) {
                    PyType argumentType;
                    PyType parameterType = entry.getValue().getArgumentType(context);
                    if (PyTypeChecker.match(parameterType, argumentType = context.getType(entry.getKey()), context)) continue;
                    matched = false;
                }
                PyType type = callableType.getCallType(context, this);
                types.add(type);
                if (!matched) continue;
                matchedTypes.add(type);
            }
            boolean bothOperandsAreKnown = PyBinaryExpressionImpl.operandIsKnown(this.getLeftExpression(), context) && PyBinaryExpressionImpl.operandIsKnown(this.getRightExpression(), context);
            ArrayList<PyType> arrayList = resultTypes = !matchedTypes.isEmpty() ? matchedTypes : types;
            if (!resultTypes.isEmpty()) {
                PyType result = PyUnionType.union(resultTypes);
                return bothOperandsAreKnown ? result : PyUnionType.createWeakType(result);
            }
        }
        if (PyNames.COMPARISON_OPERATORS.contains(this.getReferencedName())) {
            return PyBuiltinCache.getInstance((PsiElement)this).getBoolType();
        }
        return null;
    }

    @Override
    public PyExpression getQualifier() {
        return this.getLeftExpression();
    }

    @Override
    @Nullable
    public QualifiedName asQualifiedName() {
        return PyPsiUtils.asQualifiedName(this);
    }

    @Override
    public boolean isQualified() {
        return this.getQualifier() != null;
    }

    @Override
    public String getReferencedName() {
        PyElementType t = this.getOperator();
        if (t == PyTokenTypes.DIV && PyBinaryExpressionImpl.isTrueDivEnabled(this)) {
            return "__truediv__";
        }
        return t != null ? t.getSpecialMethodName() : null;
    }

    @Override
    public ASTNode getNameElement() {
        PsiElement op = this.getPsiOperator();
        return op != null ? op.getNode() : null;
    }

    @Override
    @Nullable
    public PyExpression getReceiver(@Nullable PyCallable resolvedCallee) {
        return this.isRightOperator(resolvedCallee) ? this.getRightExpression() : this.getChainedComparisonAwareLeftExpression();
    }

    @Override
    @NotNull
    public List<PyExpression> getArguments(@Nullable PyCallable resolvedCallee) {
        List<PyExpression> list = Collections.singletonList(this.isRightOperator(resolvedCallee) ? this.getChainedComparisonAwareLeftExpression() : this.getRightExpression());
        if (list == null) {
            PyBinaryExpressionImpl.$$$reportNull$$$0(5);
        }
        return list;
    }

    @Override
    public boolean isRightOperator(@Nullable PyCallable resolvedCallee) {
        return resolvedCallee != null && PyNames.isRightOperatorName(this.getReferencedName(), resolvedCallee.getName());
    }

    @Nullable
    private PyExpression getChainedComparisonAwareLeftExpression() {
        PyBinaryExpression leftBinaryExpr;
        PyExpression leftOperand = this.getLeftExpression();
        if (PyTokenTypes.COMPARISON_OPERATIONS.contains((IElementType)this.getOperator()) && (leftBinaryExpr = PyUtil.as(leftOperand, PyBinaryExpression.class)) != null && PyTokenTypes.COMPARISON_OPERATIONS.contains((IElementType)leftBinaryExpr.getOperator())) {
            return leftBinaryExpr.getRightExpression();
        }
        return leftOperand;
    }

    private static boolean operandIsKnown(@Nullable PyExpression operand, @NotNull TypeEvalContext context) {
        if (context == null) {
            PyBinaryExpressionImpl.$$$reportNull$$$0(6);
        }
        if (operand == null) {
            return false;
        }
        PyType operandType = context.getType(operand);
        return !(operandType instanceof PyStructuralType) && !PyTypeChecker.isUnknown(operandType, context);
    }

    private static boolean isTrueDivEnabled(@NotNull PyElement anchor) {
        PsiFile file;
        if (anchor == null) {
            PyBinaryExpressionImpl.$$$reportNull$$$0(7);
        }
        if ((file = anchor.getContainingFile()) instanceof PyFile) {
            PyFile pyFile = (PyFile)file;
            return FutureFeature.DIVISION.requiredAt(pyFile.getLanguageLevel()) || pyFile.hasImportFromFuture(FutureFeature.DIVISION);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/psi/impl/PyBinaryExpressionImpl";
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/psi/impl/PyBinaryExpressionImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getReference";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getArguments";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "deleteChildInternal";
                break;
            }
            case 1: 
            case 5: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getReference";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getType";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "operandIsKnown";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isTrueDivEnabled";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

