/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PySuperArgumentsInspection
extends PyInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            PySuperArgumentsInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            PySuperArgumentsInspection.$$$reportNull$$$0(1);
        }
        return new Visitor(holder, session);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "session";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/python/inspections/PySuperArgumentsInspection";
        objectArray[2] = "buildVisitor";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class Visitor
    extends PyInspectionVisitor {
        Visitor(ProblemsHolder holder, LocalInspectionToolSession session) {
            super(holder, session);
        }

        @Override
        public void visitPyCallExpression(@NotNull PyCallExpression node) {
            PyExpression[] arguments;
            PyExpression callee;
            if (node == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            if ((callee = node.getCallee()) != null && "super".equals(callee.getName()) && (arguments = node.getArguments()).length == 2 && arguments[0] instanceof PyReferenceExpression && arguments[1] instanceof PyReferenceExpression) {
                PyClass firstClass = this.findClassOf(arguments[0]);
                PyClass secondClass = this.findClassOf(arguments[1]);
                if (firstClass != null && secondClass != null && !secondClass.isSubclass(firstClass, this.myTypeEvalContext)) {
                    this.registerProblem((PsiElement)node.getArgumentList(), PyPsiBundle.message("INSP.class.is.not.subtype.of.class", secondClass.getName(), firstClass.getName()));
                }
            }
        }

        @Nullable
        private PyClass findClassOf(PyExpression argument) {
            PyType first_type;
            PsiElement firstElement = ((PyReferenceExpression)argument).followAssignmentsChain(this.getResolveContext()).getElement();
            PyClass firstClass = null;
            if (firstElement instanceof PyClass) {
                firstClass = (PyClass)firstElement;
            } else if (firstElement instanceof PyExpression && (first_type = this.myTypeEvalContext.getType((PyExpression)firstElement)) instanceof PyClassType) {
                firstClass = ((PyClassType)first_type).getPyClass();
            }
            return firstClass;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/python/inspections/PySuperArgumentsInspection$Visitor", "visitPyCallExpression"));
        }
    }
}

