/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.inspections.quickfix.PyCreatePropertyQuickFix;
import com.jetbrains.python.psi.AccessDirection;
import com.jetbrains.python.psi.Property;
import com.jetbrains.python.psi.PyAugAssignmentStatement;
import com.jetbrains.python.psi.PyCallable;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyQualifiedExpression;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.toolbox.Maybe;
import org.jetbrains.annotations.NotNull;

public class PyPropertyAccessInspection
extends PyInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            PyPropertyAccessInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            PyPropertyAccessInspection.$$$reportNull$$$0(1);
        }
        return new Visitor(holder, session);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "session";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/python/inspections/PyPropertyAccessInspection";
        objectArray[2] = "buildVisitor";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class Visitor
    extends PyInspectionVisitor {
        Visitor(@NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
            if (holder == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            if (session == null) {
                Visitor.$$$reportNull$$$0(1);
            }
            super(holder, session);
        }

        @Override
        public void visitPyReferenceExpression(@NotNull PyReferenceExpression node) {
            if (node == null) {
                Visitor.$$$reportNull$$$0(2);
            }
            super.visitPyReferenceExpression(node);
            this.checkPropertyExpression(node);
        }

        @Override
        public void visitPyTargetExpression(@NotNull PyTargetExpression node) {
            if (node == null) {
                Visitor.$$$reportNull$$$0(3);
            }
            super.visitPyTargetExpression(node);
            this.checkPropertyExpression(node);
        }

        private void checkPropertyExpression(PyQualifiedExpression node) {
            PyType type;
            PyExpression qualifier = node.getQualifier();
            if (qualifier != null && (type = this.myTypeEvalContext.getType(qualifier)) instanceof PyClassType) {
                Property property;
                PyClass cls = ((PyClassType)type).getPyClass();
                String name = node.getName();
                if (name != null && (property = cls.findProperty(name, true, this.myTypeEvalContext)) != null) {
                    PsiElement parent;
                    AccessDirection dir = AccessDirection.of(node);
                    this.checkAccessor(node, name, dir, property);
                    if (dir == AccessDirection.READ && (parent = node.getParent()) instanceof PyAugAssignmentStatement && ((PyAugAssignmentStatement)parent).getTarget() == node) {
                        this.checkAccessor(node, name, AccessDirection.WRITE, property);
                    }
                }
            }
        }

        private void checkAccessor(@NotNull PyExpression node, @NotNull String name, @NotNull AccessDirection dir, @NotNull Property property) {
            Maybe<PyCallable> accessor;
            if (node == null) {
                Visitor.$$$reportNull$$$0(4);
            }
            if (name == null) {
                Visitor.$$$reportNull$$$0(5);
            }
            if (dir == null) {
                Visitor.$$$reportNull$$$0(6);
            }
            if (property == null) {
                Visitor.$$$reportNull$$$0(7);
            }
            if ((accessor = property.getByDirection(dir)).isDefined() && accessor.value() == null) {
                String message = dir == AccessDirection.WRITE ? PyPsiBundle.message("INSP.property.cannot.be.set", name) : (dir == AccessDirection.DELETE ? PyPsiBundle.message("INSP.property.cannot.be.deleted", name) : PyPsiBundle.message("INSP.property.cannot.be.read", name));
                this.registerProblem((PsiElement)node, message, new PyCreatePropertyQuickFix(dir));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "holder";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "session";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dir";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "property";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/python/inspections/PyPropertyAccessInspection$Visitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPyReferenceExpression";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPyTargetExpression";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "checkAccessor";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

