/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.console;

import com.intellij.ide.DataManager;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.DocumentUtil;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.psi.PyStatementList;
import com.jetbrains.python.psi.PyStatementListContainer;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyStringLiteralUtil;
import com.jetbrains.python.psi.PyTryPart;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import java.awt.Component;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u001a\u0010\r\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u000e\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fJ\u0010\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u0013H\u0002J\u0018\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u0011H\u0002J\u0010\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u0013H\u0002\u00a8\u0006\u001d"}, d2={"Lcom/jetbrains/python/console/PyConsoleEnterHandler;", "", "()V", "checkComplete", "", "el", "Lcom/intellij/psi/PsiElement;", "executeEnterHandler", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "findFirstNoneSpaceElement", "psiFile", "Lcom/intellij/psi/PsiFile;", "offset", "", "getLineAtOffset", "", "doc", "Lcom/intellij/openapi/editor/Document;", "handleEnterPressed", "isCompleteDocString", "str", "isElementInsideDocString", "atElement", "caretOffset", "isMultilineString", "intellij.python.community.impl"})
public final class PyConsoleEnterHandler {
    /*
     * Unable to fully structure code
     */
    public final boolean handleEnterPressed(@NotNull EditorEx editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        v0 = editor.getProject();
        if (v0 == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"editor.project ?: throw IllegalArgumentException()");
        project = v0;
        v1 = editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"editor.document");
        lineCount = v1.getLineCount();
        if (lineCount > 0) {
            editor.getSelectionModel().removeSelection();
            v2 = editor.getCaretModel();
            Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"editor.caretModel");
            v3 = v2.getLogicalPosition();
            Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"editor.caretModel.logicalPosition");
            caretPosition = v3;
            if (caretPosition.line != lineCount - 1) {
                this.executeEnterHandler(project, editor);
                return false;
            }
        } else {
            return true;
        }
        lineEndOffset = editor.getDocument().getLineEndOffset(caretPosition.line);
        editor.getCaretModel().moveToOffset(lineEndOffset);
        psiMgr = PsiDocumentManager.getInstance((Project)project);
        psiMgr.commitDocument((Document)editor.getDocument());
        caretOffset = editor.getExpectedCaretOffset();
        v4 = psiMgr.getPsiFile((Document)editor.getDocument());
        Intrinsics.checkNotNull((Object)v4);
        Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"psiMgr.getPsiFile(editor.document)!!");
        atElement = this.findFirstNoneSpaceElement(v4, caretOffset);
        if (atElement == null) {
            this.executeEnterHandler(project, editor);
            return false;
        }
        v5 = editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"editor.document");
        var9_8 = firstLine = this.getLineAtOffset((Document)v5, DocumentUtil.getFirstNonSpaceCharOffset((Document)((Document)editor.getDocument()), (int)0));
        var10_9 = false;
        v6 = var9_8;
        if (v6 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        if (!StringsKt.startsWith$default((String)StringsKt.trim((CharSequence)v6).toString(), (String)"%%", (boolean)false, (int)2, null)) ** GOTO lbl-1000
        var9_8 = firstLine;
        var10_9 = false;
        v7 = var9_8;
        if (v7 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        if (!StringsKt.endsWith$default((String)StringsKt.trimEnd((CharSequence)v7).toString(), (String)"?", (boolean)false, (int)2, null)) {
            v8 = true;
        } else lbl-1000:
        // 2 sources

        {
            v8 = false;
        }
        isCellMagic = v8;
        v9 = editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)v9, (String)"editor.document");
        var11_11 = prevLine = this.getLineAtOffset((Document)v9, caretOffset);
        var12_13 = false;
        v10 = var11_11;
        if (v10 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        isLineContinuation = StringsKt.endsWith$default((CharSequence)StringsKt.trim((CharSequence)v10).toString(), (char)'\\', (boolean)false, (int)2, null);
        insideDocString = this.isElementInsideDocString(atElement, caretOffset);
        isMultiLineCommand = PsiTreeUtil.getParentOfType((PsiElement)atElement, PyStatementListContainer.class) != null || isCellMagic != false;
        v11 = editor.getDocument().getLineNumber(caretOffset);
        v12 = editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)v12, (String)"editor.document");
        isAtTheEndOfCommand = v11 == v12.getLineCount() - 1;
        hasCompleteStatement = insideDocString == false && isLineContinuation == false && this.checkComplete(atElement) != false;
        this.executeEnterHandler(project, editor);
        return isAtTheEndOfCommand != false && hasCompleteStatement != false && (isMultiLineCommand != false && StringsKt.isBlank((CharSequence)prevLine) != false || isMultiLineCommand == false);
    }

    private final void executeEnterHandler(Project project, EditorEx editor2) {
        EditorActionHandler enterHandler = EditorActionManager.getInstance().getActionHandler("EditorEnter");
        WriteCommandAction.runWriteCommandAction((Project)project, (Runnable)new Runnable(enterHandler, editor2){
            final /* synthetic */ EditorActionHandler $enterHandler;
            final /* synthetic */ EditorEx $editor;

            public final void run() {
                this.$enterHandler.execute((Editor)this.$editor, null, DataManager.getInstance().getDataContext((Component)this.$editor.getComponent()));
            }
            {
                this.$enterHandler = editorActionHandler;
                this.$editor = editorEx;
            }
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isElementInsideDocString(PsiElement atElement, int caretOffset) {
        if (!(atElement.getContext() instanceof PyStringLiteralExpression)) return false;
        ASTNode aSTNode = atElement.getNode();
        Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"atElement.node");
        if (!PyTokenTypes.TRIPLE_NODES.contains(aSTNode.getElementType())) {
            ASTNode aSTNode2 = atElement.getNode();
            Intrinsics.checkNotNullExpressionValue((Object)aSTNode2, (String)"atElement.node");
            if (aSTNode2.getElementType() != PyTokenTypes.DOCSTRING) return false;
        }
        String string = atElement.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"atElement.text");
        if (!this.isMultilineString(string)) return false;
        TextRange textRange = atElement.getTextRange();
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"atElement.textRange");
        if (textRange.getEndOffset() > caretOffset) return true;
        String string2 = atElement.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"atElement.text");
        if (this.isCompleteDocString(string2)) return false;
        return true;
    }

    private final boolean checkComplete(PsiElement el) {
        PyStatementListContainer compoundStatement = (PyStatementListContainer)PsiTreeUtil.getParentOfType((PsiElement)el, PyStatementListContainer.class);
        if (compoundStatement != null && !(compoundStatement instanceof PyTryPart)) {
            PyStatementList pyStatementList = compoundStatement.getStatementList();
            Intrinsics.checkNotNullExpressionValue((Object)pyStatementList, (String)"compoundStatement.statementList");
            return pyStatementList.getStatements().length != 0;
        }
        PsiElement topLevel = PyPsiUtils.getParentRightBefore(el, (PsiElement)el.getContainingFile());
        return topLevel != null && !PsiTreeUtil.hasErrorElements((PsiElement)topLevel);
    }

    /*
     * WARNING - void declaration
     */
    private final PsiElement findFirstNoneSpaceElement(PsiFile psiFile, int offset) {
        int n = offset;
        boolean bl = false;
        while (n >= 0) {
            void i;
            PsiElement el = psiFile.findElementAt((int)i);
            if (el != null && !(el instanceof PsiWhiteSpace)) {
                return el;
            }
            --i;
        }
        return null;
    }

    private final String getLineAtOffset(Document doc, int offset) {
        int line2 = doc.getLineNumber(offset);
        int start = doc.getLineStartOffset(line2);
        int end = doc.getLineEndOffset(line2);
        String string = doc.getText(new TextRange(start, end));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"doc.getText(TextRange(start, end))");
        return string;
    }

    private final boolean isMultilineString(String str) {
        String string = str;
        int n = PyStringLiteralUtil.getPrefixLength(str);
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.substring(n);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
        String text2 = string3;
        return StringsKt.startsWith$default((String)text2, (String)"\"\"\"", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)text2, (String)"'''", (boolean)false, (int)2, null);
    }

    private final boolean isCompleteDocString(String str) {
        int prefixLen = PyStringLiteralUtil.getPrefixLength(str);
        String string = str;
        int n = 0;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.substring(prefixLen);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
        String text2 = string3;
        for (String token : new String[]{"\"\"\"", "'''"}) {
            if (text2.length() < 2 * token.length() || !StringsKt.startsWith$default((String)text2, (String)token, (boolean)false, (int)2, null) || !StringsKt.endsWith$default((String)text2, (String)token, (boolean)false, (int)2, null)) continue;
            return true;
        }
        return false;
    }
}

