/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.override;

import com.intellij.codeInsight.generation.ClassMember;
import com.intellij.codeInsight.generation.MemberChooserObject;
import com.intellij.codeInsight.generation.PsiElementMemberChooserObject;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.List;

public class PyMethodMember
extends PsiElementMemberChooserObject
implements ClassMember {
    @NlsSafe
    private static String buildNameFor(PyElement element) {
        if (element instanceof PyFunction) {
            TypeEvalContext context = TypeEvalContext.userInitiated(element.getProject(), element.getContainingFile());
            List parameters = ((PyFunction)element).getParameters(context);
            StringBuilder result = new StringBuilder();
            result.append(element.getName()).append('(');
            StringUtil.join((Iterable)parameters, parameter -> parameter.getPresentableText(true, context), (String)", ", (StringBuilder)result);
            result.append(')');
            return result.toString();
        }
        return element.getName();
    }

    public PyMethodMember(PyElement element) {
        super((PsiElement)element, PyMethodMember.buildNameFor(element), element.getIcon(0));
    }

    public MemberChooserObject getParentNodeDelegate() {
        PyElement element = (PyElement)this.getPsiElement();
        PyClass parent = (PyClass)PsiTreeUtil.getParentOfType((PsiElement)element, PyClass.class, (boolean)false);
        assert (parent != null);
        return new PyMethodMember(parent);
    }
}

