/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.parameterInfo.ParameterFlag;
import com.intellij.lang.parameterInfo.CreateParameterInfoContext;
import com.intellij.lang.parameterInfo.ParameterInfoHandler;
import com.intellij.lang.parameterInfo.ParameterInfoUIContext;
import com.intellij.lang.parameterInfo.ParameterInfoUIContextEx;
import com.intellij.lang.parameterInfo.UpdateParameterInfoContext;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ArrayUtilRt;
import com.intellij.xml.util.XmlStringUtil;
import com.jetbrains.python.codeInsight.parameterInfo.ParameterHints;
import com.jetbrains.python.codeInsight.parameterInfo.PyParameterInfoUtils;
import com.jetbrains.python.psi.PyArgumentList;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.types.PyCallableType;
import java.util.EnumSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyParameterInfoHandler
implements ParameterInfoHandler<PyArgumentList, Pair<PyCallExpression, PyCallableType>> {
    @Nullable
    public PyArgumentList findElementForParameterInfo(@NotNull CreateParameterInfoContext context) {
        int offset;
        PsiFile file;
        PyArgumentList argumentList;
        List<Pair<PyCallExpression, PyCallableType>> parameterInfos;
        if (context == null) {
            PyParameterInfoHandler.$$$reportNull$$$0(0);
        }
        if ((parameterInfos = PyParameterInfoUtils.findCallCandidates(argumentList = PyParameterInfoUtils.findArgumentList(file = context.getFile(), offset = context.getOffset(), -1))) != null) {
            Object[] infoArr = parameterInfos.toArray();
            context.setItemsToShow(infoArr);
            return argumentList;
        }
        return null;
    }

    public void showParameterInfo(@NotNull PyArgumentList element, @NotNull CreateParameterInfoContext context) {
        if (element == null) {
            PyParameterInfoHandler.$$$reportNull$$$0(1);
        }
        if (context == null) {
            PyParameterInfoHandler.$$$reportNull$$$0(2);
        }
        context.showHint((PsiElement)element, element.getTextOffset(), (ParameterInfoHandler)this);
    }

    @Nullable
    public PyArgumentList findElementForUpdatingParameterInfo(@NotNull UpdateParameterInfoContext context) {
        if (context == null) {
            PyParameterInfoHandler.$$$reportNull$$$0(3);
        }
        return PyParameterInfoUtils.findArgumentList(context.getFile(), context.getOffset(), context.getParameterListStart());
    }

    public void updateParameterInfo(@NotNull PyArgumentList argumentList, @NotNull UpdateParameterInfoContext context) {
        if (argumentList == null) {
            PyParameterInfoHandler.$$$reportNull$$$0(4);
        }
        if (context == null) {
            PyParameterInfoHandler.$$$reportNull$$$0(5);
        }
        int allegedCursorOffset = context.getOffset();
        if (!argumentList.getTextRange().contains(allegedCursorOffset) && argumentList.getText().endsWith(")")) {
            context.removeHint();
            return;
        }
        PsiFile file = context.getFile();
        int offset = PyParameterInfoUtils.findCurrentParameter(argumentList, allegedCursorOffset, file);
        context.setCurrentParameter(offset);
    }

    public void updateUI(@NotNull Pair<PyCallExpression, PyCallableType> callAndCallee, @NotNull ParameterInfoUIContext context) {
        int currentParamOffset;
        ParameterHints parameterHints;
        if (callAndCallee == null) {
            PyParameterInfoHandler.$$$reportNull$$$0(6);
        }
        if (context == null) {
            PyParameterInfoHandler.$$$reportNull$$$0(7);
        }
        if ((parameterHints = PyParameterInfoUtils.buildParameterHints(callAndCallee, currentParamOffset = context.getCurrentParameterIndex())) == null) {
            return;
        }
        String[] hints = ArrayUtilRt.toStringArray(parameterHints.getHints());
        if (context instanceof ParameterInfoUIContextEx) {
            ParameterInfoUIContextEx pic = (ParameterInfoUIContextEx)context;
            EnumSet[] flags = new EnumSet[parameterHints.getFlags().size()];
            for (int i = 0; i < flags.length; ++i) {
                EnumSet<ParameterInfoUIContextEx.Flag> paramUIFlags = EnumSet.noneOf(ParameterInfoUIContextEx.Flag.class);
                EnumSet<ParameterFlag> paramsFlags = parameterHints.getFlags().get(i);
                for (ParameterFlag flag : paramsFlags) {
                    switch (flag) {
                        case HIGHLIGHT: {
                            paramUIFlags.add(ParameterInfoUIContextEx.Flag.HIGHLIGHT);
                            break;
                        }
                        case STRIKEOUT: {
                            paramUIFlags.add(ParameterInfoUIContextEx.Flag.STRIKEOUT);
                            break;
                        }
                        case DISABLE: {
                            paramUIFlags.add(ParameterInfoUIContextEx.Flag.DISABLE);
                        }
                    }
                }
                flags[i] = paramUIFlags;
            }
            if (hints.length < 1) {
                hints = new String[]{PyParameterInfoHandler.getNoParamsMsg()};
                flags = new EnumSet[]{EnumSet.of(ParameterInfoUIContextEx.Flag.DISABLE)};
            }
            pic.setupUIComponentPresentation(hints, flags, context.getDefaultParameterColor());
        } else {
            StringBuilder signatureBuilder = new StringBuilder();
            if (hints.length > 1) {
                for (String s : hints) {
                    signatureBuilder.append(s);
                }
            } else {
                signatureBuilder.append(XmlStringUtil.escapeString((String)PyParameterInfoHandler.getNoParamsMsg()));
            }
            context.setupUIComponentPresentation(signatureBuilder.toString(), -1, 0, false, false, false, context.getDefaultParameterColor());
        }
    }

    private static String getNoParamsMsg() {
        return CodeInsightBundle.message((String)"parameter.info.no.parameters", (Object[])new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argumentList";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callAndCallee";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/PyParameterInfoHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "findElementForParameterInfo";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "showParameterInfo";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "findElementForUpdatingParameterInfo";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "updateParameterInfo";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "updateUI";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

