"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var react_redux_1 = require("react-redux");
var get_chart_container_dimensions_1 = require("../../../../state/selectors/get_chart_container_dimensions");
var get_internal_is_intialized_1 = require("../../../../state/selectors/get_internal_is_intialized");
var geometries_1 = require("../../state/selectors/geometries");
var get_highlighted_shapes_1 = require("../../state/selectors/get_highlighted_shapes");
var highlighter_1 = require("./highlighter");
var legendMapStateToProps = function (state) {
    if (get_internal_is_intialized_1.getInternalIsInitializedSelector(state) !== get_internal_is_intialized_1.InitStatus.Initialized) {
        return highlighter_1.DEFAULT_PROPS;
    }
    var chartId = state.chartId;
    var _a = geometries_1.partitionGeometries(state), outerRadius = _a.outerRadius, diskCenter = _a.diskCenter, partitionLayout = _a.config.partitionLayout;
    var geometries = get_highlighted_shapes_1.getHighlightedSectorsSelector(state);
    var canvasDimension = get_chart_container_dimensions_1.getChartContainerDimensionsSelector(state);
    return {
        chartId: chartId,
        initialized: true,
        renderAsOverlay: false,
        canvasDimension: canvasDimension,
        geometries: geometries,
        diskCenter: diskCenter,
        outerRadius: outerRadius,
        partitionLayout: partitionLayout,
    };
};
exports.HighlighterFromLegend = react_redux_1.connect(legendMapStateToProps)(highlighter_1.HighlighterComponent);
//# sourceMappingURL=highlighter_legend.js.map