/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.universe.galleon1;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.repo.RepositoryArtifactInstaller;
import org.jboss.galleon.repo.RepositoryArtifactResolver;
import org.jboss.galleon.util.ZipUtils;

public class LegacyGalleon1RepositoryManager
implements RepositoryArtifactResolver,
RepositoryArtifactInstaller {
    private static final String REPOSITORY_ID = "repository.maven";
    private static final Pattern COORDS_PATTERN = Pattern.compile("([^: ]+):([^: ]+)(:([^: ]*)(:([^: ]+))?)?:([^: ]+)");
    final Path repoHome;

    public static LegacyGalleon1RepositoryManager newInstance(Path repoHome) {
        return new LegacyGalleon1RepositoryManager(repoHome);
    }

    private LegacyGalleon1RepositoryManager(Path repoHome) {
        this.repoHome = repoHome;
    }

    @Override
    public void install(String coords, Path artifact) throws ProvisioningException {
        try {
            Path path = this.getArtifactPath(coords);
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            if (Files.isDirectory(artifact, new LinkOption[0])) {
                ZipUtils.zip(artifact, path);
            } else {
                Files.copy(artifact, path, StandardCopyOption.REPLACE_EXISTING);
            }
        }
        catch (IOException ex) {
            throw new ProvisioningException("Failed to install artifact " + coords + " to " + artifact, ex);
        }
    }

    @Override
    public String getRepositoryId() {
        return REPOSITORY_ID;
    }

    @Override
    public Path resolve(String location) throws ProvisioningException {
        Path path = this.getArtifactPath(location);
        if (!Files.exists(path, new LinkOption[0])) {
            throw new ProvisioningException("Artifact " + location + " not found in the repository at " + path);
        }
        return path;
    }

    private Path getArtifactPath(String location) {
        String[] groupParts;
        Matcher m = COORDS_PATTERN.matcher(location);
        if (!m.matches()) {
            throw new IllegalArgumentException("Bad artifact coordinates " + location + ", expected format is <groupId>:<artifactId>[:<extension>[:<classifier>]]:<version>");
        }
        String groupId = m.group(1);
        String artifactId = m.group(2);
        String extension = LegacyGalleon1RepositoryManager.get(m.group(4), "zip");
        String classifier = LegacyGalleon1RepositoryManager.get(m.group(6), "");
        String version = m.group(7);
        Path p = this.repoHome;
        for (String part : groupParts = groupId.split("\\.")) {
            p = p.resolve(part);
        }
        p = p.resolve(artifactId);
        p = p.resolve(version);
        StringBuilder fileName = new StringBuilder();
        fileName.append(artifactId).append('-').append(version);
        if (!classifier.isEmpty()) {
            fileName.append('-').append(classifier);
        }
        fileName.append('.').append(extension);
        return p.resolve(fileName.toString());
    }

    private static String get(String value, String defaultValue) {
        return value == null || value.length() <= 0 ? defaultValue : value;
    }
}

