class HARBase{constructor(data){if(!data||typeof data!=='object'){throw'First parameter is expected to be an object';}}
static _safeDate(data){const date=new Date(data);if(!Number.isNaN(date.getTime())){return date;}
throw'Invalid date format';}
static _safeNumber(data){const result=Number(data);if(!Number.isNaN(result)){return result;}
throw'Casting to number results in NaN';}
static _optionalNumber(data){return data!==undefined?HARBase._safeNumber(data):undefined;}
static _optionalString(data){return data!==undefined?String(data):undefined;}
customAsString(name){const value=(this)['_'+name];return value!==undefined?String(value):undefined;}
customAsNumber(name){let value=(this)['_'+name];if(value===undefined){return;}
value=Number(value);if(Number.isNaN(value)){return;}
return value;}
customAsArray(name){const value=(this)['_'+name];return Array.isArray(value)?value:undefined;}}
export class HARRoot extends HARBase{constructor(data){super(data);this.log=new HARLog(data['log']);}}
export class HARLog extends HARBase{constructor(data){super(data);this.version=String(data['version']);this.creator=new HARCreator(data['creator']);this.browser=data['browser']?new HARCreator(data['browser']):undefined;this.pages=Array.isArray(data['pages'])?data['pages'].map(page=>new HARImporter.HARPage(page)):[];if(!Array.isArray(data['entries'])){throw'log.entries is expected to be an array';}
this.entries=data['entries'].map(entry=>new HAREntry(entry));this.comment=HARBase._optionalString(data['comment']);}}
class HARCreator extends HARBase{constructor(data){super(data);this.name=String(data['name']);this.version=String(data['version']);this.comment=HARBase._optionalString(data['comment']);}}
export class HARPage extends HARBase{constructor(data){super(data);this.startedDateTime=HARBase._safeDate(data['startedDateTime']);this.id=String(data['id']);this.title=String(data['title']);this.pageTimings=new HARPageTimings(data['pageTimings']);this.comment=HARBase._optionalString(data['comment']);}}
class HARPageTimings extends HARBase{constructor(data){super(data);this.onContentLoad=HARBase._optionalNumber(data['onContentLoad']);this.onLoad=HARBase._optionalNumber(data['onLoad']);this.comment=HARBase._optionalString(data['comment']);}}
export class HAREntry extends HARBase{constructor(data){super(data);this.pageref=HARBase._optionalString(data['pageref']);this.startedDateTime=HARBase._safeDate(data['startedDateTime']);this.time=HARBase._safeNumber(data['time']);this.request=new HARRequest(data['request']);this.response=new HARResponse(data['response']);this.cache={};this.timings=new HARTimings(data['timings']);this.serverIPAddress=HARBase._optionalString(data['serverIPAddress']);this.connection=HARBase._optionalString(data['connection']);this.comment=HARBase._optionalString(data['comment']);this._fromCache=HARBase._optionalString(data['_fromCache']);this._initiator=this._importInitiator(data['_initiator']);this._priority=HARBase._optionalString(data['_priority']);this._resourceType=HARBase._optionalString(data['_resourceType']);this._webSocketMessages=this._importWebSocketMessages(data['_webSocketMessages']);}
_importInitiator(initiator){if(typeof initiator!=='object'){return;}
return new HARInitiator(initiator);}
_importWebSocketMessages(inputMessages){if(!Array.isArray(inputMessages)){return;}
const outputMessages=[];for(const message of inputMessages){if(typeof message!=='object'){return;}
outputMessages.push(new HARWebSocketMessage(message));}
return outputMessages;}}
class HARRequest extends HARBase{constructor(data){super(data);this.method=String(data['method']);this.url=String(data['url']);this.httpVersion=String(data['httpVersion']);this.cookies=Array.isArray(data['cookies'])?data['cookies'].map(cookie=>new HARCookie(cookie)):[];this.headers=Array.isArray(data['headers'])?data['headers'].map(header=>new HARHeader(header)):[];this.queryString=Array.isArray(data['queryString'])?data['queryString'].map(qs=>new HARQueryString(qs)):[];this.postData=data['postData']?new HARPostData(data['postData']):undefined;this.headersSize=HARBase._safeNumber(data['headersSize']);this.bodySize=HARBase._safeNumber(data['bodySize']);this.comment=HARBase._optionalString(data['comment']);}}
class HARResponse extends HARBase{constructor(data){super(data);this.status=HARBase._safeNumber(data['status']);this.statusText=String(data['statusText']);this.httpVersion=String(data['httpVersion']);this.cookies=Array.isArray(data['cookies'])?data['cookies'].map(cookie=>new HARCookie(cookie)):[];this.headers=Array.isArray(data['headers'])?data['headers'].map(header=>new HARHeader(header)):[];this.content=new HARContent(data['content']);this.redirectURL=String(data['redirectURL']);this.headersSize=HARBase._safeNumber(data['headersSize']);this.bodySize=HARBase._safeNumber(data['bodySize']);this.comment=HARBase._optionalString(data['comment']);this._transferSize=HARBase._optionalNumber(data['_transferSize']);this._error=HARBase._optionalString(data['_error']);}}
class HARCookie extends HARBase{constructor(data){super(data);this.name=String(data['name']);this.value=String(data['value']);this.path=HARBase._optionalString(data['path']);this.domain=HARBase._optionalString(data['domain']);this.expires=data['expires']?HARBase._safeDate(data['expires']):undefined;this.httpOnly=data['httpOnly']!==undefined?!!data['httpOnly']:undefined;this.secure=data['secure']!==undefined?!!data['secure']:undefined;this.comment=HARBase._optionalString(data['comment']);}}
class HARHeader extends HARBase{constructor(data){super(data);this.name=String(data['name']);this.value=String(data['value']);this.comment=HARBase._optionalString(data['comment']);}}
class HARQueryString extends HARBase{constructor(data){super(data);this.name=String(data['name']);this.value=String(data['value']);this.comment=HARBase._optionalString(data['comment']);}}
class HARPostData extends HARBase{constructor(data){super(data);this.mimeType=String(data['mimeType']);this.params=Array.isArray(data['params'])?data['params'].map(param=>new HARImporter.HARParam(param)):[];this.text=String(data['text']);this.comment=HARBase._optionalString(data['comment']);}}
export class HARParam extends HARBase{constructor(data){super(data);this.name=String(data['name']);this.value=HARBase._optionalString(data['value']);this.fileName=HARBase._optionalString(data['fileName']);this.contentType=HARBase._optionalString(data['contentType']);this.comment=HARBase._optionalString(data['comment']);}}
class HARContent extends HARBase{constructor(data){super(data);this.size=HARBase._safeNumber(data['size']);this.compression=HARBase._optionalNumber(data['compression']);this.mimeType=String(data['mimeType']);this.text=HARBase._optionalString(data['text']);this.encoding=HARBase._optionalString(data['encoding']);this.comment=HARBase._optionalString(data['comment']);}}
export class HARTimings extends HARBase{constructor(data){super(data);this.blocked=HARBase._optionalNumber(data['blocked']);this.dns=HARBase._optionalNumber(data['dns']);this.connect=HARBase._optionalNumber(data['connect']);this.send=HARBase._safeNumber(data['send']);this.wait=HARBase._safeNumber(data['wait']);this.receive=HARBase._safeNumber(data['receive']);this.ssl=HARBase._optionalNumber(data['ssl']);this.comment=HARBase._optionalString(data['comment']);this._blocked_queueing=HARBase._optionalNumber(data['_blocked_queueing']);this._blocked_proxy=HARBase._optionalNumber(data['_blocked_proxy']);}}
export class HARInitiator extends HARBase{constructor(data){super(data);this.type=HARBase._optionalString(data['type']);this.url=HARBase._optionalString(data['url']);this.lineNumber=HARBase._optionalNumber(data['lineNumber']);}}
class HARWebSocketMessage extends HARBase{constructor(data){super(data);this.time=HARBase._optionalNumber(data['time']);this.opcode=HARBase._optionalNumber(data['opcode']);this.data=HARBase._optionalString(data['data']);this.type=HARBase._optionalString(data['type']);}}
self.HARImporter=self.HARImporter||{};HARImporter=HARImporter||{};HARImporter.HARRoot=HARRoot;HARImporter.HARLog=HARLog;HARImporter.HARPage=HARPage;HARImporter.HAREntry=HAREntry;HARImporter.HARParam=HARParam;HARImporter.HARTimings=HARTimings;HARImporter.HARInitiator=HARInitiator;