/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.dex2jar.tools;

import com.googlecode.d2j.dex.ClassVisitorFactory;
import com.googlecode.d2j.dex.Dex2Asm;
import com.googlecode.d2j.node.DexFileNode;
import com.googlecode.d2j.reader.DexFileReader;
import com.googlecode.d2j.visitors.DexFileVisitor;
import com.googlecode.dex2jar.tools.BaseCmd;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;

@BaseCmd.Syntax(cmd="d2j-generate-stub-from-odex", syntax="[options] <odex0> [odex1 ... odexN]", desc="Genenerate no-code jar from odex")
public class GenerateCompileStubFromOdex
extends BaseCmd {
    private static final int MAGIC_ODEX = 7955812;
    private static final int MAGIC_DEX = 7890276;
    @BaseCmd.Opt(opt="o", longOpt="output", description="output .jar file, default is stub.jar", argName="out-jar-file")
    private Path output;
    @BaseCmd.Opt(opt="npri", longOpt="no-private", description="", hasArg=false)
    private boolean noPrivate;

    public static void main(String ... args) {
        new GenerateCompileStubFromOdex().doMain(args);
    }

    protected void doCommandLine() throws Exception {
        if (this.remainingArgs.length == 0) {
            throw new BaseCmd.HelpException("no odex");
        }
        if (this.output == null) {
            this.output = new File("stub.jar").toPath();
        }
        Throwable throwable = null;
        Object var2_3 = null;
        try (FileSystem fs = GenerateCompileStubFromOdex.createZip((Path)this.output);){
            Path out = fs.getPath("/", new String[0]);
            String[] stringArray = this.remainingArgs;
            int n = this.remainingArgs.length;
            int n2 = 0;
            while (n2 < n) {
                String x = stringArray[n2];
                System.err.println("process " + x + " ...");
                ByteBuffer bs = ByteBuffer.wrap(Files.readAllBytes(new File(x).toPath())).order(ByteOrder.LITTLE_ENDIAN);
                int magic = bs.getInt(0) & 0xFFFFFF;
                if (magic == 7955812) {
                    int offset = bs.getInt(8);
                    int length = bs.getInt(12);
                    bs.position(offset);
                    ByteBuffer n3 = (ByteBuffer)bs.slice().limit(length);
                    this.doDex(n3, out);
                } else if (magic == 7890276) {
                    this.doDex(bs, out);
                } else {
                    throw new RuntimeException("file " + x + " is not an dex or odex");
                }
                ++n2;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void doDex(ByteBuffer bs, final Path out) {
        DexFileReader reader = new DexFileReader(bs);
        DexFileNode fileNode = new DexFileNode();
        reader.accept((DexFileVisitor)fileNode, 4);
        Dex2Asm dex2Asm = new Dex2Asm();
        dex2Asm.convertDex(fileNode, new ClassVisitorFactory(){

            public ClassVisitor create(String classInternalName) {
                final Path target = out.resolve(String.valueOf(classInternalName) + ".class");
                if (Files.exists(target, new LinkOption[0])) {
                    System.err.println("class " + classInternalName + " is already exists, skipping.");
                    return null;
                }
                return new ClassVisitor(262144, (ClassVisitor)new ClassWriter(1)){

                    public void visitEnd() {
                        super.visitEnd();
                        ClassWriter cw = (ClassWriter)this.cv;
                        byte[] data = cw.toByteArray();
                        try {
                            BaseCmd.createParentDirectories((Path)target);
                            Files.write(target, data, new OpenOption[0]);
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }

                    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
                        if (GenerateCompileStubFromOdex.this.noPrivate && (access & 2) != 0) {
                            return null;
                        }
                        return super.visitField(access, name, desc, signature, value);
                    }

                    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                        if (GenerateCompileStubFromOdex.this.noPrivate && (access & 2) != 0) {
                            return null;
                        }
                        MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
                        if ((0x500 & access) != 0) {
                            return mv;
                        }
                        mv.visitTypeInsn(187, "java/lang/RuntimeException");
                        mv.visitInsn(89);
                        mv.visitLdcInsn((Object)"stub");
                        mv.visitMethodInsn(183, "java/lang/RuntimeException", "<init>", "(Ljava/lang/String;)V");
                        mv.visitInsn(191);
                        return mv;
                    }
                };
            }
        });
    }
}

