/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.validate;

import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.validate.AbstractNamespace;
import org.apache.calcite.sql.validate.SqlValidatorImpl;
import org.apache.calcite.sql.validate.SqlValidatorScope;
import org.checkerframework.checker.nullness.qual.Nullable;

public class CollectNamespace
extends AbstractNamespace {
    private final SqlCall child;
    private final SqlValidatorScope scope;

    CollectNamespace(SqlCall child, SqlValidatorScope scope, SqlNode enclosingNode) {
        super((SqlValidatorImpl)scope.getValidator(), enclosingNode);
        this.child = child;
        this.scope = scope;
        assert (child.getKind() == SqlKind.MULTISET_VALUE_CONSTRUCTOR || child.getKind() == SqlKind.MULTISET_QUERY_CONSTRUCTOR);
    }

    @Override
    protected RelDataType validateImpl(RelDataType targetRowType) {
        return this.child.getOperator().deriveType(this.validator, this.scope, this.child);
    }

    @Override
    public @Nullable SqlNode getNode() {
        return this.child;
    }

    public SqlValidatorScope getScope() {
        return this.scope;
    }
}

