/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.component;

import java.util.Collections;
import java.util.List;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.handler.component.HttpShardHandlerFactory;
import org.apache.solr.handler.component.ReplicaSource;

class StandaloneReplicaSource
implements ReplicaSource {
    private List<String>[] replicas;

    public StandaloneReplicaSource(Builder builder) {
        List list = StrUtils.splitSmart((String)builder.shardsParam, (String)",", (boolean)true);
        this.replicas = new List[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            this.replicas[i] = StrUtils.splitSmart((String)((String)list.get(i)), (String)"|", (boolean)true);
            builder.hostChecker.checkWhitelist(builder.shardsParam, this.replicas[i]);
        }
    }

    @Override
    public List<String> getSliceNames() {
        return Collections.emptyList();
    }

    @Override
    public int getSliceCount() {
        return this.replicas.length;
    }

    @Override
    public List<String> getReplicasBySlice(int sliceNumber) {
        assert (sliceNumber >= 0 && sliceNumber < this.replicas.length);
        return this.replicas[sliceNumber];
    }

    static class Builder {
        private String shardsParam;
        private HttpShardHandlerFactory.WhitelistHostChecker hostChecker;

        Builder() {
        }

        public Builder shards(String shardsParam) {
            this.shardsParam = shardsParam;
            return this;
        }

        public Builder whitelistHostChecker(HttpShardHandlerFactory.WhitelistHostChecker hostChecker) {
            this.hostChecker = hostChecker;
            return this;
        }

        public StandaloneReplicaSource build() {
            return new StandaloneReplicaSource(this);
        }
    }
}

