/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.component;

import com.carrotsearch.hppc.IntHashSet;
import com.carrotsearch.hppc.IntObjectHashMap;
import com.carrotsearch.hppc.LongHashSet;
import com.carrotsearch.hppc.LongObjectHashMap;
import com.carrotsearch.hppc.LongObjectMap;
import com.carrotsearch.hppc.cursors.IntObjectCursor;
import com.carrotsearch.hppc.cursors.LongCursor;
import com.carrotsearch.hppc.cursors.LongObjectCursor;
import com.carrotsearch.hppc.cursors.ObjectCursor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.MultiDocValues;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.OrdinalMap;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorable;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TermInSetQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopDocsCollector;
import org.apache.lucene.search.TopFieldCollector;
import org.apache.lucene.search.TopScoreDocCollector;
import org.apache.lucene.search.TotalHitCountCollector;
import org.apache.lucene.search.TotalHits;
import org.apache.lucene.util.BitSet;
import org.apache.lucene.util.BitSetIterator;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.CharsRefBuilder;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.LongValues;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.core.PluginInfo;
import org.apache.solr.core.SolrCore;
import org.apache.solr.core.SolrInfoBean;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.handler.component.SearchComponent;
import org.apache.solr.handler.component.ShardRequest;
import org.apache.solr.handler.component.ShardResponse;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.schema.StrField;
import org.apache.solr.search.CollapsingQParserPlugin;
import org.apache.solr.search.DocIterator;
import org.apache.solr.search.DocList;
import org.apache.solr.search.DocSlice;
import org.apache.solr.search.QParser;
import org.apache.solr.search.QueryUtils;
import org.apache.solr.search.ReturnFields;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.search.SortSpecParsing;
import org.apache.solr.search.SyntaxError;
import org.apache.solr.util.plugin.PluginInfoInitialized;
import org.apache.solr.util.plugin.SolrCoreAware;

public class ExpandComponent
extends SearchComponent
implements PluginInfoInitialized,
SolrCoreAware {
    public static final String COMPONENT_NAME = "expand";
    private static final int finishingStage = ResponseBuilder.STAGE_GET_FIELDS;
    private PluginInfo info = PluginInfo.EMPTY_INFO;

    @Override
    public void init(PluginInfo info) {
        this.info = info;
    }

    @Override
    public void prepare(ResponseBuilder rb) throws IOException {
        if (rb.req.getParams().getBool(COMPONENT_NAME, false)) {
            if (rb.req.getParams().getBool("group", false)) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Can not use expand with Grouping enabled");
            }
            rb.doExpand = true;
        }
    }

    @Override
    public void inform(SolrCore core) {
    }

    @Override
    public void process(ResponseBuilder rb) throws IOException {
        Object collector;
        boolean expandNullGroup;
        Query query;
        List<Query> filters;
        if (!rb.doExpand) {
            return;
        }
        SolrQueryRequest req = rb.req;
        SolrParams params = req.getParams();
        String field = params.get("expand.field");
        String hint = null;
        if (field == null && (filters = rb.getFilters()) != null) {
            int cost = Integer.MAX_VALUE;
            for (Query q : filters) {
                CollapsingQParserPlugin.CollapsingPostFilter cp;
                if (!(q instanceof CollapsingQParserPlugin.CollapsingPostFilter) || (cp = (CollapsingQParserPlugin.CollapsingPostFilter)q).getCost() >= cost) continue;
                cost = cp.getCost();
                field = cp.getField();
                hint = cp.hint;
            }
        }
        if (field == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "missing expand field");
        }
        String sortParam = params.get("expand.sort");
        String[] fqs = params.getParams("expand.fq");
        String qs = params.get("expand.q");
        int limit = params.getInt("expand.rows", 5);
        Sort sort = null;
        if (sortParam != null) {
            sort = SortSpecParsing.parseSortSpec(sortParam, rb.req).getSort();
        }
        ArrayList<Query> newFilters = new ArrayList<Query>();
        try {
            if (qs == null) {
                query = rb.getQuery();
            } else {
                QParser parser = QParser.getParser(qs, req);
                query = parser.getQuery();
            }
            if (fqs == null) {
                List<Query> filters2 = rb.getFilters();
                if (filters2 != null) {
                    Iterator iterator = filters2.iterator();
                    while (iterator.hasNext()) {
                        Query q = (Query)iterator.next();
                        if (q instanceof CollapsingQParserPlugin.CollapsingPostFilter) continue;
                        newFilters.add(q);
                    }
                }
            } else {
                for (String fq : fqs) {
                    if (!StringUtils.isNotBlank((CharSequence)fq) || fq.equals("*:*")) continue;
                    QParser fqp = QParser.getParser(fq, req);
                    newFilters.add(fqp.getQuery());
                }
            }
        }
        catch (SyntaxError e) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, (Throwable)e);
        }
        SolrIndexSearcher searcher = req.getSearcher();
        LeafReader reader = searcher.getSlowAtomicReader();
        SchemaField schemaField = searcher.getSchema().getField(field);
        FieldType fieldType = schemaField.getType();
        SortedDocValues values = null;
        if (fieldType instanceof StrField) {
            if ("top_fc".equals(hint)) {
                LeafReader uninvertingReader = CollapsingQParserPlugin.getTopFieldCacheReader(searcher, field);
                values = uninvertingReader.getSortedDocValues(field);
            } else {
                values = DocValues.getSorted((LeafReader)reader, (String)field);
            }
        } else if (fieldType.getNumberType() == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Expand not supported for fieldType:'" + fieldType.getTypeName() + "'");
        }
        FixedBitSet groupBits = null;
        LongHashSet groupSet = null;
        DocList docList = rb.getResults().docList;
        IntHashSet collapsedSet = new IntHashSet(docList.size() * 2);
        DocIterator idit = docList.iterator();
        int[] globalDocs = new int[docList.size()];
        int docsIndex = -1;
        while (idit.hasNext()) {
            globalDocs[++docsIndex] = idit.nextDoc();
        }
        Arrays.sort(globalDocs);
        Query groupQuery = null;
        List contexts = searcher.getTopReaderContext().leaves();
        if (contexts.size() == 0) {
            return;
        }
        boolean nullGroupOnCurrentPage = false;
        int currentContext = 0;
        int currentDocBase = ((LeafReaderContext)contexts.get((int)currentContext)).docBase;
        int nextDocBase = currentContext + 1 < contexts.size() ? ((LeafReaderContext)contexts.get((int)(currentContext + 1))).docBase : Integer.MAX_VALUE;
        IntObjectHashMap ordBytes = null;
        if (values != null) {
            groupBits = new FixedBitSet(values.getValueCount());
            OrdinalMap ordinalMap = null;
            SortedDocValues[] sortedDocValues = null;
            LongValues segmentOrdinalMap = null;
            SortedDocValues currentValues = null;
            if (values instanceof MultiDocValues.MultiSortedDocValues) {
                ordinalMap = ((MultiDocValues.MultiSortedDocValues)values).mapping;
                sortedDocValues = ((MultiDocValues.MultiSortedDocValues)values).values;
                currentValues = sortedDocValues[currentContext];
                segmentOrdinalMap = ordinalMap.getGlobalOrds(currentContext);
            }
            ordBytes = new IntObjectHashMap();
            for (int i = 0; i < globalDocs.length; ++i) {
                int globalDoc = globalDocs[i];
                while (globalDoc >= nextDocBase) {
                    currentDocBase = ((LeafReaderContext)contexts.get((int)(++currentContext))).docBase;
                    int n = nextDocBase = currentContext + 1 < contexts.size() ? ((LeafReaderContext)contexts.get((int)(currentContext + 1))).docBase : Integer.MAX_VALUE;
                    if (ordinalMap == null) continue;
                    currentValues = sortedDocValues[currentContext];
                    segmentOrdinalMap = ordinalMap.getGlobalOrds(currentContext);
                }
                collapsedSet.add(globalDoc);
                int contextDoc = globalDoc - currentDocBase;
                if (ordinalMap != null) {
                    if (contextDoc > currentValues.docID()) {
                        currentValues.advance(contextDoc);
                    }
                    if (contextDoc == currentValues.docID()) {
                        int contextOrd = currentValues.ordValue();
                        int ord = (int)segmentOrdinalMap.get((long)contextOrd);
                        if (groupBits.getAndSet(ord)) continue;
                        BytesRef ref = currentValues.lookupOrd(contextOrd);
                        ordBytes.put(ord, (Object)BytesRef.deepCopyOf((BytesRef)ref));
                        continue;
                    }
                    nullGroupOnCurrentPage = true;
                    continue;
                }
                if (globalDoc > values.docID()) {
                    values.advance(globalDoc);
                }
                if (globalDoc == values.docID()) {
                    int ord = values.ordValue();
                    if (groupBits.getAndSet(ord)) continue;
                    BytesRef ref = values.lookupOrd(ord);
                    ordBytes.put(ord, (Object)BytesRef.deepCopyOf((BytesRef)ref));
                    continue;
                }
                nullGroupOnCurrentPage = true;
            }
            int count = ordBytes.size();
            if (count > 0 && count < 200) {
                groupQuery = this.getGroupQuery(field, count, (IntObjectHashMap<BytesRef>)ordBytes);
            }
        } else {
            groupSet = new LongHashSet(docList.size());
            NumericDocValues collapseValues = ((LeafReaderContext)contexts.get(currentContext)).reader().getNumericDocValues(field);
            for (int i = 0; i < globalDocs.length; ++i) {
                int globalDoc = globalDocs[i];
                while (globalDoc >= nextDocBase) {
                    currentDocBase = ((LeafReaderContext)contexts.get((int)(++currentContext))).docBase;
                    nextDocBase = currentContext + 1 < contexts.size() ? ((LeafReaderContext)contexts.get((int)(currentContext + 1))).docBase : Integer.MAX_VALUE;
                    collapseValues = ((LeafReaderContext)contexts.get(currentContext)).reader().getNumericDocValues(field);
                }
                collapsedSet.add(globalDoc);
                int contextDoc = globalDoc - currentDocBase;
                int valueDocID = collapseValues.docID();
                if (valueDocID < contextDoc) {
                    valueDocID = collapseValues.advance(contextDoc);
                }
                if (valueDocID == contextDoc) {
                    long value = collapseValues.longValue();
                    groupSet.add(value);
                    continue;
                }
                nullGroupOnCurrentPage = true;
            }
            int count = groupSet.size();
            if (count > 0 && count < 200) {
                groupQuery = fieldType.isPointField() ? this.getPointGroupQuery(schemaField, count, groupSet) : this.getGroupQuery(field, fieldType, count, groupSet);
            }
        }
        boolean bl = expandNullGroup = params.getBool("expand.nullGroup", false) && (nullGroupOnCurrentPage || null != query);
        if (expandNullGroup && null != groupQuery) {
            BooleanQuery.Builder inner = new BooleanQuery.Builder();
            inner.add(fieldType.getExistenceQuery(null, schemaField), BooleanClause.Occur.MUST_NOT);
            inner.add((Query)new MatchAllDocsQuery(), BooleanClause.Occur.MUST);
            BooleanQuery.Builder outer = new BooleanQuery.Builder();
            outer.add((Query)inner.build(), BooleanClause.Occur.SHOULD);
            outer.add(groupQuery, BooleanClause.Occur.SHOULD);
            groupQuery = outer.build();
        }
        if (sort != null) {
            sort = sort.rewrite((IndexSearcher)searcher);
        }
        GroupCollector groupExpandCollector = null;
        if (values != null) {
            if ("top_fc".equals(hint)) {
                LeafReader uninvertingReader = CollapsingQParserPlugin.getTopFieldCacheReader(searcher, field);
                values = uninvertingReader.getSortedDocValues(field);
            } else {
                values = DocValues.getSorted((LeafReader)reader, (String)field);
            }
            groupExpandCollector = new GroupExpandCollector(limit, sort, query, expandNullGroup, fieldType, (IntObjectHashMap<BytesRef>)ordBytes, values, groupBits, collapsedSet);
        } else {
            groupExpandCollector = new NumericGroupExpandCollector(limit, sort, query, expandNullGroup, fieldType, (IntObjectHashMap<BytesRef>)ordBytes, field, groupSet, collapsedSet);
        }
        if (groupQuery != null) {
            newFilters.add(groupQuery);
        }
        SolrIndexSearcher.ProcessedFilter pfilter = searcher.getProcessedFilter(null, newFilters);
        if (pfilter.postFilter != null) {
            pfilter.postFilter.setLastDelegate(groupExpandCollector);
            collector = pfilter.postFilter;
        } else {
            collector = groupExpandCollector;
        }
        searcher.search(QueryUtils.combineQueryAndFilter(query, pfilter.filter), (Collector)collector);
        rb.rsp.add("expanded", groupExpandCollector.getGroups(searcher, rb.rsp.getReturnFields()));
    }

    @Override
    public int distributedProcess(ResponseBuilder rb) throws IOException {
        if (rb.doExpand && rb.stage < finishingStage) {
            return finishingStage;
        }
        return ResponseBuilder.STAGE_DONE;
    }

    @Override
    public void modifyRequest(ResponseBuilder rb, SearchComponent who, ShardRequest sreq) {
        SolrParams params = rb.req.getParams();
        if (!params.getBool(COMPONENT_NAME, false)) {
            return;
        }
        if (!rb.onePassDistributedQuery && (sreq.purpose & 0x40) == 0) {
            sreq.params.set(COMPONENT_NAME, new String[]{"false"});
        } else {
            sreq.params.set(COMPONENT_NAME, new String[]{"true"});
        }
    }

    @Override
    public void handleResponses(ResponseBuilder rb, ShardRequest sreq) {
        if (!rb.doExpand) {
            return;
        }
        if ((sreq.purpose & 0x40) != 0) {
            SolrQueryRequest req = rb.req;
            NamedList expanded = (NamedList)req.getContext().get("expanded");
            if (expanded == null) {
                expanded = new SimpleOrderedMap();
                req.getContext().put("expanded", expanded);
            }
            for (ShardResponse srsp : sreq.responses) {
                NamedList response = srsp.getSolrResponse().getResponse();
                NamedList ex = (NamedList)response.get("expanded");
                for (int i = 0; i < ex.size(); ++i) {
                    String name = ex.getName(i);
                    SolrDocumentList val = (SolrDocumentList)ex.getVal(i);
                    expanded.add(name, (Object)val);
                }
            }
        }
    }

    @Override
    public void finishStage(ResponseBuilder rb) {
        if (!rb.doExpand) {
            return;
        }
        if (rb.stage != finishingStage) {
            return;
        }
        NamedList expanded = (NamedList)rb.req.getContext().get("expanded");
        if (expanded == null) {
            expanded = new SimpleOrderedMap();
        }
        rb.rsp.add("expanded", expanded);
    }

    private Query getGroupQuery(String fname, FieldType ft, int size, LongHashSet groupSet) {
        BytesRef[] bytesRefs = new BytesRef[size];
        int index = -1;
        BytesRefBuilder term = new BytesRefBuilder();
        for (LongCursor cursor : groupSet) {
            String stringVal = ExpandComponent.numericToString(ft, cursor.value);
            ft.readableToIndexed(stringVal, term);
            bytesRefs[++index] = term.toBytesRef();
        }
        return new TermInSetQuery(fname, bytesRefs);
    }

    private Query getPointGroupQuery(SchemaField sf, int size, LongHashSet groupSet) {
        Iterator it = groupSet.iterator();
        ArrayList<String> values = new ArrayList<String>(size);
        FieldType ft = sf.getType();
        while (it.hasNext()) {
            LongCursor cursor = (LongCursor)it.next();
            values.add(ExpandComponent.numericToString(ft, cursor.value));
        }
        return sf.getType().getSetQuery(null, sf, values);
    }

    private static String numericToString(FieldType fieldType, long val) {
        if (fieldType.getNumberType() != null) {
            switch (fieldType.getNumberType()) {
                case INTEGER: 
                case LONG: {
                    return Long.toString(val);
                }
                case FLOAT: {
                    return Float.toString(Float.intBitsToFloat((int)val));
                }
                case DOUBLE: {
                    return Double.toString(Double.longBitsToDouble(val));
                }
            }
        }
        throw new IllegalArgumentException("FieldType must be INT,LONG,FLOAT,DOUBLE found " + fieldType);
    }

    private Query getGroupQuery(String fname, int size, IntObjectHashMap<BytesRef> ordBytes) {
        BytesRef[] bytesRefs = new BytesRef[size];
        int index = -1;
        for (IntObjectCursor cursor : ordBytes) {
            bytesRefs[++index] = (BytesRef)cursor.value;
        }
        return new TermInSetQuery(fname, bytesRefs);
    }

    @Override
    public String getDescription() {
        return "Expand Component";
    }

    @Override
    public SolrInfoBean.Category getCategory() {
        return SolrInfoBean.Category.QUERY;
    }

    private static abstract class GroupCollector
    implements Collector {
        protected final int limit;
        protected final Sort sort;
        protected final Query query;
        protected final boolean expandNullGroup;
        protected final FieldType fieldType;
        protected final IntObjectHashMap<BytesRef> ordBytes;
        protected final Collector nullGroupCollector;

        public GroupCollector(int limit, Sort sort, Query query, boolean expandNullGroup, FieldType fieldType, IntObjectHashMap<BytesRef> ordBytes) throws IOException {
            this.limit = limit;
            this.sort = sort;
            this.query = query;
            this.expandNullGroup = expandNullGroup;
            this.fieldType = fieldType;
            this.ordBytes = ordBytes;
            this.nullGroupCollector = expandNullGroup ? this.getCollector() : null;
        }

        protected abstract LongObjectMap<Collector> getGroups();

        public final SimpleOrderedMap<DocSlice> getGroups(SolrIndexSearcher searcher, ReturnFields returnFields) throws IOException {
            SimpleOrderedMap outMap = new SimpleOrderedMap();
            CharsRefBuilder charsRef = new CharsRefBuilder();
            for (LongObjectCursor cursor : this.getGroups()) {
                long groupValue = cursor.key;
                DocSlice slice = this.collectorToDocSlice((Collector)cursor.value, searcher, returnFields);
                if (null == slice) continue;
                this.addGroupSliceToOutputMap((NamedList<DocSlice>)outMap, charsRef, groupValue, slice);
            }
            if (this.expandNullGroup) {
                assert (null != this.nullGroupCollector);
                DocSlice nullGroup = this.collectorToDocSlice(this.nullGroupCollector, searcher, returnFields);
                if (null != nullGroup) {
                    outMap.add(null, (Object)nullGroup);
                }
            }
            return outMap;
        }

        private DocSlice collectorToDocSlice(Collector groupCollector, SolrIndexSearcher searcher, ReturnFields returnFields) throws IOException {
            if (groupCollector instanceof TopDocsCollector) {
                TopDocsCollector topDocsCollector = (TopDocsCollector)TopDocsCollector.class.cast(groupCollector);
                TopDocs topDocs = topDocsCollector.topDocs();
                ScoreDoc[] scoreDocs = topDocs.scoreDocs;
                if (scoreDocs.length > 0) {
                    if (returnFields.wantsScore() && this.sort != null) {
                        TopFieldCollector.populateScores((ScoreDoc[])scoreDocs, (IndexSearcher)searcher, (Query)this.query);
                    }
                    int[] docs = new int[scoreDocs.length];
                    float[] scores = new float[scoreDocs.length];
                    for (int i = 0; i < docs.length; ++i) {
                        ScoreDoc scoreDoc = scoreDocs[i];
                        docs[i] = scoreDoc.doc;
                        scores[i] = scoreDoc.score;
                    }
                    assert (topDocs.totalHits.relation == TotalHits.Relation.EQUAL_TO);
                    return new DocSlice(0, docs.length, docs, scores, topDocs.totalHits.value, Float.NaN, TotalHits.Relation.EQUAL_TO);
                }
            } else {
                int totalHits = ((TotalHitCountCollector)groupCollector).getTotalHits();
                if (totalHits > 0) {
                    return new DocSlice(0, 0, null, null, totalHits, 0.0f, TotalHits.Relation.EQUAL_TO);
                }
            }
            return null;
        }

        private void addGroupSliceToOutputMap(NamedList<DocSlice> outMap, CharsRefBuilder charsRef, long groupValue, DocSlice slice) {
            if (this.fieldType instanceof StrField) {
                BytesRef bytesRef = (BytesRef)this.ordBytes.get((int)groupValue);
                this.fieldType.indexedToReadable(bytesRef, charsRef);
                String group = charsRef.toString();
                outMap.add(group, (Object)slice);
            } else {
                outMap.add(ExpandComponent.numericToString(this.fieldType, groupValue), (Object)slice);
            }
        }

        public ScoreMode scoreMode() {
            LongObjectMap<Collector> groups = this.getGroups();
            if (groups.isEmpty()) {
                return ScoreMode.COMPLETE;
            }
            return ((Collector)((LongObjectCursor)groups.iterator().next()).value).scoreMode();
        }

        protected final Collector getCollector() throws IOException {
            Object collector = this.limit == 0 ? new TotalHitCountCollector() : (this.sort == null ? TopScoreDocCollector.create((int)this.limit, (int)Integer.MAX_VALUE) : TopFieldCollector.create((Sort)this.sort, (int)this.limit, (int)Integer.MAX_VALUE));
            return collector;
        }
    }

    private static class NumericGroupExpandCollector
    extends GroupCollector {
        private final String field;
        private final LongObjectHashMap<Collector> groups;
        private final IntHashSet collapsedSet;

        public NumericGroupExpandCollector(int limit, Sort sort, Query query, boolean expandNulls, FieldType fieldType, IntObjectHashMap<BytesRef> ordBytes, String field, LongHashSet groupSet, IntHashSet collapsedSet) throws IOException {
            super(limit, sort, query, expandNulls, fieldType, ordBytes);
            this.groups = new LongObjectHashMap(groupSet.size());
            for (LongCursor cursor : groupSet) {
                this.groups.put(cursor.value, (Object)this.getCollector());
            }
            this.field = field;
            this.collapsedSet = collapsedSet;
        }

        public LeafCollector getLeafCollector(LeafReaderContext context) throws IOException {
            final int docBase = context.docBase;
            final NumericDocValues docValues = context.reader().getNumericDocValues(this.field);
            final LeafCollector leafNullGroupCollector = this.expandNullGroup ? this.nullGroupCollector.getLeafCollector(context) : null;
            final LongObjectHashMap leafCollectors = new LongObjectHashMap();
            for (LongObjectCursor entry : this.groups) {
                leafCollectors.put(entry.key, (Object)((Collector)entry.value).getLeafCollector(context));
            }
            return new LeafCollector(){

                public void setScorer(Scorable scorer) throws IOException {
                    for (ObjectCursor c : leafCollectors.values()) {
                        ((LeafCollector)c.value).setScorer(scorer);
                    }
                    if (expandNullGroup) {
                        leafNullGroupCollector.setScorer(scorer);
                    }
                }

                public void collect(int docId) throws IOException {
                    if (docValues.advanceExact(docId)) {
                        long value = docValues.longValue();
                        int index = leafCollectors.indexOf(value);
                        if (index >= 0 && !collapsedSet.contains(docId + docBase)) {
                            ((LeafCollector)leafCollectors.indexGet(index)).collect(docId);
                        }
                    } else if (expandNullGroup && !collapsedSet.contains(docId + docBase)) {
                        leafNullGroupCollector.collect(docId);
                    }
                }
            };
        }

        protected LongObjectHashMap<Collector> getGroups() {
            return this.groups;
        }
    }

    private static class GroupExpandCollector
    extends GroupCollector {
        private final SortedDocValues docValues;
        private final OrdinalMap ordinalMap;
        private final MultiDocValues.MultiSortedDocValues multiSortedDocValues;
        private final LongObjectMap<Collector> groups;
        private final FixedBitSet groupBits;
        private final IntHashSet collapsedSet;

        public GroupExpandCollector(int limit, Sort sort, Query query, boolean expandNulls, FieldType fieldType, IntObjectHashMap<BytesRef> ordBytes, SortedDocValues docValues, FixedBitSet groupBits, IntHashSet collapsedSet) throws IOException {
            super(limit, sort, query, expandNulls, fieldType, ordBytes);
            int group;
            this.groups = new LongObjectHashMap(collapsedSet.size());
            BitSetIterator iterator = new BitSetIterator((BitSet)groupBits, 0L);
            while ((group = iterator.nextDoc()) != Integer.MAX_VALUE) {
                this.groups.put((long)group, (Object)this.getCollector());
            }
            this.collapsedSet = collapsedSet;
            this.groupBits = groupBits;
            this.docValues = docValues;
            if (docValues instanceof MultiDocValues.MultiSortedDocValues) {
                this.multiSortedDocValues = (MultiDocValues.MultiSortedDocValues)docValues;
                this.ordinalMap = this.multiSortedDocValues.mapping;
            } else {
                this.multiSortedDocValues = null;
                this.ordinalMap = null;
            }
        }

        public LeafCollector getLeafCollector(LeafReaderContext context) throws IOException {
            int docBase = context.docBase;
            boolean useOrdinalMapping = null != this.ordinalMap;
            SortedDocValues segmentValues = useOrdinalMapping ? this.multiSortedDocValues.values[context.ord] : null;
            LongValues segmentOrdinalMap = useOrdinalMapping ? this.ordinalMap.getGlobalOrds(context.ord) : null;
            LeafCollector leafNullGroupCollector = this.expandNullGroup ? this.nullGroupCollector.getLeafCollector(context) : null;
            LongObjectHashMap leafCollectors = new LongObjectHashMap();
            for (LongObjectCursor entry : this.groups) {
                leafCollectors.put(entry.key, (Object)((Collector)entry.value).getLeafCollector(context));
            }
            return new LeafCollector((LongObjectMap)leafCollectors, leafNullGroupCollector, docBase, useOrdinalMapping, segmentValues, segmentOrdinalMap){
                final /* synthetic */ LongObjectMap val$leafCollectors;
                final /* synthetic */ LeafCollector val$leafNullGroupCollector;
                final /* synthetic */ int val$docBase;
                final /* synthetic */ boolean val$useOrdinalMapping;
                final /* synthetic */ SortedDocValues val$segmentValues;
                final /* synthetic */ LongValues val$segmentOrdinalMap;
                {
                    this.val$leafCollectors = longObjectMap;
                    this.val$leafNullGroupCollector = leafCollector;
                    this.val$docBase = n;
                    this.val$useOrdinalMapping = bl;
                    this.val$segmentValues = sortedDocValues;
                    this.val$segmentOrdinalMap = longValues;
                }

                public void setScorer(Scorable scorer) throws IOException {
                    for (ObjectCursor c : this.val$leafCollectors.values()) {
                        ((LeafCollector)c.value).setScorer(scorer);
                    }
                    if (expandNullGroup) {
                        this.val$leafNullGroupCollector.setScorer(scorer);
                    }
                }

                public void collect(int docId) throws IOException {
                    int globalDoc = docId + this.val$docBase;
                    if (collapsedSet.contains(globalDoc)) {
                        return;
                    }
                    int ord = -1;
                    if (this.val$useOrdinalMapping) {
                        if (docId > this.val$segmentValues.docID()) {
                            this.val$segmentValues.advance(docId);
                        }
                        ord = docId == this.val$segmentValues.docID() ? (int)this.val$segmentOrdinalMap.get((long)this.val$segmentValues.ordValue()) : -1;
                    } else {
                        ord = docValues.advanceExact(globalDoc) ? docValues.ordValue() : -1;
                    }
                    if (ord > -1) {
                        if (groupBits.get(ord)) {
                            LeafCollector c = (LeafCollector)this.val$leafCollectors.get((long)ord);
                            c.collect(docId);
                        }
                    } else if (expandNullGroup) {
                        this.val$leafNullGroupCollector.collect(docId);
                    }
                }
            };
        }

        @Override
        protected LongObjectMap<Collector> getGroups() {
            return this.groups;
        }
    }
}

