/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base;

import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.PatternCompiler;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.Platform$JdkPatternCompiler;
import java.util.Iterator;
import java.util.Locale;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

final class Platform {
    private static final Logger logger = Logger.getLogger(Platform.class.getName());
    private static final PatternCompiler patternCompiler = Platform.loadPatternCompiler();

    private Platform() {
    }

    static long systemNanoTime() {
        return System.nanoTime();
    }

    static String formatCompact4Digits(double d) {
        return String.format(Locale.ROOT, "%.4g", d);
    }

    static boolean stringIsNullOrEmpty(@NullableDecl String string) {
        return string == null || string.isEmpty();
    }

    static String nullToEmpty(@NullableDecl String string) {
        return string == null ? "" : string;
    }

    static String emptyToNull(@NullableDecl String string) {
        return Platform.stringIsNullOrEmpty(string) ? null : string;
    }

    private static PatternCompiler loadPatternCompiler() {
        ServiceLoader<PatternCompiler> serviceLoader = ServiceLoader.load(PatternCompiler.class);
        try {
            Iterator<PatternCompiler> iterator = serviceLoader.iterator();
            while (iterator.hasNext()) {
                try {
                    return iterator.next();
                }
                catch (ServiceConfigurationError serviceConfigurationError) {
                    Platform.logPatternCompilerError(serviceConfigurationError);
                }
            }
        }
        catch (ServiceConfigurationError serviceConfigurationError) {
            Platform.logPatternCompilerError(serviceConfigurationError);
        }
        return new Platform$JdkPatternCompiler(null);
    }

    private static void logPatternCompilerError(ServiceConfigurationError serviceConfigurationError) {
        logger.log(Level.WARNING, "Error loading regex compiler, falling back to next option", serviceConfigurationError);
    }
}

