/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.core;

import java.util.List;
import java.util.Objects;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.SingleRel;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexShuttle;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.Litmus;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class Snapshot
extends SingleRel {
    private final RexNode period;

    protected Snapshot(RelOptCluster cluster, RelTraitSet traitSet, RelNode input, RexNode period) {
        super(cluster, traitSet, input);
        this.period = Objects.requireNonNull(period, "period");
        assert (this.isValid(Litmus.THROW, null));
    }

    @Override
    public final RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        return this.copy(traitSet, Snapshot.sole(inputs), this.getPeriod());
    }

    public abstract Snapshot copy(RelTraitSet var1, RelNode var2, RexNode var3);

    @Override
    public RelNode accept(RexShuttle shuttle) {
        RexNode condition = shuttle.apply(this.period);
        if (this.period == condition) {
            return this;
        }
        return this.copy(this.traitSet, this.getInput(), condition);
    }

    @Override
    public RelWriter explainTerms(RelWriter pw) {
        return super.explainTerms(pw).item("period", this.period);
    }

    public RexNode getPeriod() {
        return this.period;
    }

    @Override
    public boolean isValid(Litmus litmus, @Nullable RelNode.Context context) {
        RelDataType dataType = this.period.getType();
        if (dataType.getSqlTypeName() != SqlTypeName.TIMESTAMP) {
            return litmus.fail("The system time period specification expects Timestamp type but is '" + (Object)((Object)dataType.getSqlTypeName()) + "'", new Object[0]);
        }
        return litmus.succeed();
    }
}

