/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.morfologik;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Objects;
import morfologik.stemming.Dictionary;
import morfologik.stemming.DictionaryMetadata;
import morfologik.stemming.polish.PolishStemmer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.morfologik.MorfologikFilter;
import org.apache.lucene.analysis.util.ResourceLoader;
import org.apache.lucene.analysis.util.ResourceLoaderAware;
import org.apache.lucene.analysis.util.TokenFilterFactory;

public class MorfologikFilterFactory
extends TokenFilterFactory
implements ResourceLoaderAware {
    public static final String NAME = "morfologik";
    public static final String DICTIONARY_ATTRIBUTE = "dictionary";
    private String resourceName;
    private Dictionary dictionary;

    public MorfologikFilterFactory(Map<String, String> args) {
        super(args);
        String DICTIONARY_RESOURCE_ATTRIBUTE = "dictionary-resource";
        String dictionaryResource = this.get(args, "dictionary-resource");
        if (dictionaryResource != null && !dictionaryResource.isEmpty()) {
            throw new IllegalArgumentException("The dictionary-resource attribute is no longer supported. Use the 'dictionary' attribute instead (see LUCENE-6833).");
        }
        this.resourceName = this.get(args, DICTIONARY_ATTRIBUTE);
        if (!args.isEmpty()) {
            throw new IllegalArgumentException("Unknown parameters: " + args);
        }
    }

    public void inform(ResourceLoader loader) throws IOException {
        if (this.resourceName == null) {
            this.dictionary = new PolishStemmer().getDictionary();
        } else {
            try (InputStream dict = loader.openResource(this.resourceName);
                 InputStream meta = loader.openResource(DictionaryMetadata.getExpectedMetadataFileName((String)this.resourceName));){
                this.dictionary = Dictionary.read((InputStream)dict, (InputStream)meta);
            }
        }
    }

    public TokenStream create(TokenStream ts) {
        return new MorfologikFilter(ts, Objects.requireNonNull(this.dictionary, "MorfologikFilterFactory was not fully initialized."));
    }
}

