/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.impl.io.BaseStorageFactory;
import org.apache.derby.io.StorageFile;
import org.apache.derby.io.StorageRandomAccessFile;

abstract class InputStreamFile
implements StorageFile {
    final String path;
    final int nameStart;
    final BaseStorageFactory storageFactory;

    InputStreamFile(BaseStorageFactory baseStorageFactory, String string) {
        this.storageFactory = baseStorageFactory;
        if (string == null || string.length() == 0) {
            this.path = baseStorageFactory.dataDirectory;
            this.nameStart = -1;
        } else {
            StringBuffer stringBuffer = new StringBuffer(baseStorageFactory.separatedDataDirectory);
            if (File.separatorChar != '/') {
                stringBuffer.append(string.replace(File.separatorChar, '/'));
            } else {
                stringBuffer.append(string);
            }
            this.path = stringBuffer.toString();
            this.nameStart = this.path.lastIndexOf(47) + 1;
        }
    }

    InputStreamFile(BaseStorageFactory baseStorageFactory, String string, String string2) {
        this.storageFactory = baseStorageFactory;
        StringBuffer stringBuffer = new StringBuffer(baseStorageFactory.separatedDataDirectory);
        if (File.separatorChar != '/') {
            stringBuffer.append(string.replace(File.separatorChar, '/'));
            stringBuffer.append('/');
            stringBuffer.append(string2.replace(File.separatorChar, '/'));
        } else {
            stringBuffer.append(string);
            stringBuffer.append('/');
            stringBuffer.append(string2);
        }
        this.path = stringBuffer.toString();
        this.nameStart = this.path.lastIndexOf(47) + 1;
    }

    InputStreamFile(InputStreamFile inputStreamFile, String string) {
        this.storageFactory = inputStreamFile.storageFactory;
        StringBuffer stringBuffer = new StringBuffer(inputStreamFile.path);
        stringBuffer.append('/');
        if (File.separatorChar != '/') {
            stringBuffer.append(string.replace(File.separatorChar, '/'));
        } else {
            stringBuffer.append(string);
        }
        this.path = stringBuffer.toString();
        this.nameStart = this.path.lastIndexOf(47) + 1;
    }

    InputStreamFile(BaseStorageFactory baseStorageFactory, String string, int n) {
        this.storageFactory = baseStorageFactory;
        this.path = string.substring(0, n);
        this.nameStart = this.path.lastIndexOf(47) + 1;
    }

    public boolean equals(Object object) {
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        InputStreamFile inputStreamFile = (InputStreamFile)object;
        return this.path.equals(inputStreamFile.path);
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    public String[] list() {
        return null;
    }

    public boolean canWrite() {
        return false;
    }

    public abstract boolean exists();

    public boolean isDirectory() {
        return false;
    }

    public boolean delete() {
        return false;
    }

    public boolean deleteAll() {
        return false;
    }

    public String getPath() {
        if (File.separatorChar != '/') {
            return this.path.replace('/', File.separatorChar);
        }
        return this.path;
    }

    public String getCanonicalPath() throws IOException {
        return this.storageFactory.getCanonicalName() + "/" + this.path;
    }

    public String getName() {
        return this.nameStart < 0 ? "" : this.path.substring(this.nameStart);
    }

    public boolean createNewFile() throws IOException {
        throw new IOException("createNewFile called in a read-only file system.");
    }

    public boolean renameTo(StorageFile storageFile) {
        return false;
    }

    public boolean mkdir() {
        return false;
    }

    public boolean mkdirs() {
        return false;
    }

    public long length() {
        try {
            InputStream inputStream = this.getInputStream();
            if (inputStream == null) {
                return 0L;
            }
            long l = inputStream.available();
            inputStream.close();
            return l;
        }
        catch (IOException iOException) {
            return 0L;
        }
    }

    public StorageFile getParentDir() {
        if (this.path.length() <= this.storageFactory.separatedDataDirectory.length()) {
            return null;
        }
        return this.getParentDir(this.path.lastIndexOf(47));
    }

    abstract StorageFile getParentDir(int var1);

    public boolean setReadOnly() {
        return true;
    }

    public OutputStream getOutputStream() throws FileNotFoundException {
        throw new FileNotFoundException("Attempt to write into a read only file system.");
    }

    public OutputStream getOutputStream(boolean bl) throws FileNotFoundException {
        throw new FileNotFoundException("Attempt to write into a read only file system.");
    }

    public abstract InputStream getInputStream() throws FileNotFoundException;

    public int getExclusiveFileLock() throws StandardException {
        return 0;
    }

    public void releaseExclusiveFileLock() {
    }

    public StorageRandomAccessFile getRandomAccessFile(String string) throws FileNotFoundException {
        return null;
    }

    public String toString() {
        return this.path;
    }

    public URL getURL() throws MalformedURLException {
        throw new MalformedURLException(this.toString());
    }

    public void limitAccessToOwner() {
    }
}

