/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.schema;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.queries.function.docvalues.DocTermsIndexDocValues;
import org.apache.lucene.queries.function.valuesource.FieldCacheSource;

public class StrFieldSource
extends FieldCacheSource {
    private static int hcode = StrFieldSource.class.hashCode();

    public StrFieldSource(String field) {
        super(field);
    }

    public String description() {
        return "str(" + this.field + ')';
    }

    public FunctionValues getValues(Map context, LeafReaderContext readerContext) throws IOException {
        return new DocTermsIndexDocValues((ValueSource)this, readerContext, this.field){

            protected String toTerm(String readableValue) {
                return readableValue;
            }

            public int ordVal(int doc) throws IOException {
                return this.getOrdForDoc(doc);
            }

            public int numOrd() {
                return this.termsIndex.getValueCount();
            }

            public Object objectVal(int doc) throws IOException {
                return this.strVal(doc);
            }

            public String toString(int doc) throws IOException {
                return StrFieldSource.this.description() + '=' + this.strVal(doc);
            }
        };
    }

    public boolean equals(Object o) {
        return o instanceof StrFieldSource && super.equals(o);
    }

    public int hashCode() {
        return hcode + super.hashCode();
    }
}

