# -*- coding: utf-8 -*-
#---------------------------------------------------------------------------
# Copyright 2020 VMware, Inc.  All rights reserved.

# AUTO GENERATED FILE -- DO NOT MODIFY!
#
# vAPI stub file for package com.vmware.nsx_policy.infra.tier_1s.locale_services.l2vpn_services.sessions.
#---------------------------------------------------------------------------

"""


"""

__author__ = 'VMware, Inc.'
__docformat__ = 'restructuredtext en'

import sys

from vmware.vapi.bindings import type
from vmware.vapi.bindings.converter import TypeConverter
from vmware.vapi.bindings.enum import Enum
from vmware.vapi.bindings.error import VapiError
from vmware.vapi.bindings.struct import VapiStruct
from vmware.vapi.bindings.stub import (
    ApiInterfaceStub, StubFactoryBase, VapiInterface)
from vmware.vapi.bindings.common import raise_core_exception
from vmware.vapi.data.validator import (UnionValidator, HasFieldsOfValidator)
from vmware.vapi.exception import CoreException
from vmware.vapi.lib.constants import TaskType
from vmware.vapi.lib.rest import OperationRestMetadata


class DetailedStatus(VapiInterface):
    """
    
    """
    GET_SOURCE_REALTIME = "realtime"
    """
    Possible value for ``source`` of method :func:`DetailedStatus.get`.

    """
    GET_SOURCE_CACHED = "cached"
    """
    Possible value for ``source`` of method :func:`DetailedStatus.get`.

    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.tier_1s.locale_services.l2vpn_services.sessions.detailed_status'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _DetailedStatusStub)
        self._VAPI_OPERATION_IDS = {}


    def get(self,
            tier1_id,
            locale_service_id,
            service_id,
            session_id,
            enforcement_point_path=None,
            source=None,
            ):
        """
        - no enforcement point path specified: detailed tatus is evaluated on
        each enforcement point. - an enforcement point path is specified:
        detailed status is evaluated only on the given enforcement point. -
        source=realtime: detailed tatus is fetched realtime from the
        enforcement point. - source=cached: cached detailed status is returned.

        :type  tier1_id: :class:`str`
        :param tier1_id: (required)
        :type  locale_service_id: :class:`str`
        :param locale_service_id: (required)
        :type  service_id: :class:`str`
        :param service_id: (required)
        :type  session_id: :class:`str`
        :param session_id: (required)
        :type  enforcement_point_path: :class:`str` or ``None``
        :param enforcement_point_path: String Path of the enforcement point (optional)
        :type  source: :class:`str` or ``None``
        :param source: Data source type. (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.AggregateL2VPNSessionStatus`
        :return: com.vmware.nsx_policy.model.AggregateL2VPNSessionStatus
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('get',
                            {
                            'tier1_id': tier1_id,
                            'locale_service_id': locale_service_id,
                            'service_id': service_id,
                            'session_id': session_id,
                            'enforcement_point_path': enforcement_point_path,
                            'source': source,
                            })
class PeerConfig(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.tier_1s.locale_services.l2vpn_services.sessions.peer_config'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _PeerConfigStub)
        self._VAPI_OPERATION_IDS = {}


    def get(self,
            tier1_id,
            locale_service_id,
            service_id,
            session_id,
            enforcement_point_path=None,
            ):
        """
        Get peer config for the Tier-1 L2VPN session to configure the remote
        side of the tunnel. - no enforcement point path specified: L2VPN
        Session Peer Codes will be evaluated on each enforcement point. -
        enforcement point paths specified: L2VPN Session Peer Codes are
        evaluated only on the given enforcement points. API supported only when
        L2VPN Service is in Server Mode.

        :type  tier1_id: :class:`str`
        :param tier1_id: (required)
        :type  locale_service_id: :class:`str`
        :param locale_service_id: (required)
        :type  service_id: :class:`str`
        :param service_id: (required)
        :type  session_id: :class:`str`
        :param session_id: (required)
        :type  enforcement_point_path: :class:`str` or ``None``
        :param enforcement_point_path: String Path of the enforcement point (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.AggregateL2VPNSessionPeerConfig`
        :return: com.vmware.nsx_policy.model.AggregateL2VPNSessionPeerConfig
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('get',
                            {
                            'tier1_id': tier1_id,
                            'locale_service_id': locale_service_id,
                            'service_id': service_id,
                            'session_id': session_id,
                            'enforcement_point_path': enforcement_point_path,
                            })
class RemoteMac(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.tier_1s.locale_services.l2vpn_services.sessions.remote_mac'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _RemoteMacStub)
        self._VAPI_OPERATION_IDS = {}


    def get(self,
            tier1_id,
            locale_service_id,
            service_id,
            session_id,
            enforcement_point_path=None,
            segment_path=None,
            ):
        """
        Returns L2Vpn session remote macs for a logical switch. Data is fetched
        from enforcement point.

        :type  tier1_id: :class:`str`
        :param tier1_id: (required)
        :type  locale_service_id: :class:`str`
        :param locale_service_id: (required)
        :type  service_id: :class:`str`
        :param service_id: (required)
        :type  session_id: :class:`str`
        :param session_id: (required)
        :type  enforcement_point_path: :class:`str` or ``None``
        :param enforcement_point_path: String Path of the enforcement point (optional)
        :type  segment_path: :class:`str` or ``None``
        :param segment_path: Segment Path (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.AggregateL2VpnSessionRemoteMac`
        :return: com.vmware.nsx_policy.model.AggregateL2VpnSessionRemoteMac
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('get',
                            {
                            'tier1_id': tier1_id,
                            'locale_service_id': locale_service_id,
                            'service_id': service_id,
                            'session_id': session_id,
                            'enforcement_point_path': enforcement_point_path,
                            'segment_path': segment_path,
                            })
class Statistics(VapiInterface):
    """
    
    """
    GET_SOURCE_REALTIME = "realtime"
    """
    Possible value for ``source`` of method :func:`Statistics.get`.

    """
    GET_SOURCE_CACHED = "cached"
    """
    Possible value for ``source`` of method :func:`Statistics.get`.

    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.tier_1s.locale_services.l2vpn_services.sessions.statistics'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _StatisticsStub)
        self._VAPI_OPERATION_IDS = {}


    def get(self,
            tier1_id,
            locale_service_id,
            service_id,
            session_id,
            enforcement_point_path=None,
            source=None,
            ):
        """
        - no enforcement point path specified: statistics are evaluated on each
        enforcement point. - an enforcement point path is specified: statistics
        are evaluated only on the given enforcement point. - source=realtime:
        statistics are fetched realtime from the enforcement point. -
        source=cached: cached statistics from the enforcement point are
        returned.

        :type  tier1_id: :class:`str`
        :param tier1_id: (required)
        :type  locale_service_id: :class:`str`
        :param locale_service_id: (required)
        :type  service_id: :class:`str`
        :param service_id: (required)
        :type  session_id: :class:`str`
        :param session_id: (required)
        :type  enforcement_point_path: :class:`str` or ``None``
        :param enforcement_point_path: String Path of the enforcement point (optional)
        :type  source: :class:`str` or ``None``
        :param source: Data source type. (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.AggregateL2VPNSessionStatistics`
        :return: com.vmware.nsx_policy.model.AggregateL2VPNSessionStatistics
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('get',
                            {
                            'tier1_id': tier1_id,
                            'locale_service_id': locale_service_id,
                            'service_id': service_id,
                            'session_id': session_id,
                            'enforcement_point_path': enforcement_point_path,
                            'source': source,
                            })
class _DetailedStatusStub(ApiInterfaceStub):
    def __init__(self, config):
        # properties for get operation
        get_input_type = type.StructType('operation-input', {
            'tier1_id': type.StringType(),
            'locale_service_id': type.StringType(),
            'service_id': type.StringType(),
            'session_id': type.StringType(),
            'enforcement_point_path': type.OptionalType(type.StringType()),
            'source': type.OptionalType(type.StringType()),
        })
        get_error_dict = {
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        get_input_value_validator_list = [
        ]
        get_output_validator_list = [
            HasFieldsOfValidator()
        ]
        get_rest_metadata = OperationRestMetadata(
            http_method='GET',
            url_template='/policy/api/v1/infra/tier-1s/{tier-1-id}/locale-services/{locale-service-id}/l2vpn-services/{service-id}/sessions/{session-id}/detailed-status',
            path_variables={
                'tier1_id': 'tier-1-id',
                'locale_service_id': 'locale-service-id',
                'service_id': 'service-id',
                'session_id': 'session-id',
            },
            query_parameters={
                'enforcement_point_path': 'enforcement_point_path',
                'source': 'source',
            },
            content_type='application/json'
        )

        operations = {
            'get': {
                'input_type': get_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx_policy.model_client', 'AggregateL2VPNSessionStatus'),
                'errors': get_error_dict,
                'input_value_validator_list': get_input_value_validator_list,
                'output_validator_list': get_output_validator_list,
                'task_type': TaskType.NONE,
            },
        }
        rest_metadata = {
            'get': get_rest_metadata,
        }
        ApiInterfaceStub.__init__(
            self, iface_name='com.vmware.nsx_policy.infra.tier_1s.locale_services.l2vpn_services.sessions.detailed_status',
            config=config, operations=operations, rest_metadata=rest_metadata,
            is_vapi_rest=False)

class _PeerConfigStub(ApiInterfaceStub):
    def __init__(self, config):
        # properties for get operation
        get_input_type = type.StructType('operation-input', {
            'tier1_id': type.StringType(),
            'locale_service_id': type.StringType(),
            'service_id': type.StringType(),
            'session_id': type.StringType(),
            'enforcement_point_path': type.OptionalType(type.StringType()),
        })
        get_error_dict = {
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        get_input_value_validator_list = [
        ]
        get_output_validator_list = [
            HasFieldsOfValidator()
        ]
        get_rest_metadata = OperationRestMetadata(
            http_method='GET',
            url_template='/policy/api/v1/infra/tier-1s/{tier-1-id}/locale-services/{locale-service-id}/l2vpn-services/{service-id}/sessions/{session-id}/peer-config',
            path_variables={
                'tier1_id': 'tier-1-id',
                'locale_service_id': 'locale-service-id',
                'service_id': 'service-id',
                'session_id': 'session-id',
            },
            query_parameters={
                'enforcement_point_path': 'enforcement_point_path',
            },
            content_type='application/json'
        )

        operations = {
            'get': {
                'input_type': get_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx_policy.model_client', 'AggregateL2VPNSessionPeerConfig'),
                'errors': get_error_dict,
                'input_value_validator_list': get_input_value_validator_list,
                'output_validator_list': get_output_validator_list,
                'task_type': TaskType.NONE,
            },
        }
        rest_metadata = {
            'get': get_rest_metadata,
        }
        ApiInterfaceStub.__init__(
            self, iface_name='com.vmware.nsx_policy.infra.tier_1s.locale_services.l2vpn_services.sessions.peer_config',
            config=config, operations=operations, rest_metadata=rest_metadata,
            is_vapi_rest=False)

class _RemoteMacStub(ApiInterfaceStub):
    def __init__(self, config):
        # properties for get operation
        get_input_type = type.StructType('operation-input', {
            'tier1_id': type.StringType(),
            'locale_service_id': type.StringType(),
            'service_id': type.StringType(),
            'session_id': type.StringType(),
            'enforcement_point_path': type.OptionalType(type.StringType()),
            'segment_path': type.OptionalType(type.StringType()),
        })
        get_error_dict = {
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        get_input_value_validator_list = [
        ]
        get_output_validator_list = [
            HasFieldsOfValidator()
        ]
        get_rest_metadata = OperationRestMetadata(
            http_method='GET',
            url_template='/policy/api/v1/infra/tier-1s/{tier-1-id}/locale-services/{locale-service-id}/l2vpn-services/{service-id}/sessions/{session-id}/remote-mac',
            path_variables={
                'tier1_id': 'tier-1-id',
                'locale_service_id': 'locale-service-id',
                'service_id': 'service-id',
                'session_id': 'session-id',
            },
            query_parameters={
                'enforcement_point_path': 'enforcement_point_path',
                'segment_path': 'segment_path',
            },
            content_type='application/json'
        )

        operations = {
            'get': {
                'input_type': get_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx_policy.model_client', 'AggregateL2VpnSessionRemoteMac'),
                'errors': get_error_dict,
                'input_value_validator_list': get_input_value_validator_list,
                'output_validator_list': get_output_validator_list,
                'task_type': TaskType.NONE,
            },
        }
        rest_metadata = {
            'get': get_rest_metadata,
        }
        ApiInterfaceStub.__init__(
            self, iface_name='com.vmware.nsx_policy.infra.tier_1s.locale_services.l2vpn_services.sessions.remote_mac',
            config=config, operations=operations, rest_metadata=rest_metadata,
            is_vapi_rest=False)

class _StatisticsStub(ApiInterfaceStub):
    def __init__(self, config):
        # properties for get operation
        get_input_type = type.StructType('operation-input', {
            'tier1_id': type.StringType(),
            'locale_service_id': type.StringType(),
            'service_id': type.StringType(),
            'session_id': type.StringType(),
            'enforcement_point_path': type.OptionalType(type.StringType()),
            'source': type.OptionalType(type.StringType()),
        })
        get_error_dict = {
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        get_input_value_validator_list = [
        ]
        get_output_validator_list = [
            HasFieldsOfValidator()
        ]
        get_rest_metadata = OperationRestMetadata(
            http_method='GET',
            url_template='/policy/api/v1/infra/tier-1s/{tier-1-id}/locale-services/{locale-service-id}/l2vpn-services/{service-id}/sessions/{session-id}/statistics',
            path_variables={
                'tier1_id': 'tier-1-id',
                'locale_service_id': 'locale-service-id',
                'service_id': 'service-id',
                'session_id': 'session-id',
            },
            query_parameters={
                'enforcement_point_path': 'enforcement_point_path',
                'source': 'source',
            },
            content_type='application/json'
        )

        operations = {
            'get': {
                'input_type': get_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx_policy.model_client', 'AggregateL2VPNSessionStatistics'),
                'errors': get_error_dict,
                'input_value_validator_list': get_input_value_validator_list,
                'output_validator_list': get_output_validator_list,
                'task_type': TaskType.NONE,
            },
        }
        rest_metadata = {
            'get': get_rest_metadata,
        }
        ApiInterfaceStub.__init__(
            self, iface_name='com.vmware.nsx_policy.infra.tier_1s.locale_services.l2vpn_services.sessions.statistics',
            config=config, operations=operations, rest_metadata=rest_metadata,
            is_vapi_rest=False)


class StubFactory(StubFactoryBase):
    _attrs = {
        'DetailedStatus': DetailedStatus,
        'PeerConfig': PeerConfig,
        'RemoteMac': RemoteMac,
        'Statistics': Statistics,
    }

