(declare (block) (standard-bindings) (extended-bindings))
(begin
  (define std/format#format
    (lambda (_fmt2930_ . _args2931_)
      (if (string? _fmt2930_)
          '#!void
          (error '"Expected format string" _fmt2930_))
      (let ((_out2933_ (open-output-string)))
        (std/format#dofmt _out2933_ _fmt2930_ _args2931_)
        (get-output-string _out2933_))))
  (define std/format#printf
    (lambda (_fmt2927_ . _args2928_)
      (apply std/format#fprintf (current-output-port) _fmt2927_ _args2928_)))
  (define std/format#fprintf
    (lambda (_port2923_ _fmt2924_ . _args2925_)
      (if (output-port? _port2923_)
          '#!void
          (error '"Expected output port" _port2923_))
      (if (string? _fmt2924_)
          '#!void
          (error '"Expected format string" _fmt2924_))
      (std/format#dofmt _port2923_ _fmt2924_ _args2925_)))
  (define std/format#eprintf
    (lambda (_fmt2920_ . _args2921_)
      (apply std/format#fprintf (current-error-port) _fmt2920_ _args2921_)
      (force-output (current-error-port))))
  (define std/format#dofmt
    (lambda (_port2895_ _fmt2896_ _args2897_)
      (letrec* ((_len2899_
                 (let () (declare (not safe)) (##string-length _fmt2896_))))
        (call-with-parameters
         (lambda ()
           (let _K2902_ ((_xi2904_ '0) (_rest2905_ _args2897_))
             (if (let () (declare (not safe)) (##fx< _xi2904_ _len2899_))
                 (let ((_next2907_
                        (let ()
                          (declare (not safe))
                          (##string-ref _fmt2896_ _xi2904_)))
                       (_xi2908_
                        (let () (declare (not safe)) (##fx+ _xi2904_ '1))))
                   (if (eq? _next2907_ '#\~)
                       (if (let ()
                             (declare (not safe))
                             (##fx< _xi2908_ _len2899_))
                           (let ((_next2910_
                                  (let ()
                                    (declare (not safe))
                                    (##string-ref _fmt2896_ _xi2908_)))
                                 (_xi2911_
                                  (let ()
                                    (declare (not safe))
                                    (##fx+ _xi2908_ '1))))
                             (let ((_$e2913_
                                    (table-ref
                                     std/format#dispatch-table
                                     _next2910_
                                     '#f)))
                               (if _$e2913_
                                   ((lambda (_g29152917_)
                                      (_g29152917_
                                       _next2910_
                                       _K2902_
                                       _xi2911_
                                       _rest2905_))
                                    _$e2913_)
                                   (error '"Unknown format specifier"
                                          _fmt2896_
                                          _next2910_))))
                           (error '"Bad format string" _fmt2896_))
                       (begin
                         (write-char _next2907_)
                         (_K2902_ _xi2908_ _rest2905_))))
                 (if (null? _rest2905_)
                     '#!void
                     (error '"Too many arguments for format string"
                            _fmt2896_
                            _args2897_)))))
         current-output-port
         _port2895_
         std/format#current-format-string
         _fmt2896_
         std/format#current-format-args
         _args2897_))))
  (define std/format#current-format-string (make-parameter '#f))
  (define std/format#current-format-args (make-parameter '#f))
  (define std/format#dispatch-table (make-table 'test: eq?))
  (table-set!
   std/format#dispatch-table
   '#\a
   (lambda (_g6532_ _K2858_ _xi2859_ _rest2860_)
     (let* ((_rest28612869_ _rest2860_)
            (_else28632877_
             (lambda ()
               (error '"Missing format argument"
                      (std/format#current-format-string)
                      (std/format#current-format-args))))
            (_K28652883_
             (lambda (_rest2880_ _arg2881_)
               (display _arg2881_)
               (_K2858_ _xi2859_ _rest2880_))))
       (if (let () (declare (not safe)) (##pair? _rest28612869_))
           (let ((_hd28662886_
                  (let () (declare (not safe)) (##car _rest28612869_)))
                 (_tl28672888_
                  (let () (declare (not safe)) (##cdr _rest28612869_))))
             (let* ((_arg2891_ _hd28662886_) (_rest2893_ _tl28672888_))
               (_K28652883_ _rest2893_ _arg2891_)))
           (_else28632877_)))))
  (table-set!
   std/format#dispatch-table
   '#\A
   (lambda (_g6533_ _K2817_ _xi2819_ _rest2821_)
     (let* ((_rest28232831_ _rest2821_)
            (_else28252839_
             (lambda ()
               (error '"Missing format argument"
                      (std/format#current-format-string)
                      (std/format#current-format-args))))
            (_K28272846_
             (lambda (_rest2842_ _arg2843_)
               (display _arg2843_)
               (_K2817_ _xi2819_ _rest2842_))))
       (if (let () (declare (not safe)) (##pair? _rest28232831_))
           (let ((_hd28282849_
                  (let () (declare (not safe)) (##car _rest28232831_)))
                 (_tl28292851_
                  (let () (declare (not safe)) (##cdr _rest28232831_))))
             (let* ((_arg2854_ _hd28282849_) (_rest2856_ _tl28292851_))
               (_K28272846_ _rest2856_ _arg2854_)))
           (_else28252839_)))))
  (table-set!
   std/format#dispatch-table
   '#\s
   (lambda (_g6534_ _K2780_ _xi2781_ _rest2782_)
     (let* ((_rest27832791_ _rest2782_)
            (_else27852799_
             (lambda ()
               (error '"Missing format argument"
                      (std/format#current-format-string)
                      (std/format#current-format-args))))
            (_K27872805_
             (lambda (_rest2802_ _arg2803_)
               (write _arg2803_)
               (_K2780_ _xi2781_ _rest2802_))))
       (if (let () (declare (not safe)) (##pair? _rest27832791_))
           (let ((_hd27882808_
                  (let () (declare (not safe)) (##car _rest27832791_)))
                 (_tl27892810_
                  (let () (declare (not safe)) (##cdr _rest27832791_))))
             (let* ((_arg2813_ _hd27882808_) (_rest2815_ _tl27892810_))
               (_K27872805_ _rest2815_ _arg2813_)))
           (_else27852799_)))))
  (table-set!
   std/format#dispatch-table
   '#\S
   (lambda (_g6535_ _K2739_ _xi2741_ _rest2743_)
     (let* ((_rest27452753_ _rest2743_)
            (_else27472761_
             (lambda ()
               (error '"Missing format argument"
                      (std/format#current-format-string)
                      (std/format#current-format-args))))
            (_K27492768_
             (lambda (_rest2764_ _arg2765_)
               (write _arg2765_)
               (_K2739_ _xi2741_ _rest2764_))))
       (if (let () (declare (not safe)) (##pair? _rest27452753_))
           (let ((_hd27502771_
                  (let () (declare (not safe)) (##car _rest27452753_)))
                 (_tl27512773_
                  (let () (declare (not safe)) (##cdr _rest27452753_))))
             (let* ((_arg2776_ _hd27502771_) (_rest2778_ _tl27512773_))
               (_K27492768_ _rest2778_ _arg2776_)))
           (_else27472761_)))))
  (table-set!
   std/format#dispatch-table
   '#\c
   (lambda (_g6536_ _K2702_ _xi2703_ _rest2704_)
     (let* ((_rest27052713_ _rest2704_)
            (_else27072721_
             (lambda ()
               (error '"Missing format argument"
                      (std/format#current-format-string)
                      (std/format#current-format-args))))
            (_K27092727_
             (lambda (_rest2724_ _arg2725_)
               (write-char _arg2725_)
               (_K2702_ _xi2703_ _rest2724_))))
       (if (let () (declare (not safe)) (##pair? _rest27052713_))
           (let ((_hd27102730_
                  (let () (declare (not safe)) (##car _rest27052713_)))
                 (_tl27112732_
                  (let () (declare (not safe)) (##cdr _rest27052713_))))
             (let* ((_arg2735_ _hd27102730_) (_rest2737_ _tl27112732_))
               (_K27092727_ _rest2737_ _arg2735_)))
           (_else27072721_)))))
  (table-set!
   std/format#dispatch-table
   '#\C
   (lambda (_g6537_ _K2661_ _xi2663_ _rest2665_)
     (let* ((_rest26672675_ _rest2665_)
            (_else26692683_
             (lambda ()
               (error '"Missing format argument"
                      (std/format#current-format-string)
                      (std/format#current-format-args))))
            (_K26712690_
             (lambda (_rest2686_ _arg2687_)
               (write-char _arg2687_)
               (_K2661_ _xi2663_ _rest2686_))))
       (if (let () (declare (not safe)) (##pair? _rest26672675_))
           (let ((_hd26722693_
                  (let () (declare (not safe)) (##car _rest26672675_)))
                 (_tl26732695_
                  (let () (declare (not safe)) (##cdr _rest26672675_))))
             (let* ((_arg2698_ _hd26722693_) (_rest2700_ _tl26732695_))
               (_K26712690_ _rest2700_ _arg2698_)))
           (_else26692683_)))))
  (table-set!
   std/format#dispatch-table
   '#\u
   (lambda (_g6538_ _K2620_ _xi2621_ _rest2622_)
     (let* ((_rest26232631_ _rest2622_)
            (_else26252639_
             (lambda ()
               (error '"Missing format argument"
                      (std/format#current-format-string)
                      (std/format#current-format-args))))
            (_K26272649_
             (lambda (_rest2642_ _arg2643_)
               ((lambda (_arg2645_)
                  (let ((_i2647_ (char->integer _arg2645_)))
                    (if (let () (declare (not safe)) (##fx< _i2647_ '15))
                        (display '"000")
                        (if (let () (declare (not safe)) (##fx< _i2647_ '255))
                            (display '"00")
                            (if (let ()
                                  (declare (not safe))
                                  (##fx< _i2647_ '4095))
                                (display '"0")
                                '#!void)))
                    (display (number->string _i2647_ '16))))
                _arg2643_)
               (_K2620_ _xi2621_ _rest2642_))))
       (if (let () (declare (not safe)) (##pair? _rest26232631_))
           (let ((_hd26282652_
                  (let () (declare (not safe)) (##car _rest26232631_)))
                 (_tl26292654_
                  (let () (declare (not safe)) (##cdr _rest26232631_))))
             (let* ((_arg2657_ _hd26282652_) (_rest2659_ _tl26292654_))
               (_K26272649_ _rest2659_ _arg2657_)))
           (_else26252639_)))))
  (table-set!
   std/format#dispatch-table
   '#\U
   (lambda (_g6539_ _K2575_ _xi2577_ _rest2579_)
     (let* ((_rest25812589_ _rest2579_)
            (_else25832597_
             (lambda ()
               (error '"Missing format argument"
                      (std/format#current-format-string)
                      (std/format#current-format-args))))
            (_K25852608_
             (lambda (_rest2600_ _arg2601_)
               ((lambda (_arg2604_)
                  (let ((_i2606_ (char->integer _arg2604_)))
                    (if (let () (declare (not safe)) (##fx< _i2606_ '15))
                        (display '"000")
                        (if (let () (declare (not safe)) (##fx< _i2606_ '255))
                            (display '"00")
                            (if (let ()
                                  (declare (not safe))
                                  (##fx< _i2606_ '4095))
                                (display '"0")
                                '#!void)))
                    (display (number->string _i2606_ '16))))
                _arg2601_)
               (_K2575_ _xi2577_ _rest2600_))))
       (if (let () (declare (not safe)) (##pair? _rest25812589_))
           (let ((_hd25862611_
                  (let () (declare (not safe)) (##car _rest25812589_)))
                 (_tl25872613_
                  (let () (declare (not safe)) (##cdr _rest25812589_))))
             (let* ((_arg2616_ _hd25862611_) (_rest2618_ _tl25872613_))
               (_K25852608_ _rest2618_ _arg2616_)))
           (_else25832597_)))))
  (table-set!
   std/format#dispatch-table
   '#\b
   (lambda (_g6540_ _K2536_ _xi2537_ _rest2538_)
     (let* ((_rest25392547_ _rest2538_)
            (_else25412555_
             (lambda ()
               (error '"Missing format argument"
                      (std/format#current-format-string)
                      (std/format#current-format-args))))
            (_K25432563_
             (lambda (_rest2558_ _arg2559_)
               ((lambda (_arg2561_) (display (number->string _arg2561_ '2)))
                _arg2559_)
               (_K2536_ _xi2537_ _rest2558_))))
       (if (let () (declare (not safe)) (##pair? _rest25392547_))
           (let ((_hd25442566_
                  (let () (declare (not safe)) (##car _rest25392547_)))
                 (_tl25452568_
                  (let () (declare (not safe)) (##cdr _rest25392547_))))
             (let* ((_arg2571_ _hd25442566_) (_rest2573_ _tl25452568_))
               (_K25432563_ _rest2573_ _arg2571_)))
           (_else25412555_)))))
  (table-set!
   std/format#dispatch-table
   '#\B
   (lambda (_g6541_ _K2493_ _xi2495_ _rest2497_)
     (let* ((_rest24992507_ _rest2497_)
            (_else25012515_
             (lambda ()
               (error '"Missing format argument"
                      (std/format#current-format-string)
                      (std/format#current-format-args))))
            (_K25032524_
             (lambda (_rest2518_ _arg2519_)
               ((lambda (_arg2522_) (display (number->string _arg2522_ '2)))
                _arg2519_)
               (_K2493_ _xi2495_ _rest2518_))))
       (if (let () (declare (not safe)) (##pair? _rest24992507_))
           (let ((_hd25042527_
                  (let () (declare (not safe)) (##car _rest24992507_)))
                 (_tl25052529_
                  (let () (declare (not safe)) (##cdr _rest24992507_))))
             (let* ((_arg2532_ _hd25042527_) (_rest2534_ _tl25052529_))
               (_K25032524_ _rest2534_ _arg2532_)))
           (_else25012515_)))))
  (table-set!
   std/format#dispatch-table
   '#\o
   (lambda (_g6542_ _K2454_ _xi2455_ _rest2456_)
     (let* ((_rest24572465_ _rest2456_)
            (_else24592473_
             (lambda ()
               (error '"Missing format argument"
                      (std/format#current-format-string)
                      (std/format#current-format-args))))
            (_K24612481_
             (lambda (_rest2476_ _arg2477_)
               ((lambda (_arg2479_) (display (number->string _arg2479_ '8)))
                _arg2477_)
               (_K2454_ _xi2455_ _rest2476_))))
       (if (let () (declare (not safe)) (##pair? _rest24572465_))
           (let ((_hd24622484_
                  (let () (declare (not safe)) (##car _rest24572465_)))
                 (_tl24632486_
                  (let () (declare (not safe)) (##cdr _rest24572465_))))
             (let* ((_arg2489_ _hd24622484_) (_rest2491_ _tl24632486_))
               (_K24612481_ _rest2491_ _arg2489_)))
           (_else24592473_)))))
  (table-set!
   std/format#dispatch-table
   '#\O
   (lambda (_g6543_ _K2411_ _xi2413_ _rest2415_)
     (let* ((_rest24172425_ _rest2415_)
            (_else24192433_
             (lambda ()
               (error '"Missing format argument"
                      (std/format#current-format-string)
                      (std/format#current-format-args))))
            (_K24212442_
             (lambda (_rest2436_ _arg2437_)
               ((lambda (_arg2440_) (display (number->string _arg2440_ '8)))
                _arg2437_)
               (_K2411_ _xi2413_ _rest2436_))))
       (if (let () (declare (not safe)) (##pair? _rest24172425_))
           (let ((_hd24222445_
                  (let () (declare (not safe)) (##car _rest24172425_)))
                 (_tl24232447_
                  (let () (declare (not safe)) (##cdr _rest24172425_))))
             (let* ((_arg2450_ _hd24222445_) (_rest2452_ _tl24232447_))
               (_K24212442_ _rest2452_ _arg2450_)))
           (_else24192433_)))))
  (table-set!
   std/format#dispatch-table
   '#\d
   (lambda (_g6544_ _K2372_ _xi2373_ _rest2374_)
     (let* ((_rest23752383_ _rest2374_)
            (_else23772391_
             (lambda ()
               (error '"Missing format argument"
                      (std/format#current-format-string)
                      (std/format#current-format-args))))
            (_K23792399_
             (lambda (_rest2394_ _arg2395_)
               ((lambda (_arg2397_) (display (number->string _arg2397_ '10)))
                _arg2395_)
               (_K2372_ _xi2373_ _rest2394_))))
       (if (let () (declare (not safe)) (##pair? _rest23752383_))
           (let ((_hd23802402_
                  (let () (declare (not safe)) (##car _rest23752383_)))
                 (_tl23812404_
                  (let () (declare (not safe)) (##cdr _rest23752383_))))
             (let* ((_arg2407_ _hd23802402_) (_rest2409_ _tl23812404_))
               (_K23792399_ _rest2409_ _arg2407_)))
           (_else23772391_)))))
  (table-set!
   std/format#dispatch-table
   '#\D
   (lambda (_g6545_ _K2329_ _xi2331_ _rest2333_)
     (let* ((_rest23352343_ _rest2333_)
            (_else23372351_
             (lambda ()
               (error '"Missing format argument"
                      (std/format#current-format-string)
                      (std/format#current-format-args))))
            (_K23392360_
             (lambda (_rest2354_ _arg2355_)
               ((lambda (_arg2358_) (display (number->string _arg2358_ '10)))
                _arg2355_)
               (_K2329_ _xi2331_ _rest2354_))))
       (if (let () (declare (not safe)) (##pair? _rest23352343_))
           (let ((_hd23402363_
                  (let () (declare (not safe)) (##car _rest23352343_)))
                 (_tl23412365_
                  (let () (declare (not safe)) (##cdr _rest23352343_))))
             (let* ((_arg2368_ _hd23402363_) (_rest2370_ _tl23412365_))
               (_K23392360_ _rest2370_ _arg2368_)))
           (_else23372351_)))))
  (table-set!
   std/format#dispatch-table
   '#\x
   (lambda (_g6546_ _K2287_ _xi2288_ _rest2289_)
     (let* ((_rest22902298_ _rest2289_)
            (_else22922306_
             (lambda ()
               (error '"Missing format argument"
                      (std/format#current-format-string)
                      (std/format#current-format-args))))
            (_K22942317_
             (lambda (_rest2309_ _arg2310_)
               ((lambda (_arg2312_)
                  (let ((_str2314_ (number->string _arg2312_ '16))
                        (_nbytes2315_
                         (ceiling (/ (integer-length _arg2312_) '8))))
                    (if (zero? _nbytes2315_)
                        (display '"00")
                        (display (std/format#pad-string__%
                                  _str2314_
                                  (* '2 _nbytes2315_)
                                  '#\0)))))
                _arg2310_)
               (_K2287_ _xi2288_ _rest2309_))))
       (if (let () (declare (not safe)) (##pair? _rest22902298_))
           (let ((_hd22952320_
                  (let () (declare (not safe)) (##car _rest22902298_)))
                 (_tl22962322_
                  (let () (declare (not safe)) (##cdr _rest22902298_))))
             (let* ((_arg2325_ _hd22952320_) (_rest2327_ _tl22962322_))
               (_K22942317_ _rest2327_ _arg2325_)))
           (_else22922306_)))))
  (table-set!
   std/format#dispatch-table
   '#\X
   (lambda (_g6547_ _K2241_ _xi2243_ _rest2245_)
     (let* ((_rest22472255_ _rest2245_)
            (_else22492263_
             (lambda ()
               (error '"Missing format argument"
                      (std/format#current-format-string)
                      (std/format#current-format-args))))
            (_K22512275_
             (lambda (_rest2266_ _arg2267_)
               ((lambda (_arg2270_)
                  (let ((_str2272_ (number->string _arg2270_ '16))
                        (_nbytes2273_
                         (ceiling (/ (integer-length _arg2270_) '8))))
                    (if (zero? _nbytes2273_)
                        (display '"00")
                        (display (std/format#pad-string__%
                                  _str2272_
                                  (* '2 _nbytes2273_)
                                  '#\0)))))
                _arg2267_)
               (_K2241_ _xi2243_ _rest2266_))))
       (if (let () (declare (not safe)) (##pair? _rest22472255_))
           (let ((_hd22522278_
                  (let () (declare (not safe)) (##car _rest22472255_)))
                 (_tl22532280_
                  (let () (declare (not safe)) (##cdr _rest22472255_))))
             (let* ((_arg2283_ _hd22522278_) (_rest2285_ _tl22532280_))
               (_K22512275_ _rest2285_ _arg2283_)))
           (_else22492263_)))))
  (table-set!
   std/format#dispatch-table
   '#\y
   (lambda (_g6548_ _K2204_ _xi2205_ _rest2206_)
     (let* ((_rest22072215_ _rest2206_)
            (_else22092223_
             (lambda ()
               (error '"Missing format argument"
                      (std/format#current-format-string)
                      (std/format#current-format-args))))
            (_K22112229_
             (lambda (_rest2226_ _arg2227_)
               (pretty-print _arg2227_)
               (_K2204_ _xi2205_ _rest2226_))))
       (if (let () (declare (not safe)) (##pair? _rest22072215_))
           (let ((_hd22122232_
                  (let () (declare (not safe)) (##car _rest22072215_)))
                 (_tl22132234_
                  (let () (declare (not safe)) (##cdr _rest22072215_))))
             (let* ((_arg2237_ _hd22122232_) (_rest2239_ _tl22132234_))
               (_K22112229_ _rest2239_ _arg2237_)))
           (_else22092223_)))))
  (table-set!
   std/format#dispatch-table
   '#\Y
   (lambda (_g6549_ _K2163_ _xi2165_ _rest2167_)
     (let* ((_rest21692177_ _rest2167_)
            (_else21712185_
             (lambda ()
               (error '"Missing format argument"
                      (std/format#current-format-string)
                      (std/format#current-format-args))))
            (_K21732192_
             (lambda (_rest2188_ _arg2189_)
               (pretty-print _arg2189_)
               (_K2163_ _xi2165_ _rest2188_))))
       (if (let () (declare (not safe)) (##pair? _rest21692177_))
           (let ((_hd21742195_
                  (let () (declare (not safe)) (##car _rest21692177_)))
                 (_tl21752197_
                  (let () (declare (not safe)) (##cdr _rest21692177_))))
             (let* ((_arg2200_ _hd21742195_) (_rest2202_ _tl21752197_))
               (_K21732192_ _rest2202_ _arg2200_)))
           (_else21712185_)))))
  (table-set!
   std/format#dispatch-table
   '#\r
   (lambda (_g6550_ _K2126_ _xi2127_ _rest2128_)
     (let* ((_rest21292137_ _rest2128_)
            (_else21312145_
             (lambda ()
               (error '"Missing format argument"
                      (std/format#current-format-string)
                      (std/format#current-format-args))))
            (_K21332151_
             (lambda (_rest2148_ _arg2149_)
               (std/misc/repr#print-representation__0 _arg2149_)
               (_K2126_ _xi2127_ _rest2148_))))
       (if (let () (declare (not safe)) (##pair? _rest21292137_))
           (let ((_hd21342154_
                  (let () (declare (not safe)) (##car _rest21292137_)))
                 (_tl21352156_
                  (let () (declare (not safe)) (##cdr _rest21292137_))))
             (let* ((_arg2159_ _hd21342154_) (_rest2161_ _tl21352156_))
               (_K21332151_ _rest2161_ _arg2159_)))
           (_else21312145_)))))
  (table-set!
   std/format#dispatch-table
   '#\R
   (lambda (_g6551_ _K2085_ _xi2087_ _rest2089_)
     (let* ((_rest20912099_ _rest2089_)
            (_else20932107_
             (lambda ()
               (error '"Missing format argument"
                      (std/format#current-format-string)
                      (std/format#current-format-args))))
            (_K20952114_
             (lambda (_rest2110_ _arg2111_)
               (std/misc/repr#print-representation__0 _arg2111_)
               (_K2085_ _xi2087_ _rest2110_))))
       (if (let () (declare (not safe)) (##pair? _rest20912099_))
           (let ((_hd20962117_
                  (let () (declare (not safe)) (##car _rest20912099_)))
                 (_tl20972119_
                  (let () (declare (not safe)) (##cdr _rest20912099_))))
             (let* ((_arg2122_ _hd20962117_) (_rest2124_ _tl20972119_))
               (_K20952114_ _rest2124_ _arg2122_)))
           (_else20932107_)))))
  (table-set!
   std/format#dispatch-table
   '#\%
   (lambda (_g6552_ _K2081_ _xi2082_ _rest2083_)
     (newline)
     (_K2081_ _xi2082_ _rest2083_)))
  (table-set!
   std/format#dispatch-table
   '#\n
   (lambda (_g6553_ _K2074_ _xi2076_ _rest2078_)
     (newline)
     (_K2074_ _xi2076_ _rest2078_)))
  (table-set!
   std/format#dispatch-table
   '#\~
   (lambda (_g6554_ _K2067_ _xi2069_ _rest2071_)
     (write-char '#\~)
     (_K2067_ _xi2069_ _rest2071_)))
  (table-set!
   std/format#dispatch-table
   '#\t
   (lambda (_g6555_ _K2063_ _xi2064_ _rest2065_)
     (write-char '#\tab)
     (_K2063_ _xi2064_ _rest2065_)))
  (table-set!
   std/format#dispatch-table
   '#\T
   (lambda (_g6556_ _K2056_ _xi2058_ _rest2060_)
     (write-char '#\tab)
     (_K2056_ _xi2058_ _rest2060_)))
  (table-set!
   std/format#dispatch-table
   '#\_
   (lambda (_g6557_ _K2049_ _xi2051_ _rest2053_)
     (write-char '#\space)
     (_K2049_ _xi2051_ _rest2053_)))
  (table-set!
   std/format#dispatch-table
   '#\?
   (lambda (_g6558_ _K2002_ _xi2003_ _rest2004_)
     (let* ((_rest20052015_ _rest2004_)
            (_else20072023_
             (lambda ()
               (error '"Missing format argument"
                      (std/format#current-format-string)
                      (std/format#current-format-args))))
            (_K20092030_
             (lambda (_rest2026_ _re-args2027_ _re-fmt2028_)
               (display (apply std/format#format _re-fmt2028_ _re-args2027_))
               (_K2002_ _xi2003_ _rest2026_))))
       (if (let () (declare (not safe)) (##pair? _rest20052015_))
           (let ((_hd20102033_
                  (let () (declare (not safe)) (##car _rest20052015_)))
                 (_tl20112035_
                  (let () (declare (not safe)) (##cdr _rest20052015_))))
             (let ((_re-fmt2038_ _hd20102033_))
               (if (let () (declare (not safe)) (##pair? _tl20112035_))
                   (let ((_hd20122040_
                          (let () (declare (not safe)) (##car _tl20112035_)))
                         (_tl20132042_
                          (let () (declare (not safe)) (##cdr _tl20112035_))))
                     (let* ((_re-args2045_ _hd20122040_)
                            (_rest2047_ _tl20132042_))
                       (_K20092030_ _rest2047_ _re-args2045_ _re-fmt2038_)))
                   (_else20072023_))))
           (_else20072023_)))))
  (table-set!
   std/format#dispatch-table
   '#\k
   (lambda (_g6559_ _K1955_ _xi1956_ _rest1957_)
     (let* ((_rest19581968_ _rest1957_)
            (_else19601976_
             (lambda ()
               (error '"Missing format argument"
                      (std/format#current-format-string)
                      (std/format#current-format-args))))
            (_K19621983_
             (lambda (_rest1979_ _re-args1980_ _re-fmt1981_)
               (display (apply std/format#format _re-fmt1981_ _re-args1980_))
               (_K1955_ _xi1956_ _rest1979_))))
       (if (let () (declare (not safe)) (##pair? _rest19581968_))
           (let ((_hd19631986_
                  (let () (declare (not safe)) (##car _rest19581968_)))
                 (_tl19641988_
                  (let () (declare (not safe)) (##cdr _rest19581968_))))
             (let ((_re-fmt1991_ _hd19631986_))
               (if (let () (declare (not safe)) (##pair? _tl19641988_))
                   (let ((_hd19651993_
                          (let () (declare (not safe)) (##car _tl19641988_)))
                         (_tl19661995_
                          (let () (declare (not safe)) (##cdr _tl19641988_))))
                     (let* ((_re-args1998_ _hd19651993_)
                            (_rest2000_ _tl19661995_))
                       (_K19621983_ _rest2000_ _re-args1998_ _re-fmt1991_)))
                   (_else19601976_))))
           (_else19601976_)))))
  (table-set!
   std/format#dispatch-table
   '#\K
   (lambda (_g6560_ _K1908_ _xi1909_ _rest1910_)
     (let* ((_rest19111921_ _rest1910_)
            (_else19131929_
             (lambda ()
               (error '"Missing format argument"
                      (std/format#current-format-string)
                      (std/format#current-format-args))))
            (_K19151936_
             (lambda (_rest1932_ _re-args1933_ _re-fmt1934_)
               (display (apply std/format#format _re-fmt1934_ _re-args1933_))
               (_K1908_ _xi1909_ _rest1932_))))
       (if (let () (declare (not safe)) (##pair? _rest19111921_))
           (let ((_hd19161939_
                  (let () (declare (not safe)) (##car _rest19111921_)))
                 (_tl19171941_
                  (let () (declare (not safe)) (##cdr _rest19111921_))))
             (let ((_re-fmt1944_ _hd19161939_))
               (if (let () (declare (not safe)) (##pair? _tl19171941_))
                   (let ((_hd19181946_
                          (let () (declare (not safe)) (##car _tl19171941_)))
                         (_tl19191948_
                          (let () (declare (not safe)) (##cdr _tl19171941_))))
                     (let* ((_re-args1951_ _hd19181946_)
                            (_rest1953_ _tl19191948_))
                       (_K19151936_ _rest1953_ _re-args1951_ _re-fmt1944_)))
                   (_else19131929_))))
           (_else19131929_)))))
  (table-set!
   std/format#dispatch-table
   '#\f
   (lambda (_g6561_ _K1904_ _xi1905_ _rest1906_)
     (std/format#format-fixed-float '#f '#f _K1904_ _xi1905_ _rest1906_)))
  (table-set!
   std/format#dispatch-table
   '#\F
   (lambda (_g6562_ _K1900_ _xi1901_ _rest1902_)
     (std/format#format-fixed-float '#f '#f _K1900_ _xi1901_ _rest1902_)))
  (table-set!
   std/format#dispatch-table
   '#\0
   (lambda (_char1817_ _K1818_ _xi1819_ _rest1820_)
     (let* ((_str1822_ (std/format#current-format-string))
            (_len1824_
             (let () (declare (not safe)) (##string-length _str1822_))))
       (let _lp1873_ ((_xi1875_ _xi1819_) (_width1876_ (cons _char1817_ '())))
         (if (let () (declare (not safe)) (##fx< _xi1875_ _len1824_))
             (let ((_next1878_
                    (let ()
                      (declare (not safe))
                      (##string-ref _str1822_ _xi1875_)))
                   (_xi1879_
                    (let () (declare (not safe)) (##fx+ _xi1875_ '1))))
               (let ((_$e1881_ _next1878_))
                 (if (or (eq? '#\f _$e1881_) (eq? '#\F _$e1881_))
                     (std/format#format-fixed-float
                      (std/format#chars->number (reverse _width1876_))
                      '#f
                      _K1818_
                      _xi1879_
                      _rest1820_)
                     (if (eq? '#\, _$e1881_)
                         (let _lp21887_ ((_xi1889_ _xi1879_)
                                         (_digits1890_ '()))
                           (if (let ()
                                 (declare (not safe))
                                 (##fx< _xi1889_ _len1824_))
                               (let ((_next1892_
                                      (let ()
                                        (declare (not safe))
                                        (##string-ref _str1822_ _xi1889_)))
                                     (_xi1893_
                                      (let ()
                                        (declare (not safe))
                                        (##fx+ _xi1889_ '1))))
                                 (if (char-numeric? _next1892_)
                                     (_lp21887_
                                      _xi1893_
                                      (cons _next1892_ _digits1890_))
                                     (if (and (memq _next1892_ '(#\f #\F))
                                              (not (null? _digits1890_)))
                                         (std/format#format-fixed-float
                                          (std/format#chars->number
                                           (reverse _width1876_))
                                          (std/format#chars->number
                                           (reverse _digits1890_))
                                          _K1818_
                                          _xi1893_
                                          _rest1820_)
                                         (error '"Bad format string; malformed fixed width specifier"
                                                _str1822_
                                                (std/format#current-format-args)))))
                               (error '"Bad format string; malformed fixed width specifier"
                                      _str1822_
                                      (std/format#current-format-args))))
                         (if (char-numeric? _next1878_)
                             (_lp1873_ _xi1879_ (cons _next1878_ _width1876_))
                             (let ((_$e1895_
                                    (table-ref
                                     std/format#dispatch-table
                                     _next1878_
                                     '#f)))
                               (if _$e1895_
                                   ((lambda (_f1898_)
                                      (std/format#format-fixed-generic
                                       (std/format#chars->number
                                        (reverse _width1876_))
                                       _f1898_
                                       _next1878_
                                       _xi1879_
                                       _rest1820_
                                       _K1818_))
                                    _$e1895_)
                                   (error '"Unknown format specifier"
                                          _str1822_
                                          _next1878_))))))))
             (error '"Bad format string; malformed fixed width specifier"
                    _str1822_
                    (std/format#current-format-args)))))))
  (table-set!
   std/format#dispatch-table
   '#\1
   (lambda (_char1734_ _K1735_ _xi1736_ _rest1737_)
     (let* ((_str1739_ (std/format#current-format-string))
            (_len1741_
             (let () (declare (not safe)) (##string-length _str1739_))))
       (let _lp1790_ ((_xi1792_ _xi1736_) (_width1793_ (cons _char1734_ '())))
         (if (let () (declare (not safe)) (##fx< _xi1792_ _len1741_))
             (let ((_next1795_
                    (let ()
                      (declare (not safe))
                      (##string-ref _str1739_ _xi1792_)))
                   (_xi1796_
                    (let () (declare (not safe)) (##fx+ _xi1792_ '1))))
               (let ((_$e1798_ _next1795_))
                 (if (or (eq? '#\f _$e1798_) (eq? '#\F _$e1798_))
                     (std/format#format-fixed-float
                      (std/format#chars->number (reverse _width1793_))
                      '#f
                      _K1735_
                      _xi1796_
                      _rest1737_)
                     (if (eq? '#\, _$e1798_)
                         (let _lp21804_ ((_xi1806_ _xi1796_)
                                         (_digits1807_ '()))
                           (if (let ()
                                 (declare (not safe))
                                 (##fx< _xi1806_ _len1741_))
                               (let ((_next1809_
                                      (let ()
                                        (declare (not safe))
                                        (##string-ref _str1739_ _xi1806_)))
                                     (_xi1810_
                                      (let ()
                                        (declare (not safe))
                                        (##fx+ _xi1806_ '1))))
                                 (if (char-numeric? _next1809_)
                                     (_lp21804_
                                      _xi1810_
                                      (cons _next1809_ _digits1807_))
                                     (if (and (memq _next1809_ '(#\f #\F))
                                              (not (null? _digits1807_)))
                                         (std/format#format-fixed-float
                                          (std/format#chars->number
                                           (reverse _width1793_))
                                          (std/format#chars->number
                                           (reverse _digits1807_))
                                          _K1735_
                                          _xi1810_
                                          _rest1737_)
                                         (error '"Bad format string; malformed fixed width specifier"
                                                _str1739_
                                                (std/format#current-format-args)))))
                               (error '"Bad format string; malformed fixed width specifier"
                                      _str1739_
                                      (std/format#current-format-args))))
                         (if (char-numeric? _next1795_)
                             (_lp1790_ _xi1796_ (cons _next1795_ _width1793_))
                             (let ((_$e1812_
                                    (table-ref
                                     std/format#dispatch-table
                                     _next1795_
                                     '#f)))
                               (if _$e1812_
                                   ((lambda (_f1815_)
                                      (std/format#format-fixed-generic
                                       (std/format#chars->number
                                        (reverse _width1793_))
                                       _f1815_
                                       _next1795_
                                       _xi1796_
                                       _rest1737_
                                       _K1735_))
                                    _$e1812_)
                                   (error '"Unknown format specifier"
                                          _str1739_
                                          _next1795_))))))))
             (error '"Bad format string; malformed fixed width specifier"
                    _str1739_
                    (std/format#current-format-args)))))))
  (table-set!
   std/format#dispatch-table
   '#\2
   (lambda (_char1651_ _K1652_ _xi1653_ _rest1654_)
     (let* ((_str1656_ (std/format#current-format-string))
            (_len1658_
             (let () (declare (not safe)) (##string-length _str1656_))))
       (let _lp1707_ ((_xi1709_ _xi1653_) (_width1710_ (cons _char1651_ '())))
         (if (let () (declare (not safe)) (##fx< _xi1709_ _len1658_))
             (let ((_next1712_
                    (let ()
                      (declare (not safe))
                      (##string-ref _str1656_ _xi1709_)))
                   (_xi1713_
                    (let () (declare (not safe)) (##fx+ _xi1709_ '1))))
               (let ((_$e1715_ _next1712_))
                 (if (or (eq? '#\f _$e1715_) (eq? '#\F _$e1715_))
                     (std/format#format-fixed-float
                      (std/format#chars->number (reverse _width1710_))
                      '#f
                      _K1652_
                      _xi1713_
                      _rest1654_)
                     (if (eq? '#\, _$e1715_)
                         (let _lp21721_ ((_xi1723_ _xi1713_)
                                         (_digits1724_ '()))
                           (if (let ()
                                 (declare (not safe))
                                 (##fx< _xi1723_ _len1658_))
                               (let ((_next1726_
                                      (let ()
                                        (declare (not safe))
                                        (##string-ref _str1656_ _xi1723_)))
                                     (_xi1727_
                                      (let ()
                                        (declare (not safe))
                                        (##fx+ _xi1723_ '1))))
                                 (if (char-numeric? _next1726_)
                                     (_lp21721_
                                      _xi1727_
                                      (cons _next1726_ _digits1724_))
                                     (if (and (memq _next1726_ '(#\f #\F))
                                              (not (null? _digits1724_)))
                                         (std/format#format-fixed-float
                                          (std/format#chars->number
                                           (reverse _width1710_))
                                          (std/format#chars->number
                                           (reverse _digits1724_))
                                          _K1652_
                                          _xi1727_
                                          _rest1654_)
                                         (error '"Bad format string; malformed fixed width specifier"
                                                _str1656_
                                                (std/format#current-format-args)))))
                               (error '"Bad format string; malformed fixed width specifier"
                                      _str1656_
                                      (std/format#current-format-args))))
                         (if (char-numeric? _next1712_)
                             (_lp1707_ _xi1713_ (cons _next1712_ _width1710_))
                             (let ((_$e1729_
                                    (table-ref
                                     std/format#dispatch-table
                                     _next1712_
                                     '#f)))
                               (if _$e1729_
                                   ((lambda (_f1732_)
                                      (std/format#format-fixed-generic
                                       (std/format#chars->number
                                        (reverse _width1710_))
                                       _f1732_
                                       _next1712_
                                       _xi1713_
                                       _rest1654_
                                       _K1652_))
                                    _$e1729_)
                                   (error '"Unknown format specifier"
                                          _str1656_
                                          _next1712_))))))))
             (error '"Bad format string; malformed fixed width specifier"
                    _str1656_
                    (std/format#current-format-args)))))))
  (table-set!
   std/format#dispatch-table
   '#\3
   (lambda (_char1568_ _K1569_ _xi1570_ _rest1571_)
     (let* ((_str1573_ (std/format#current-format-string))
            (_len1575_
             (let () (declare (not safe)) (##string-length _str1573_))))
       (let _lp1624_ ((_xi1626_ _xi1570_) (_width1627_ (cons _char1568_ '())))
         (if (let () (declare (not safe)) (##fx< _xi1626_ _len1575_))
             (let ((_next1629_
                    (let ()
                      (declare (not safe))
                      (##string-ref _str1573_ _xi1626_)))
                   (_xi1630_
                    (let () (declare (not safe)) (##fx+ _xi1626_ '1))))
               (let ((_$e1632_ _next1629_))
                 (if (or (eq? '#\f _$e1632_) (eq? '#\F _$e1632_))
                     (std/format#format-fixed-float
                      (std/format#chars->number (reverse _width1627_))
                      '#f
                      _K1569_
                      _xi1630_
                      _rest1571_)
                     (if (eq? '#\, _$e1632_)
                         (let _lp21638_ ((_xi1640_ _xi1630_)
                                         (_digits1641_ '()))
                           (if (let ()
                                 (declare (not safe))
                                 (##fx< _xi1640_ _len1575_))
                               (let ((_next1643_
                                      (let ()
                                        (declare (not safe))
                                        (##string-ref _str1573_ _xi1640_)))
                                     (_xi1644_
                                      (let ()
                                        (declare (not safe))
                                        (##fx+ _xi1640_ '1))))
                                 (if (char-numeric? _next1643_)
                                     (_lp21638_
                                      _xi1644_
                                      (cons _next1643_ _digits1641_))
                                     (if (and (memq _next1643_ '(#\f #\F))
                                              (not (null? _digits1641_)))
                                         (std/format#format-fixed-float
                                          (std/format#chars->number
                                           (reverse _width1627_))
                                          (std/format#chars->number
                                           (reverse _digits1641_))
                                          _K1569_
                                          _xi1644_
                                          _rest1571_)
                                         (error '"Bad format string; malformed fixed width specifier"
                                                _str1573_
                                                (std/format#current-format-args)))))
                               (error '"Bad format string; malformed fixed width specifier"
                                      _str1573_
                                      (std/format#current-format-args))))
                         (if (char-numeric? _next1629_)
                             (_lp1624_ _xi1630_ (cons _next1629_ _width1627_))
                             (let ((_$e1646_
                                    (table-ref
                                     std/format#dispatch-table
                                     _next1629_
                                     '#f)))
                               (if _$e1646_
                                   ((lambda (_f1649_)
                                      (std/format#format-fixed-generic
                                       (std/format#chars->number
                                        (reverse _width1627_))
                                       _f1649_
                                       _next1629_
                                       _xi1630_
                                       _rest1571_
                                       _K1569_))
                                    _$e1646_)
                                   (error '"Unknown format specifier"
                                          _str1573_
                                          _next1629_))))))))
             (error '"Bad format string; malformed fixed width specifier"
                    _str1573_
                    (std/format#current-format-args)))))))
  (table-set!
   std/format#dispatch-table
   '#\4
   (lambda (_char1485_ _K1486_ _xi1487_ _rest1488_)
     (let* ((_str1490_ (std/format#current-format-string))
            (_len1492_
             (let () (declare (not safe)) (##string-length _str1490_))))
       (let _lp1541_ ((_xi1543_ _xi1487_) (_width1544_ (cons _char1485_ '())))
         (if (let () (declare (not safe)) (##fx< _xi1543_ _len1492_))
             (let ((_next1546_
                    (let ()
                      (declare (not safe))
                      (##string-ref _str1490_ _xi1543_)))
                   (_xi1547_
                    (let () (declare (not safe)) (##fx+ _xi1543_ '1))))
               (let ((_$e1549_ _next1546_))
                 (if (or (eq? '#\f _$e1549_) (eq? '#\F _$e1549_))
                     (std/format#format-fixed-float
                      (std/format#chars->number (reverse _width1544_))
                      '#f
                      _K1486_
                      _xi1547_
                      _rest1488_)
                     (if (eq? '#\, _$e1549_)
                         (let _lp21555_ ((_xi1557_ _xi1547_)
                                         (_digits1558_ '()))
                           (if (let ()
                                 (declare (not safe))
                                 (##fx< _xi1557_ _len1492_))
                               (let ((_next1560_
                                      (let ()
                                        (declare (not safe))
                                        (##string-ref _str1490_ _xi1557_)))
                                     (_xi1561_
                                      (let ()
                                        (declare (not safe))
                                        (##fx+ _xi1557_ '1))))
                                 (if (char-numeric? _next1560_)
                                     (_lp21555_
                                      _xi1561_
                                      (cons _next1560_ _digits1558_))
                                     (if (and (memq _next1560_ '(#\f #\F))
                                              (not (null? _digits1558_)))
                                         (std/format#format-fixed-float
                                          (std/format#chars->number
                                           (reverse _width1544_))
                                          (std/format#chars->number
                                           (reverse _digits1558_))
                                          _K1486_
                                          _xi1561_
                                          _rest1488_)
                                         (error '"Bad format string; malformed fixed width specifier"
                                                _str1490_
                                                (std/format#current-format-args)))))
                               (error '"Bad format string; malformed fixed width specifier"
                                      _str1490_
                                      (std/format#current-format-args))))
                         (if (char-numeric? _next1546_)
                             (_lp1541_ _xi1547_ (cons _next1546_ _width1544_))
                             (let ((_$e1563_
                                    (table-ref
                                     std/format#dispatch-table
                                     _next1546_
                                     '#f)))
                               (if _$e1563_
                                   ((lambda (_f1566_)
                                      (std/format#format-fixed-generic
                                       (std/format#chars->number
                                        (reverse _width1544_))
                                       _f1566_
                                       _next1546_
                                       _xi1547_
                                       _rest1488_
                                       _K1486_))
                                    _$e1563_)
                                   (error '"Unknown format specifier"
                                          _str1490_
                                          _next1546_))))))))
             (error '"Bad format string; malformed fixed width specifier"
                    _str1490_
                    (std/format#current-format-args)))))))
  (table-set!
   std/format#dispatch-table
   '#\5
   (lambda (_char1402_ _K1403_ _xi1404_ _rest1405_)
     (let* ((_str1407_ (std/format#current-format-string))
            (_len1409_
             (let () (declare (not safe)) (##string-length _str1407_))))
       (let _lp1458_ ((_xi1460_ _xi1404_) (_width1461_ (cons _char1402_ '())))
         (if (let () (declare (not safe)) (##fx< _xi1460_ _len1409_))
             (let ((_next1463_
                    (let ()
                      (declare (not safe))
                      (##string-ref _str1407_ _xi1460_)))
                   (_xi1464_
                    (let () (declare (not safe)) (##fx+ _xi1460_ '1))))
               (let ((_$e1466_ _next1463_))
                 (if (or (eq? '#\f _$e1466_) (eq? '#\F _$e1466_))
                     (std/format#format-fixed-float
                      (std/format#chars->number (reverse _width1461_))
                      '#f
                      _K1403_
                      _xi1464_
                      _rest1405_)
                     (if (eq? '#\, _$e1466_)
                         (let _lp21472_ ((_xi1474_ _xi1464_)
                                         (_digits1475_ '()))
                           (if (let ()
                                 (declare (not safe))
                                 (##fx< _xi1474_ _len1409_))
                               (let ((_next1477_
                                      (let ()
                                        (declare (not safe))
                                        (##string-ref _str1407_ _xi1474_)))
                                     (_xi1478_
                                      (let ()
                                        (declare (not safe))
                                        (##fx+ _xi1474_ '1))))
                                 (if (char-numeric? _next1477_)
                                     (_lp21472_
                                      _xi1478_
                                      (cons _next1477_ _digits1475_))
                                     (if (and (memq _next1477_ '(#\f #\F))
                                              (not (null? _digits1475_)))
                                         (std/format#format-fixed-float
                                          (std/format#chars->number
                                           (reverse _width1461_))
                                          (std/format#chars->number
                                           (reverse _digits1475_))
                                          _K1403_
                                          _xi1478_
                                          _rest1405_)
                                         (error '"Bad format string; malformed fixed width specifier"
                                                _str1407_
                                                (std/format#current-format-args)))))
                               (error '"Bad format string; malformed fixed width specifier"
                                      _str1407_
                                      (std/format#current-format-args))))
                         (if (char-numeric? _next1463_)
                             (_lp1458_ _xi1464_ (cons _next1463_ _width1461_))
                             (let ((_$e1480_
                                    (table-ref
                                     std/format#dispatch-table
                                     _next1463_
                                     '#f)))
                               (if _$e1480_
                                   ((lambda (_f1483_)
                                      (std/format#format-fixed-generic
                                       (std/format#chars->number
                                        (reverse _width1461_))
                                       _f1483_
                                       _next1463_
                                       _xi1464_
                                       _rest1405_
                                       _K1403_))
                                    _$e1480_)
                                   (error '"Unknown format specifier"
                                          _str1407_
                                          _next1463_))))))))
             (error '"Bad format string; malformed fixed width specifier"
                    _str1407_
                    (std/format#current-format-args)))))))
  (table-set!
   std/format#dispatch-table
   '#\6
   (lambda (_char1319_ _K1320_ _xi1321_ _rest1322_)
     (let* ((_str1324_ (std/format#current-format-string))
            (_len1326_
             (let () (declare (not safe)) (##string-length _str1324_))))
       (let _lp1375_ ((_xi1377_ _xi1321_) (_width1378_ (cons _char1319_ '())))
         (if (let () (declare (not safe)) (##fx< _xi1377_ _len1326_))
             (let ((_next1380_
                    (let ()
                      (declare (not safe))
                      (##string-ref _str1324_ _xi1377_)))
                   (_xi1381_
                    (let () (declare (not safe)) (##fx+ _xi1377_ '1))))
               (let ((_$e1383_ _next1380_))
                 (if (or (eq? '#\f _$e1383_) (eq? '#\F _$e1383_))
                     (std/format#format-fixed-float
                      (std/format#chars->number (reverse _width1378_))
                      '#f
                      _K1320_
                      _xi1381_
                      _rest1322_)
                     (if (eq? '#\, _$e1383_)
                         (let _lp21389_ ((_xi1391_ _xi1381_)
                                         (_digits1392_ '()))
                           (if (let ()
                                 (declare (not safe))
                                 (##fx< _xi1391_ _len1326_))
                               (let ((_next1394_
                                      (let ()
                                        (declare (not safe))
                                        (##string-ref _str1324_ _xi1391_)))
                                     (_xi1395_
                                      (let ()
                                        (declare (not safe))
                                        (##fx+ _xi1391_ '1))))
                                 (if (char-numeric? _next1394_)
                                     (_lp21389_
                                      _xi1395_
                                      (cons _next1394_ _digits1392_))
                                     (if (and (memq _next1394_ '(#\f #\F))
                                              (not (null? _digits1392_)))
                                         (std/format#format-fixed-float
                                          (std/format#chars->number
                                           (reverse _width1378_))
                                          (std/format#chars->number
                                           (reverse _digits1392_))
                                          _K1320_
                                          _xi1395_
                                          _rest1322_)
                                         (error '"Bad format string; malformed fixed width specifier"
                                                _str1324_
                                                (std/format#current-format-args)))))
                               (error '"Bad format string; malformed fixed width specifier"
                                      _str1324_
                                      (std/format#current-format-args))))
                         (if (char-numeric? _next1380_)
                             (_lp1375_ _xi1381_ (cons _next1380_ _width1378_))
                             (let ((_$e1397_
                                    (table-ref
                                     std/format#dispatch-table
                                     _next1380_
                                     '#f)))
                               (if _$e1397_
                                   ((lambda (_f1400_)
                                      (std/format#format-fixed-generic
                                       (std/format#chars->number
                                        (reverse _width1378_))
                                       _f1400_
                                       _next1380_
                                       _xi1381_
                                       _rest1322_
                                       _K1320_))
                                    _$e1397_)
                                   (error '"Unknown format specifier"
                                          _str1324_
                                          _next1380_))))))))
             (error '"Bad format string; malformed fixed width specifier"
                    _str1324_
                    (std/format#current-format-args)))))))
  (table-set!
   std/format#dispatch-table
   '#\7
   (lambda (_char1236_ _K1237_ _xi1238_ _rest1239_)
     (let* ((_str1241_ (std/format#current-format-string))
            (_len1243_
             (let () (declare (not safe)) (##string-length _str1241_))))
       (let _lp1292_ ((_xi1294_ _xi1238_) (_width1295_ (cons _char1236_ '())))
         (if (let () (declare (not safe)) (##fx< _xi1294_ _len1243_))
             (let ((_next1297_
                    (let ()
                      (declare (not safe))
                      (##string-ref _str1241_ _xi1294_)))
                   (_xi1298_
                    (let () (declare (not safe)) (##fx+ _xi1294_ '1))))
               (let ((_$e1300_ _next1297_))
                 (if (or (eq? '#\f _$e1300_) (eq? '#\F _$e1300_))
                     (std/format#format-fixed-float
                      (std/format#chars->number (reverse _width1295_))
                      '#f
                      _K1237_
                      _xi1298_
                      _rest1239_)
                     (if (eq? '#\, _$e1300_)
                         (let _lp21306_ ((_xi1308_ _xi1298_)
                                         (_digits1309_ '()))
                           (if (let ()
                                 (declare (not safe))
                                 (##fx< _xi1308_ _len1243_))
                               (let ((_next1311_
                                      (let ()
                                        (declare (not safe))
                                        (##string-ref _str1241_ _xi1308_)))
                                     (_xi1312_
                                      (let ()
                                        (declare (not safe))
                                        (##fx+ _xi1308_ '1))))
                                 (if (char-numeric? _next1311_)
                                     (_lp21306_
                                      _xi1312_
                                      (cons _next1311_ _digits1309_))
                                     (if (and (memq _next1311_ '(#\f #\F))
                                              (not (null? _digits1309_)))
                                         (std/format#format-fixed-float
                                          (std/format#chars->number
                                           (reverse _width1295_))
                                          (std/format#chars->number
                                           (reverse _digits1309_))
                                          _K1237_
                                          _xi1312_
                                          _rest1239_)
                                         (error '"Bad format string; malformed fixed width specifier"
                                                _str1241_
                                                (std/format#current-format-args)))))
                               (error '"Bad format string; malformed fixed width specifier"
                                      _str1241_
                                      (std/format#current-format-args))))
                         (if (char-numeric? _next1297_)
                             (_lp1292_ _xi1298_ (cons _next1297_ _width1295_))
                             (let ((_$e1314_
                                    (table-ref
                                     std/format#dispatch-table
                                     _next1297_
                                     '#f)))
                               (if _$e1314_
                                   ((lambda (_f1317_)
                                      (std/format#format-fixed-generic
                                       (std/format#chars->number
                                        (reverse _width1295_))
                                       _f1317_
                                       _next1297_
                                       _xi1298_
                                       _rest1239_
                                       _K1237_))
                                    _$e1314_)
                                   (error '"Unknown format specifier"
                                          _str1241_
                                          _next1297_))))))))
             (error '"Bad format string; malformed fixed width specifier"
                    _str1241_
                    (std/format#current-format-args)))))))
  (table-set!
   std/format#dispatch-table
   '#\8
   (lambda (_char1153_ _K1154_ _xi1155_ _rest1156_)
     (let* ((_str1158_ (std/format#current-format-string))
            (_len1160_
             (let () (declare (not safe)) (##string-length _str1158_))))
       (let _lp1209_ ((_xi1211_ _xi1155_) (_width1212_ (cons _char1153_ '())))
         (if (let () (declare (not safe)) (##fx< _xi1211_ _len1160_))
             (let ((_next1214_
                    (let ()
                      (declare (not safe))
                      (##string-ref _str1158_ _xi1211_)))
                   (_xi1215_
                    (let () (declare (not safe)) (##fx+ _xi1211_ '1))))
               (let ((_$e1217_ _next1214_))
                 (if (or (eq? '#\f _$e1217_) (eq? '#\F _$e1217_))
                     (std/format#format-fixed-float
                      (std/format#chars->number (reverse _width1212_))
                      '#f
                      _K1154_
                      _xi1215_
                      _rest1156_)
                     (if (eq? '#\, _$e1217_)
                         (let _lp21223_ ((_xi1225_ _xi1215_)
                                         (_digits1226_ '()))
                           (if (let ()
                                 (declare (not safe))
                                 (##fx< _xi1225_ _len1160_))
                               (let ((_next1228_
                                      (let ()
                                        (declare (not safe))
                                        (##string-ref _str1158_ _xi1225_)))
                                     (_xi1229_
                                      (let ()
                                        (declare (not safe))
                                        (##fx+ _xi1225_ '1))))
                                 (if (char-numeric? _next1228_)
                                     (_lp21223_
                                      _xi1229_
                                      (cons _next1228_ _digits1226_))
                                     (if (and (memq _next1228_ '(#\f #\F))
                                              (not (null? _digits1226_)))
                                         (std/format#format-fixed-float
                                          (std/format#chars->number
                                           (reverse _width1212_))
                                          (std/format#chars->number
                                           (reverse _digits1226_))
                                          _K1154_
                                          _xi1229_
                                          _rest1156_)
                                         (error '"Bad format string; malformed fixed width specifier"
                                                _str1158_
                                                (std/format#current-format-args)))))
                               (error '"Bad format string; malformed fixed width specifier"
                                      _str1158_
                                      (std/format#current-format-args))))
                         (if (char-numeric? _next1214_)
                             (_lp1209_ _xi1215_ (cons _next1214_ _width1212_))
                             (let ((_$e1231_
                                    (table-ref
                                     std/format#dispatch-table
                                     _next1214_
                                     '#f)))
                               (if _$e1231_
                                   ((lambda (_f1234_)
                                      (std/format#format-fixed-generic
                                       (std/format#chars->number
                                        (reverse _width1212_))
                                       _f1234_
                                       _next1214_
                                       _xi1215_
                                       _rest1156_
                                       _K1154_))
                                    _$e1231_)
                                   (error '"Unknown format specifier"
                                          _str1158_
                                          _next1214_))))))))
             (error '"Bad format string; malformed fixed width specifier"
                    _str1158_
                    (std/format#current-format-args)))))))
  (table-set!
   std/format#dispatch-table
   '#\9
   (lambda (_char1070_ _K1071_ _xi1072_ _rest1073_)
     (let* ((_str1075_ (std/format#current-format-string))
            (_len1077_
             (let () (declare (not safe)) (##string-length _str1075_))))
       (let _lp1126_ ((_xi1128_ _xi1072_) (_width1129_ (cons _char1070_ '())))
         (if (let () (declare (not safe)) (##fx< _xi1128_ _len1077_))
             (let ((_next1131_
                    (let ()
                      (declare (not safe))
                      (##string-ref _str1075_ _xi1128_)))
                   (_xi1132_
                    (let () (declare (not safe)) (##fx+ _xi1128_ '1))))
               (let ((_$e1134_ _next1131_))
                 (if (or (eq? '#\f _$e1134_) (eq? '#\F _$e1134_))
                     (std/format#format-fixed-float
                      (std/format#chars->number (reverse _width1129_))
                      '#f
                      _K1071_
                      _xi1132_
                      _rest1073_)
                     (if (eq? '#\, _$e1134_)
                         (let _lp21140_ ((_xi1142_ _xi1132_)
                                         (_digits1143_ '()))
                           (if (let ()
                                 (declare (not safe))
                                 (##fx< _xi1142_ _len1077_))
                               (let ((_next1145_
                                      (let ()
                                        (declare (not safe))
                                        (##string-ref _str1075_ _xi1142_)))
                                     (_xi1146_
                                      (let ()
                                        (declare (not safe))
                                        (##fx+ _xi1142_ '1))))
                                 (if (char-numeric? _next1145_)
                                     (_lp21140_
                                      _xi1146_
                                      (cons _next1145_ _digits1143_))
                                     (if (and (memq _next1145_ '(#\f #\F))
                                              (not (null? _digits1143_)))
                                         (std/format#format-fixed-float
                                          (std/format#chars->number
                                           (reverse _width1129_))
                                          (std/format#chars->number
                                           (reverse _digits1143_))
                                          _K1071_
                                          _xi1146_
                                          _rest1073_)
                                         (error '"Bad format string; malformed fixed width specifier"
                                                _str1075_
                                                (std/format#current-format-args)))))
                               (error '"Bad format string; malformed fixed width specifier"
                                      _str1075_
                                      (std/format#current-format-args))))
                         (if (char-numeric? _next1131_)
                             (_lp1126_ _xi1132_ (cons _next1131_ _width1129_))
                             (let ((_$e1148_
                                    (table-ref
                                     std/format#dispatch-table
                                     _next1131_
                                     '#f)))
                               (if _$e1148_
                                   ((lambda (_f1151_)
                                      (std/format#format-fixed-generic
                                       (std/format#chars->number
                                        (reverse _width1129_))
                                       _f1151_
                                       _next1131_
                                       _xi1132_
                                       _rest1073_
                                       _K1071_))
                                    _$e1148_)
                                   (error '"Unknown format specifier"
                                          _str1075_
                                          _next1131_))))))))
             (error '"Bad format string; malformed fixed width specifier"
                    _str1075_
                    (std/format#current-format-args)))))))
  (define std/format#format-fixed-generic
    (lambda (_width1050_ _f1051_ _next1052_ _xi1053_ _rest1054_ _K1055_)
      (let* ((_xi*1057_ '#f)
             (_rest*1059_ '#f)
             (_K*1064_
              (lambda (_xi1061_ _rest1062_)
                (set! _xi*1057_ _xi1061_)
                (set! _rest*1059_ _rest1062_)))
             (_str1067_
              (with-output-to-string
               '()
               (lambda () (_f1051_ _next1052_ _K*1064_ _xi1053_ _rest1054_)))))
        (display (std/format#pad-string__0 _str1067_ _width1050_))
        (_K1055_ _xi*1057_ _rest*1059_))))
  (define std/format#format-fixed-float
    (lambda (_width972_ _digits973_ _K974_ _xi975_ _rest976_)
      (letrec ((_format-fixed978_
                (lambda (_arg1031_ _digits1032_)
                  (if (number? _arg1031_)
                      (let ((_real1034_ (real-part _arg1031_))
                            (_imag1035_ (imag-part _arg1031_)))
                        (if (not (zero? _imag1035_))
                            (string-append
                             (_format-fixed978_ _real1034_ _digits1032_)
                             (if (and (finite? _imag1035_)
                                      (positive? _imag1035_))
                                 '"+"
                                 '"")
                             (_format-fixed978_ _imag1035_ _digits1032_)
                             '"i")
                            (if (not (finite? _real1034_))
                                (number->string _real1034_)
                                (if _digits1032_
                                    (let* ((_shift1037_
                                            (expt '10 _digits1032_))
                                           (_num1039_
                                            (round (* (inexact->exact
                                                       _real1034_)
                                                      _shift1037_)))
                                           (_absnum1041_ (abs _num1039_))
                                           (_pre-str1043_
                                            (number->string
                                             (quotient
                                              _absnum1041_
                                              _shift1037_)))
                                           (_pre-str1045_
                                            (if (negative? _num1039_)
                                                (string-append
                                                 '"-"
                                                 _pre-str1043_)
                                                _pre-str1043_))
                                           (_frac-str1047_
                                            (number->string
                                             (remainder
                                              _absnum1041_
                                              _shift1037_))))
                                      (_compose-float979_
                                       _digits1032_
                                       _pre-str1045_
                                       _frac-str1047_))
                                    (_pad-zeros980_
                                     (number->string
                                      (exact->inexact _arg1031_)))))))
                      (error '"Bad argument for float format; expected number"
                             (std/format#current-format-string)
                             (std/format#current-format-args)
                             _arg1031_))))
               (_compose-float979_
                (lambda (_digits1025_ _pre-str1026_ _frac-str1027_)
                  (let ((_frac-len1029_ (string-length _frac-str1027_)))
                    (if (let ()
                          (declare (not safe))
                          (##fx< _frac-len1029_ _digits1025_))
                        (string-append
                         _pre-str1026_
                         '"."
                         (make-string
                          (let ()
                            (declare (not safe))
                            (##fx- _digits1025_ _frac-len1029_))
                          '#\0)
                         _frac-str1027_)
                        (if (let ()
                              (declare (not safe))
                              (##fx= _frac-len1029_ _digits1025_))
                            (string-append _pre-str1026_ '"." _frac-str1027_)
                            (if (let ()
                                  (declare (not safe))
                                  (##fx= _digits1025_ '0))
                                (if (equal? _pre-str1026_ '"-0")
                                    '"0"
                                    _pre-str1026_)
                                (error '"BUG: compose-float"
                                       _digits1025_
                                       _pre-str1026_
                                       _frac-str1027_)))))))
               (_pad-zeros980_
                (lambda (_str1020_)
                  (let ((_dot1022_ (string-index _str1020_ '#\.))
                        (_len1023_ (string-length _str1020_)))
                    (if (not _dot1022_)
                        _str1020_
                        (if (let () (declare (not safe)) (##fxzero? _dot1022_))
                            (string-append '"0" _str1020_)
                            (if (and (let ()
                                       (declare (not safe))
                                       (##fx= _dot1022_ '1))
                                     (eq? (let ()
                                            (declare (not safe))
                                            (##string-ref _str1020_ '0))
                                          '#\-))
                                (string-append
                                 '"-0"
                                 (substring _str1020_ '1 _len1023_))
                                (if (let ((__tmp6563
                                           (let ()
                                             (declare (not safe))
                                             (##fx+ _dot1022_ '1))))
                                      (declare (not safe))
                                      (##fx= __tmp6563 _len1023_))
                                    (string-append _str1020_ '"0")
                                    _str1020_))))))))
        (let* ((_width985_
                (let ((_$e982_ _width972_)) (if _$e982_ _$e982_ '0)))
               (_rest986994_ _rest976_)
               (_else9881002_
                (lambda ()
                  (error '"Missing format argument"
                         (std/format#current-format-string)
                         (std/format#current-format-args))))
               (_K9901008_
                (lambda (_rest1005_ _arg1006_)
                  (display (std/format#pad-string__0
                            (_format-fixed978_ _arg1006_ _digits973_)
                            _width985_))
                  (_K974_ _xi975_ _rest1005_))))
          (if (let () (declare (not safe)) (##pair? _rest986994_))
              (let ((_hd9911011_
                     (let () (declare (not safe)) (##car _rest986994_)))
                    (_tl9921013_
                     (let () (declare (not safe)) (##cdr _rest986994_))))
                (let* ((_arg1016_ _hd9911011_) (_rest1018_ _tl9921013_))
                  (_K9901008_ _rest1018_ _arg1016_)))
              (_else9881002_))))))
  (define std/format#chars->number
    (lambda (_chars970_) (string->number (apply string _chars970_))))
  (define std/format#pad-string__%
    (lambda (_str952_ _width953_ _char954_)
      (let ((_len956_ (string-length _str952_)))
        (if (let () (declare (not safe)) (##fx< _len956_ _width953_))
            (string-append
             (make-string
              (let () (declare (not safe)) (##fx- _width953_ _len956_))
              _char954_)
             _str952_)
            _str952_))))
  (define std/format#pad-string__0
    (lambda (_str961_ _width962_)
      (let ((_char964_ '#\space))
        (std/format#pad-string__% _str961_ _width962_ _char964_))))
  (define std/format#pad-string
    (lambda _g6565_
      (let ((_g6564_ (let () (declare (not safe)) (##length _g6565_))))
        (cond ((let () (declare (not safe)) (##fx= _g6564_ 2))
               (apply std/format#pad-string__0 _g6565_))
              ((let () (declare (not safe)) (##fx= _g6564_ 3))
               (apply std/format#pad-string__% _g6565_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/format#pad-string
                _g6565_)))))))
