/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class BasicTextJdkLogFormatter
extends Formatter {
    public static final String LS = System.getProperty("line.separator");
    protected boolean withTime = true;
    protected SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");

    public BasicTextJdkLogFormatter(boolean bl) {
        this.withTime = bl;
    }

    public BasicTextJdkLogFormatter() {
    }

    @Override
    public String format(LogRecord logRecord) {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.withTime) {
            stringBuilder.append(this.sdf.format(new Date(logRecord.getMillis())) + "  ");
        }
        stringBuilder.append(logRecord.getLevel() + "  " + this.formatMessage(logRecord));
        if (logRecord.getThrown() != null) {
            StringWriter stringWriter = new StringWriter();
            logRecord.getThrown().printStackTrace(new PrintWriter(stringWriter));
            stringBuilder.append(LS + stringWriter);
        }
        return stringBuilder.toString() + LS;
    }
}

