/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.help;

import java.util.Arrays;
import java.util.Enumeration;
import javax.help.HelpSet;
import javax.help.JHelpSearchNavigator;
import javax.help.NavigatorView;
import javax.help.plaf.basic.BasicSearchNavigatorUI;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import org.apache.log4j.Logger;

public class ZapBasicSearchNavigatorUI
extends BasicSearchNavigatorUI {
    private static final Logger LOGGER = Logger.getLogger(ZapBasicSearchNavigatorUI.class);

    public ZapBasicSearchNavigatorUI(JHelpSearchNavigator b) {
        super(b);
    }

    protected void addSubHelpSets(HelpSet hs) {
        Enumeration e = hs.getHelpSets();
        while (e.hasMoreElements()) {
            HelpSet ehs = (HelpSet)e.nextElement();
            Arrays.stream(ehs.getNavigatorViews()).forEach(view -> this.mergeSearchView((NavigatorView)view, ehs));
            this.addSubHelpSets(ehs);
        }
    }

    private void mergeSearchView(NavigatorView view, HelpSet ehs) {
        try {
            if (this.searchnav.canMerge(view)) {
                this.searchnav.merge(view);
            }
        }
        catch (IllegalArgumentException ex) {
            StringBuilder logMessage = new StringBuilder(150);
            logMessage.append("Failed to merge Search view [").append(view.getName()).append("] ");
            logMessage.append("from HelpSet [").append(ehs.getTitle()).append("]: ");
            logMessage.append(ex.getMessage());
            LOGGER.warn((Object)logMessage.toString());
        }
    }

    public static ComponentUI createUI(JComponent x) {
        return new ZapBasicSearchNavigatorUI((JHelpSearchNavigator)x);
    }
}

