/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.parosproxy.paros.CommandLine;
import org.parosproxy.paros.control.Control;
import org.zaproxy.zap.ZapBootstrap;
import org.zaproxy.zap.control.AddOn;
import org.zaproxy.zap.control.AddOnLoader;
import org.zaproxy.zap.control.AddOnRunIssuesUtils;
import org.zaproxy.zap.control.ExtensionFactory;
import org.zaproxy.zap.extension.autoupdate.ExtensionAutoUpdate;
import org.zaproxy.zap.model.SessionUtils;

abstract class HeadlessBootstrap
extends ZapBootstrap {
    public HeadlessBootstrap(CommandLine args) {
        super(args);
    }

    protected Control initControl() {
        Control.initSingletonWithoutViewAndProxy(this.getControlOverrides());
        return Control.getSingleton();
    }

    protected abstract Logger getLogger();

    protected boolean handleCmdLineSessionArgsSynchronously(Control control) {
        if (this.getArgs().isEnabled("-session") && this.getArgs().isEnabled("-newsession")) {
            System.err.println("Error: Invalid command line options: option '-session' not allowed with option '-newsession'");
            return false;
        }
        if (this.getArgs().isEnabled("-session")) {
            Path sessionPath = SessionUtils.getSessionPath(this.getArgs().getArgument("-session"));
            String absolutePath = sessionPath.toAbsolutePath().toString();
            try {
                control.runCommandLineOpenSession(absolutePath);
            }
            catch (Exception e) {
                this.getLogger().error((Object)e.getMessage(), (Throwable)e);
                System.err.println("Failed to open session: " + absolutePath);
                e.printStackTrace(System.err);
                return false;
            }
        }
        if (this.getArgs().isEnabled("-newsession")) {
            Path sessionPath = SessionUtils.getSessionPath(this.getArgs().getArgument("-newsession"));
            String absolutePath = sessionPath.toAbsolutePath().toString();
            if (Files.exists(sessionPath, new LinkOption[0])) {
                System.err.println("Failed to create a new session, file already exists: " + absolutePath);
                return false;
            }
            try {
                control.runCommandLineNewSession(absolutePath);
            }
            catch (Exception e) {
                this.getLogger().error((Object)e.getMessage(), (Throwable)e);
                System.err.println("Failed to create a new session: " + absolutePath);
                e.printStackTrace(System.err);
                return false;
            }
        }
        return true;
    }

    protected void warnAddOnsAndExtensionsNoLongerRunnable() {
        AddOnLoader addOnLoader = ExtensionFactory.getAddOnLoader();
        List<String> idsAddOnsNoLongerRunning = addOnLoader.getIdsAddOnsWithRunningIssuesSinceLastRun();
        if (idsAddOnsNoLongerRunning.isEmpty()) {
            return;
        }
        ArrayList<AddOn> addOnsNoLongerRunning = new ArrayList<AddOn>(idsAddOnsNoLongerRunning.size());
        for (String id : idsAddOnsNoLongerRunning) {
            addOnsNoLongerRunning.add(addOnLoader.getAddOnCollection().getAddOn(id));
        }
        for (AddOn addOn : addOnsNoLongerRunning) {
            AddOn.AddOnRunRequirements requirements = addOn.calculateRunRequirements(addOnLoader.getAddOnCollection().getAddOns());
            List<String> issues = AddOnRunIssuesUtils.getRunningIssues(requirements);
            if (issues.isEmpty()) {
                issues = AddOnRunIssuesUtils.getExtensionsRunningIssues(requirements);
            }
            this.getLogger().warn((Object)("Add-on \"" + addOn.getId() + "\" or its extensions will no longer be run until its requirements are restored: " + issues));
        }
    }

    protected static void checkForUpdates() {
        ExtensionAutoUpdate eau = Control.getSingleton().getExtensionLoader().getExtension(ExtensionAutoUpdate.class);
        if (eau != null) {
            eau.alertIfNewVersions();
        }
    }
}

